/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetracelium.compat.twilightforest.effects;

import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.StatsHelper;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatFormat;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatFormat;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterMultiValue;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import twilightforest.entity.monster.LoyalZombie;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;

public class ReanimatingEffect {
    public static final ItemEffect reanimatingEffect = ItemEffect.get((String)"reanimating");

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity killer;
        ItemStack itemStack;
        Entity entity2;
        if ("trident".equals(event.getSource().m_19385_()) && (entity2 = event.getSource().m_7640_()) instanceof ThrownModularItemEntity) {
            ThrownModularItemEntity modularEntity = (ThrownModularItemEntity)entity2;
            itemStack = modularEntity.getThrownStack();
            killer = modularEntity.m_19749_();
        } else {
            itemStack = Optional.ofNullable(event.getSource().m_7639_()).filter(entity -> entity instanceof Player).map(entity -> (LivingEntity)entity).map(LivingEntity::m_21205_).filter(stack -> stack.m_41720_() instanceof IModularItem).orElse(null);
            killer = event.getSource().m_7639_();
        }
        if (itemStack != null) {
            Level level = event.getEntity().m_9236_();
            int effectLevel = EffectHelper.getEffectLevel((ItemStack)itemStack, (ItemEffect)reanimatingEffect);
            if (!level.f_46443_ && !MobType.f_21641_.equals(event.getEntity().m_6336_()) && effectLevel > 0) {
                ServerPlayer player = CastOptional.cast((Object)killer, ServerPlayer.class).orElse(null);
                ReanimatingEffect.spawnZombie(level, killer, event.getEntity().m_20318_(0.0f), effectLevel);
                itemStack.m_220157_((int)Math.ceil((double)itemStack.m_41776_() * 0.01 * (double)EffectHelper.getEffectEfficiency((ItemStack)itemStack, (ItemEffect)reanimatingEffect)), level.m_213780_(), player);
            }
        }
    }

    static void spawnZombie(Level level, Entity owner, Vec3 spawnPosition, int duration) {
        LoyalZombie zombie = (LoyalZombie)((EntityType)TFEntities.LOYAL_ZOMBIE.get()).m_20615_(level);
        zombie.m_20219_(spawnPosition);
        if (level.m_45756_((Entity)zombie, zombie.m_20191_())) {
            zombie.m_21373_();
            zombie.m_7105_(true);
            zombie.m_21816_(owner.m_20148_());
            zombie.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration * 20, 1));
            level.m_7967_((Entity)zombie);
            level.m_220400_(owner, GameEvent.f_157810_, spawnPosition);
            zombie.m_5496_((SoundEvent)TFSounds.LOYAL_ZOMBIE_SUMMON.get(), 1.0f, zombie.m_6100_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        StatGetterEffectLevel statGetter = new StatGetterEffectLevel(reanimatingEffect, 1.0);
        StatGetterEffectEfficiency efficiencyGetter = new StatGetterEffectEfficiency(reanimatingEffect, 1.0);
        GuiStatBar statBar = new GuiStatBar(0, 0, 59, "tetra.stats.reanimating", 0.0, 120.0, false, false, false, (IStatGetter)statGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterMultiValue("tetra.stats.reanimating.tooltip", StatsHelper.withStats((IStatGetter[])new IStatGetter[]{statGetter, efficiencyGetter}), StatsHelper.withFormat((IStatFormat[])new IStatFormat[]{StatFormat.noDecimal, StatFormat.noDecimal})));
        WorkbenchStatsGui.addBar((GuiStatBase)statBar);
        HoloStatsGui.addBar((GuiStatBase)statBar);
    }
}

