/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.createfluidstuffs.items;

import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BucketItem
extends Item {
    public static final int capacity = 2000;

    public BucketItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemStack(stack, 2000);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        LazyOptional capability = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (!capability.isPresent()) {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
            return;
        }
        FluidStack fluid = ((IFluidHandlerItem)capability.orElse(null)).getFluidInTank(0);
        if (fluid.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"createfluidstuffs.tooltips.empty").m_130940_(ChatFormatting.GRAY));
        } else {
            CreateLang.fluidName((FluidStack)fluid).style(ChatFormatting.GOLD).addTo(tooltip);
            tooltip.add((Component)Component.m_237113_((String)(Integer.toString(fluid.getAmount()) + "mB")).m_130940_(ChatFormatting.WHITE));
        }
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockEntity be = pContext.m_43725_().m_7702_(pContext.m_8083_());
        if (be == null) {
            return InteractionResult.PASS;
        }
        IFluidHandler blockFluidHandler = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, pContext.m_43719_()).orElse(null);
        if (blockFluidHandler == null) {
            return InteractionResult.PASS;
        }
        ItemStack bucket = pContext.m_43722_();
        IFluidHandlerItem bucketFluidHandler = (IFluidHandlerItem)bucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
        if (bucketFluidHandler == null) {
            return InteractionResult.PASS;
        }
        FluidStack bucketCanDrain = bucketFluidHandler.drain(2000, IFluidHandler.FluidAction.SIMULATE);
        if (bucketCanDrain == FluidStack.EMPTY) {
            FluidStack canDrain = blockFluidHandler.drain(2000, IFluidHandler.FluidAction.SIMULATE);
            if (canDrain == FluidStack.EMPTY) {
                return InteractionResult.PASS;
            }
            canDrain = blockFluidHandler.drain(canDrain, IFluidHandler.FluidAction.EXECUTE);
            bucketFluidHandler.fill(canDrain, IFluidHandler.FluidAction.EXECUTE);
        } else {
            int canFillAmount = blockFluidHandler.fill(bucketCanDrain, IFluidHandler.FluidAction.SIMULATE);
            if (canFillAmount == 0) {
                return InteractionResult.PASS;
            }
            bucketCanDrain.setAmount(canFillAmount);
            FluidStack toDrain = bucketFluidHandler.drain(bucketCanDrain, IFluidHandler.FluidAction.EXECUTE);
            blockFluidHandler.fill(toDrain, IFluidHandler.FluidAction.EXECUTE);
        }
        return InteractionResult.SUCCESS;
    }
}

