/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.createfluidstuffs.foundation.fluid;

import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class SmartMultiFluidTank
implements IFluidHandler,
IFluidTank {
    private Consumer<FluidStack[]> updateCallback;
    int tanks;
    protected int capacity;
    protected Predicate<FluidStack> validator;
    @NotNull
    protected FluidStack[] multi_fluid;

    public SmartMultiFluidTank(int capacity, int tanks, Consumer<FluidStack[]> updateCallback) {
        this.capacity = capacity;
        this.validator = e -> true;
        this.updateCallback = updateCallback;
        this.tanks = tanks;
        this.multi_fluid = new FluidStack[tanks];
        this.resetTanks();
    }

    public SmartMultiFluidTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public SmartMultiFluidTank setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public int getFluidAmount() {
        int amount = 0;
        for (int i = 0; i < this.getTanks(); ++i) {
            amount += this.multi_fluid[i].getAmount();
        }
        return amount;
    }

    public int getFluidAmount(int tank) {
        if (tank < this.getTanks()) {
            return this.multi_fluid[tank].getAmount();
        }
        return 0;
    }

    public void resetTanks() {
        for (int i = 0; i < this.getTanks(); ++i) {
            this.multi_fluid[i] = FluidStack.EMPTY;
        }
    }

    protected void onContentsChanged() {
        this.updateCallback.accept(this.getFluids());
    }

    public void setFluid(FluidStack stack) {
        for (int i = 1; i < this.tanks; ++i) {
            this.multi_fluid[i] = FluidStack.EMPTY;
        }
        this.setFluid(0, stack);
    }

    public void setFluid(int tank, FluidStack stack) {
        if (tank < this.tanks) {
            this.multi_fluid[tank] = stack;
            this.updateCallback.accept(this.getFluids());
        }
    }

    public SmartMultiFluidTank readFromNBT(CompoundTag nbt) {
        for (int i = 0; i < this.getTanks() && nbt.m_128425_(Integer.toString(i), 10); ++i) {
            CompoundTag fluid_nbt = nbt.m_128469_(Integer.toString(i));
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)fluid_nbt);
            this.setFluid(i, fluid);
        }
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        for (int i = 0; i < this.getTanks(); ++i) {
            CompoundTag fluid_nbt = new CompoundTag();
            this.multi_fluid[i].writeToNBT(fluid_nbt);
            nbt.m_128365_(Integer.toString(i), (Tag)fluid_nbt);
        }
        return nbt;
    }

    public int getTanks() {
        return this.tanks;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank < this.getTanks()) {
            return this.multi_fluid[tank];
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    OptionalInt getFirstAvailableTank(FluidStack resource) {
        int first_empty = -1;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (this.multi_fluid[i].isEmpty() && first_empty < 0) {
                first_empty = i;
            }
            if (!this.multi_fluid[i].isFluidEqual(resource)) continue;
            return OptionalInt.of(i);
        }
        if (first_empty >= 0) {
            return OptionalInt.of(first_empty);
        }
        return OptionalInt.empty();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (this.getSpace() == 0) {
            return 0;
        }
        OptionalInt target_tank_opt = this.getFirstAvailableTank(resource);
        if (action.simulate()) {
            if (target_tank_opt.isEmpty()) {
                return 0;
            }
            return Math.min(this.getSpace(), resource.getAmount());
        }
        int target_tank = target_tank_opt.getAsInt();
        if (this.multi_fluid[target_tank].isEmpty()) {
            this.multi_fluid[target_tank] = new FluidStack(resource, Math.min(this.getSpace(), resource.getAmount()));
            this.onContentsChanged();
            return this.multi_fluid[target_tank].getAmount();
        }
        int filled = this.getSpace();
        if (resource.getAmount() < filled) {
            this.multi_fluid[target_tank].grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.multi_fluid[target_tank].grow(filled);
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        OptionalInt target_tank_opt = this.getFirstAvailableTank(resource);
        if (target_tank_opt.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int target_tank = target_tank_opt.getAsInt();
        if (this.multi_fluid[target_tank].isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drained = Math.min(this.multi_fluid[target_tank].getAmount(), resource.getAmount());
        FluidStack stack = new FluidStack(this.multi_fluid[target_tank], drained);
        if (action.execute() && drained > 0) {
            this.multi_fluid[target_tank].shrink(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.getTanks(); ++i) {
            if (this.multi_fluid[i].isEmpty()) continue;
            int drained = Math.min(maxDrain, this.multi_fluid[i].getAmount());
            FluidStack stack = new FluidStack(this.multi_fluid[i], drained);
            if (action.execute() && drained > 0) {
                this.multi_fluid[i].shrink(drained);
                this.onContentsChanged();
            }
            return stack;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack getFluid() {
        for (int i = 0; i < this.getTanks(); ++i) {
            if (this.multi_fluid[i].isEmpty()) continue;
            return this.multi_fluid[i];
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack[] getFluids() {
        return this.multi_fluid;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getTanks(); ++i) {
            if (this.multi_fluid[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getSpace() {
        return Math.max(0, this.capacity - this.getFluidAmount());
    }
}

