/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.item.block_placer;

import com.simibubi.create.content.equipment.zapper.ConfigureZapperPacket;
import com.simibubi.create.content.equipment.zapper.ZapperScreen;
import com.simibubi.create.content.equipment.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.hail.create_fantasizing.CFAGuiTextures;
import dev.hail.create_fantasizing.event.CFAPackets;
import dev.hail.create_fantasizing.item.block_placer.BPBrush;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerBrushes;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerTools;
import dev.hail.create_fantasizing.item.block_placer.ConfigureBlockPlacerPacket;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class BlockPlacerScreen
extends ZapperScreen {
    protected CFAGuiTextures background;
    protected final Component placementSection = CreateLang.translateDirect((String)"gui.terrainzapper.placement", (Object[])new Object[0]);
    protected final Component toolSection = CreateLang.translateDirect((String)"gui.terrainzapper.tool", (Object[])new Object[0]);
    protected final List<Component> brushOptions = CreateLang.translatedOptions((String)"gui.terrainzapper.brush", (String[])new String[]{"cuboid", "sphere", "cylinder", "surface", "cluster"});
    protected List<IconButton> toolButtons;
    protected IconButton destroyButton;
    protected Indicator destoryModeIndicator;
    protected List<IconButton> placementButtons;
    protected ScrollInput brushInput;
    protected Label brushLabel;
    protected List<ScrollInput> brushParams = new ArrayList<ScrollInput>(3);
    protected List<Label> brushParamLabels = new ArrayList<Label>(3);
    protected IconButton followDiagonals;
    protected IconButton acrossMaterials;
    protected Indicator followDiagonalsIndicator;
    protected Indicator acrossMaterialsIndicator;
    protected BlockPlacerBrushes currentBrush;
    protected int[] currentBrushParams = new int[]{1, 1, 1};
    protected boolean currentFollowDiagonals;
    protected boolean currentAcrossMaterials;
    protected BlockPlacerTools currentTool;
    protected PlacementOptions currentPlacement;
    protected boolean currentDestroyMode;

    public BlockPlacerScreen(ItemStack zapper, InteractionHand hand) {
        super(AllGuiTextures.TERRAINZAPPER, zapper, hand);
        this.background = CFAGuiTextures.BLOCK_PLACER;
        this.fontColor = 0x767676;
        this.title = zapper.m_41786_();
        CompoundTag nbt = zapper.m_41784_();
        this.currentBrush = (BlockPlacerBrushes)NBTHelper.readEnum((CompoundTag)nbt, (String)"Brush", BlockPlacerBrushes.class);
        if (nbt.m_128425_("BrushParams", 10)) {
            BlockPos paramsData = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("BrushParams"));
            this.currentBrushParams[0] = paramsData.m_123341_();
            this.currentBrushParams[1] = paramsData.m_123342_();
            this.currentBrushParams[2] = paramsData.m_123343_();
            if (this.currentBrushParams[1] == 0) {
                this.currentFollowDiagonals = true;
            }
            if (this.currentBrushParams[2] == 0) {
                this.currentAcrossMaterials = true;
            }
        }
        this.currentTool = (BlockPlacerTools)NBTHelper.readEnum((CompoundTag)nbt, (String)"Tool", BlockPlacerTools.class);
        this.currentPlacement = (PlacementOptions)NBTHelper.readEnum((CompoundTag)nbt, (String)"Placement", PlacementOptions.class);
        this.currentDestroyMode = nbt.m_128471_("DestroyMode");
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.brushLabel = new Label(x + 61, y + 25, CommonComponents.f_237098_).withShadow();
        this.brushInput = new SelectionScrollInput(x + 56, y + 20, 77, 18).forOptions(this.brushOptions).titled(CreateLang.translateDirect((String)"gui.terrainzapper.brush", (Object[])new Object[0])).writingTo(this.brushLabel).calling(brushIndex -> {
            this.currentBrush = BlockPlacerBrushes.values()[brushIndex];
            this.initBrushParams(x, y);
        });
        this.brushInput.setState(this.currentBrush.ordinal());
        this.m_142416_((GuiEventListener)this.brushLabel);
        this.m_142416_((GuiEventListener)this.brushInput);
        this.initBrushParams(x, y);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.drawOnBackground(graphics, x, y);
        this.renderBlock(graphics, x, y);
        this.renderZapper(graphics, x, y);
    }

    protected void initBrushParams(int x, int y) {
        BPBrush currentBrush = this.currentBrush.get();
        this.removeWidgets(this.brushParamLabels);
        this.removeWidgets(this.brushParams);
        this.brushParamLabels.clear();
        this.brushParams.clear();
        for (int index = 0; index < 3; ++index) {
            Label label = new Label(x + 65 + 20 * index, y + 45, CommonComponents.f_237098_).withShadow();
            int finalIndex = index;
            ScrollInput input = new ScrollInput(x + 56 + 20 * index, y + 40, 18, 18).withRange(currentBrush.getMin(index), currentBrush.getMax(index) + 1).writingTo(label).titled(currentBrush.getParamLabel(index).m_6879_()).calling(state -> {
                this.currentBrushParams[finalIndex] = state;
                label.m_252865_(x + 65 + 20 * finalIndex - this.f_96547_.m_92852_((FormattedText)label.text) / 2);
            });
            input.setState(this.currentBrushParams[index]);
            input.onChanged();
            if (index >= currentBrush.amtParams) {
                input.f_93624_ = false;
                label.f_93624_ = false;
                input.f_93623_ = false;
            }
            this.brushParamLabels.add(label);
            this.brushParams.add(input);
        }
        this.addRenderableWidgets(this.brushParamLabels);
        this.addRenderableWidgets(this.brushParams);
        if (this.followDiagonals != null) {
            this.m_169411_((GuiEventListener)this.followDiagonals);
            this.m_169411_((GuiEventListener)this.followDiagonalsIndicator);
            this.m_169411_((GuiEventListener)this.acrossMaterials);
            this.m_169411_((GuiEventListener)this.acrossMaterialsIndicator);
            this.followDiagonals = null;
            this.followDiagonalsIndicator = null;
            this.acrossMaterials = null;
            this.acrossMaterialsIndicator = null;
        }
        if (currentBrush.hasConnectivityOptions()) {
            int x1 = x + 100;
            int y1 = y + 79;
            this.followDiagonalsIndicator = new Indicator(x1, y1 - 6, CommonComponents.f_237098_);
            this.followDiagonals = new IconButton(x1, y1, (ScreenElement)AllIcons.I_FOLLOW_DIAGONAL);
            this.acrossMaterialsIndicator = new Indicator(x1 += 18, y1 - 6, CommonComponents.f_237098_);
            this.acrossMaterials = new IconButton(x1, y1, (ScreenElement)AllIcons.I_FOLLOW_MATERIAL);
            this.followDiagonals.withCallback(() -> {
                this.followDiagonalsIndicator.state = this.followDiagonalsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentFollowDiagonals = !this.currentFollowDiagonals;
            });
            this.followDiagonals.setToolTip((Component)CreateLang.translateDirect((String)"gui.terrainzapper.searchDiagonal", (Object[])new Object[0]));
            this.acrossMaterials.withCallback(() -> {
                this.acrossMaterialsIndicator.state = this.acrossMaterialsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentAcrossMaterials = !this.currentAcrossMaterials;
            });
            this.acrossMaterials.setToolTip((Component)CreateLang.translateDirect((String)"gui.terrainzapper.searchFuzzy", (Object[])new Object[0]));
            this.m_142416_((GuiEventListener)this.followDiagonals);
            this.m_142416_((GuiEventListener)this.followDiagonalsIndicator);
            this.m_142416_((GuiEventListener)this.acrossMaterials);
            this.m_142416_((GuiEventListener)this.acrossMaterialsIndicator);
            if (this.currentFollowDiagonals) {
                this.followDiagonalsIndicator.state = Indicator.State.ON;
            }
            if (this.currentAcrossMaterials) {
                this.acrossMaterialsIndicator.state = Indicator.State.ON;
            }
        }
        if (this.toolButtons != null) {
            this.removeWidgets(this.toolButtons);
        }
        BlockPlacerTools[] toolValues = currentBrush.getSupportedTools();
        this.toolButtons = new ArrayList<IconButton>(toolValues.length);
        for (int id = 0; id < toolValues.length; ++id) {
            BlockPlacerTools tool = toolValues[id];
            IconButton toolButton = new IconButton(x + 7 + id * 18, y + 79, (ScreenElement)tool.icon);
            toolButton.withCallback(() -> {
                this.toolButtons.forEach(b -> {
                    b.green = false;
                });
                toolButton.green = true;
                this.currentTool = tool;
            });
            toolButton.setToolTip((Component)CreateLang.translateDirect((String)("gui.terrainzapper.tool." + tool.translationKey), (Object[])new Object[0]));
            this.toolButtons.add(toolButton);
        }
        int toolIndex = -1;
        for (int i = 0; i < toolValues.length; ++i) {
            if (this.currentTool != toolValues[i]) continue;
            toolIndex = i;
        }
        if (toolIndex == -1) {
            this.currentTool = toolValues[0];
            toolIndex = 0;
        }
        this.toolButtons.get((int)toolIndex).green = true;
        this.addRenderableWidgets(this.toolButtons);
        if (this.placementButtons != null) {
            this.removeWidgets(this.placementButtons);
        }
        if (currentBrush.hasPlacementOptions()) {
            PlacementOptions[] placementValues = PlacementOptions.values();
            this.placementButtons = new ArrayList<IconButton>(placementValues.length);
            for (int id = 0; id < placementValues.length; ++id) {
                PlacementOptions option = placementValues[id];
                IconButton placementButton = new IconButton(x + 100 + id * 18, y + 79, (ScreenElement)option.icon);
                placementButton.withCallback(() -> {
                    this.placementButtons.forEach(b -> {
                        b.green = false;
                    });
                    placementButton.green = true;
                    this.currentPlacement = option;
                });
                placementButton.setToolTip((Component)CreateLang.translateDirect((String)("gui.terrainzapper.placement." + option.translationKey), (Object[])new Object[0]));
                this.placementButtons.add(placementButton);
            }
            this.placementButtons.get((int)this.currentPlacement.ordinal()).green = true;
            this.addRenderableWidgets(this.placementButtons);
        }
        this.m_169411_((GuiEventListener)this.destroyButton);
        this.m_169411_((GuiEventListener)this.destoryModeIndicator);
        this.destoryModeIndicator = new Indicator(x + 174, y + 73, CommonComponents.f_237098_);
        this.destroyButton = new IconButton(x + 174, y + 79, (ScreenElement)AllIcons.I_TRASH);
        this.destroyButton.withCallback(() -> {
            this.destoryModeIndicator.state = this.destoryModeIndicator.state == Indicator.State.OFF ? Indicator.State.RED : Indicator.State.OFF;
            this.currentDestroyMode = !this.currentDestroyMode;
        });
        this.destroyButton.setToolTip((Component)Component.m_237115_((String)"create_fantasizing.gui.block_placer.destroy_mode"));
        this.m_142416_((GuiEventListener)this.destroyButton);
        this.m_142416_((GuiEventListener)this.destoryModeIndicator);
        if (this.currentDestroyMode) {
            this.destoryModeIndicator.state = Indicator.State.RED;
        }
    }

    protected void drawOnBackground(GuiGraphics graphics, int x, int y) {
        super.drawOnBackground(graphics, x, y);
        BPBrush currentBrush = this.currentBrush.get();
        for (int index = 2; index >= currentBrush.amtParams; --index) {
            AllGuiTextures.TERRAINZAPPER_INACTIVE_PARAM.render(graphics, x + 56 + 20 * index, y + 40);
        }
        graphics.m_280614_(this.f_96547_, this.toolSection, x + 7, y + 69, this.fontColor, false);
        if (currentBrush.hasPlacementOptions()) {
            graphics.m_280614_(this.f_96547_, this.placementSection, x + 100, y + 69, this.fontColor, false);
        }
    }

    protected ConfigureZapperPacket getConfigurationPacket() {
        int brushParamY;
        int brushParamX = this.currentBrushParams[0];
        int n = this.followDiagonalsIndicator != null ? (this.followDiagonalsIndicator.state == Indicator.State.ON ? 0 : 1) : (brushParamY = this.currentBrushParams[1]);
        int brushParamZ = this.acrossMaterialsIndicator != null ? (this.acrossMaterialsIndicator.state == Indicator.State.ON ? 0 : 1) : this.currentBrushParams[2];
        return new ConfigureBlockPlacerPacket(this.hand, this.currentPattern, this.currentBrush, brushParamX, brushParamY, brushParamZ, this.currentTool, this.currentPlacement, this.currentDestroyMode);
    }

    public void m_7861_() {
        ConfigureZapperPacket packet = this.getConfigurationPacket();
        packet.configureZapper(this.zapper);
        CFAPackets.getChannel().sendToServer((Object)packet);
    }
}

