/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.logic;

import dev.xkmc.cuisinedelight.content.logic.CookTransformConfig;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.FoodType;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.logic.transform.CookTransform;
import dev.xkmc.cuisinedelight.content.logic.transform.ItemStageTransform;
import dev.xkmc.cuisinedelight.content.logic.transform.Stage;
import dev.xkmc.cuisinedelight.init.data.CDConfig;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import vectorwing.farmersdelight.common.registry.ModEffects;

@SerialClass
public class CookedFoodData {
    public static final FoodProperties BAD = new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38767_();
    @SerialClass.SerialField
    public int total;
    @SerialClass.SerialField
    public int size;
    @SerialClass.SerialField
    public int nutrition;
    @SerialClass.SerialField
    public int score;
    @SerialClass.SerialField
    public int glowstone;
    @SerialClass.SerialField
    public int redstone;
    @SerialClass.SerialField
    public HashSet<FoodType> types = new HashSet();
    @SerialClass.SerialField
    public ArrayList<Entry> entries = new ArrayList();

    @Deprecated
    public CookedFoodData() {
    }

    public CookedFoodData(CookingData data) {
        int size = 0;
        int nutrition = 0;
        float penalty = 0.0f;
        for (CookingData.CookingEntry e : data.contents) {
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(e.getItem());
            if (config == null) continue;
            boolean raw = (float)config.min_time > e.getDuration(data, 0.0f);
            boolean overcooked = (float)config.max_time < e.getDuration(data, 0.0f);
            boolean burnt = e.getMaxStirTime(data) > (float)config.stir_time;
            float badness = 0.0f;
            if (raw) {
                badness += config.raw_penalty;
            }
            if (overcooked || burnt) {
                badness += config.overcook_penalty;
            }
            int itemSize = config.size * e.getItem().m_41613_();
            penalty += (float)itemSize * badness;
            size += itemSize;
            nutrition += config.nutrition * itemSize;
            this.entries.add(new Entry(e.getItem(), itemSize, burnt, raw, overcooked));
            if (config.type == FoodType.NONE) continue;
            this.types.add(config.type);
        }
        float goodness = size == 0 ? 0.0f : Mth.m_14036_((float)(1.0f - penalty / (float)size), (float)0.0f, (float)1.0f);
        this.score = Math.round(goodness * 100.0f);
        this.size = size;
        this.total = size;
        this.nutrition = size == 0 ? 0 : Math.round(goodness * (float)nutrition / (float)size);
        this.glowstone = data.glowstone;
        this.redstone = data.redstone;
    }

    public FoodProperties toFoodData() {
        if (this.score < 60 || this.total == 0) {
            return BAD;
        }
        double mult = 1.0 + (double)(this.types.size() - 1) * (Double)CDConfig.COMMON.varietyBonus.get();
        if (this.score == 100) {
            mult += ((Double)CDConfig.COMMON.perfectionBonus.get()).doubleValue();
        }
        FoodProperties.Builder ans = new FoodProperties.Builder().m_38760_((int)(mult * 4.0)).m_38758_((float)this.nutrition * 0.1f);
        if (this.score == 100) {
            ans.m_38766_().m_38765_();
        }
        if (this.types.contains((Object)FoodType.MEAT)) {
            ans.m_38757_();
        }
        LinkedHashMap<MobEffect, EffectData> map = new LinkedHashMap<MobEffect, EffectData>();
        for (Entry e : this.entries) {
            e.addMobEffects(map, this.total);
        }
        if (this.score == 100 && this.types.size() > 1) {
            ans.effect(() -> new MobEffectInstance((MobEffect)ModEffects.NOURISHMENT.get(), (Integer)CDConfig.COMMON.nourishmentDuration.get() * this.types.size()), 1.0f);
        }
        map.forEach((k, v) -> ans.effect(() -> new MobEffectInstance(k, Math.round(v.duration), v.level()), 1.0f));
        return ans.m_38767_();
    }

    public record Entry(ItemStack stack, int itemSize, boolean burnt, boolean raw, boolean overcooked) {
        public void addMobEffects(Map<MobEffect, EffectData> map, int divisor) {
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(this.stack);
            if (config == null) {
                return;
            }
            if (this.burnt || this.raw || this.overcooked) {
                return;
            }
            for (IngredientConfig.EffectEntry e : config.effects) {
                map.compute(e.effect(), (k, v) -> {
                    float ans = 1.0f * (float)e.time() * (float)this.stack.m_41613_() / (float)divisor;
                    if (v != null) {
                        if (v.level > e.level()) {
                            return v;
                        }
                        if (v.level == e.level()) {
                            return new EffectData(v.level, v.duration + ans);
                        }
                    }
                    return new EffectData(e.level(), ans);
                });
            }
        }

        public ItemStack getEatenStack() {
            ItemStageTransform t;
            CookTransform handler = CookTransformConfig.get(this.stack);
            if (handler instanceof ItemStageTransform && (t = (ItemStageTransform)handler).stage() != Stage.RAW) {
                ItemStack ans = t.next().m_7968_();
                ans.m_41764_(this.stack.m_41613_());
                ans.m_41751_(this.stack.m_41783_());
                return ans;
            }
            return this.stack;
        }
    }

    private record EffectData(int level, float duration) {
    }
}

