/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.item;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeContainer;
import dev.xkmc.cuisinedelight.events.FoodEatenEvent;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.Configuration;

public class BaseFoodItem
extends Item {
    private static final String KEY_ROOT = "CookedFoodData";
    private static final String KEY_DISPLAY = "Display";

    public static ItemStack setResultDisplay(BaseCuisineRecipe<?> recipe, ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("min", recipe.getMinSaturationBonus());
        tag.m_128347_("max", recipe.getMaxSaturationBonus());
        stack.m_41784_().m_128365_(KEY_DISPLAY, (Tag)tag);
        return stack;
    }

    public static ItemStack setIngredientDisplay(ItemStack stack) {
        stack.m_41784_().m_128379_("cuisinedelight:display", true);
        return stack;
    }

    @Nullable
    public static CookedFoodData getData(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(KEY_ROOT);
        if (tag == null) {
            return null;
        }
        return (CookedFoodData)TagCodec.fromTag((CompoundTag)tag, CookedFoodData.class);
    }

    public static void setData(ItemStack stack, @Nullable CookedFoodData data) {
        if (data == null) {
            stack.m_41784_().m_128473_(KEY_ROOT);
            return;
        }
        Tag tag = TagCodec.valueToTag((Object)data);
        if (tag != null) {
            stack.m_41784_().m_128365_(KEY_ROOT, tag);
        }
    }

    public BaseFoodItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_41472_() {
        return true;
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        CookedFoodData data = BaseFoodItem.getData(stack);
        if (data == null) {
            return CookedFoodData.BAD;
        }
        return data.toFoodData();
    }

    @Nullable
    public FoodProperties m_41473_() {
        return CookedFoodData.BAD;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        CookedFoodData food = BaseFoodItem.getData(stack);
        super.m_5922_(stack, level, entity);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (food != null) {
                MinecraftForge.EVENT_BUS.post((Event)new FoodEatenEvent(player, food));
            }
        }
        if (food == null) {
            return this.getCraftingRemainingItem(stack);
        }
        --food.size;
        if (food.size <= 0) {
            return this.getCraftingRemainingItem(stack);
        }
        stack.m_41764_(1);
        BaseFoodItem.setData(stack, food);
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        CookedFoodData data = BaseFoodItem.getData(stack);
        if (data == null || data.score < 60) {
            return 72000;
        }
        return super.m_8105_(stack);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        int level;
        BlockPos pos = ctx.m_8083_();
        BlockState state = ctx.m_43725_().m_8055_(pos);
        ItemStack stack = ctx.m_43722_();
        if (state.m_60713_(Blocks.f_50715_) && (level = ((Integer)state.m_61143_((Property)ComposterBlock.f_51913_)).intValue()) < 7) {
            CookedFoodData data;
            if (!ctx.m_43725_().m_5776_() && (data = BaseFoodItem.getData(stack)) != null && data.size > 0) {
                if (ctx.m_43723_() == null || !ctx.m_43723_().m_150110_().f_35937_) {
                    --data.size;
                    BaseFoodItem.setData(stack, data);
                }
                if (ctx.m_43725_().m_213780_().m_188500_() < (double)0.3f) {
                    BlockState newState = (BlockState)state.m_61124_((Property)ComposterBlock.f_51913_, (Comparable)Integer.valueOf(level + 1));
                    ctx.m_43725_().m_46597_(pos, newState);
                    if (level + 1 == 7) {
                        ctx.m_43725_().m_186460_(pos, state.m_60734_(), 20);
                    }
                    ctx.m_43725_().m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)ctx.m_43723_(), (BlockState)newState));
                    ctx.m_43725_().m_46796_(1500, pos, 1);
                } else {
                    ctx.m_43725_().m_46796_(1500, pos, 0);
                }
                if (data.size == 0) {
                    ItemStack remain = this.getCraftingRemainingItem(stack);
                    stack.m_41774_(1);
                    if (ctx.m_43723_() != null) {
                        ctx.m_43723_().m_150109_().m_150079_(remain);
                    } else {
                        Block.m_49881_((BlockState)state, (Level)ctx.m_43725_(), (BlockPos)ctx.m_8083_(), null, null, (ItemStack)remain);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41737_(KEY_DISPLAY)) != null) {
            double min = tag.m_128459_("min");
            double d = tag.m_128459_("max");
            if (d > 0.0) {
                list.add((Component)LangData.INFO_DISPLAY.get(min, d));
            }
            return;
        }
        CookedFoodData data = BaseFoodItem.getData(stack);
        if (data == null) {
            list.add((Component)LangData.DISPLAY_FOOD.get(new Object[0]));
            return;
        }
        FoodProperties prop = data.toFoodData();
        if (prop == CookedFoodData.BAD) {
            list.add((Component)LangData.BAD_FOOD.get(new Object[0]));
        } else {
            list.add((Component)LangData.SERVE_SIZE.get(data.size));
            list.add((Component)LangData.SCORE.get(data.score));
        }
        if (Screen.m_96638_()) {
            for (CookedFoodData.Entry entry : data.entries) {
                ItemStack ingredient = entry.stack();
                if (entry.burnt()) {
                    list.add((Component)LangData.BAD_BURNT.get(ingredient.m_41786_()));
                }
                if (entry.raw()) {
                    list.add((Component)LangData.BAD_RAW.get(ingredient.m_41786_()));
                }
                if (entry.overcooked()) {
                    list.add((Component)LangData.BAD_OVERCOOKED.get(ingredient.m_41786_()));
                }
                if (entry.burnt() || entry.raw() || entry.overcooked()) continue;
                list.add((Component)LangData.GOOD.get(ingredient.m_41786_()));
            }
        } else {
            list.add((Component)LangData.SHIFT.get(new Object[0]));
            CuisineRecipeContainer cont = new CuisineRecipeContainer(data);
            for (ItemStack e : cont.list) {
                if (e.m_41619_()) continue;
                double perc = (double)Math.round(1000.0 * (double)e.m_41613_() / (double)data.total) / 10.0;
                list.add((Component)e.m_41786_().m_6881_().m_130946_(": " + perc + "%"));
            }
        }
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            for (Pair pair : prop.m_38749_()) {
                MobEffectInstance mobeffectinstance = (MobEffectInstance)pair.getFirst();
                MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
                MobEffect mobeffect = mobeffectinstance.m_19544_();
                if (mobeffectinstance.m_19564_() > 0) {
                    mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
                }
                if (mobeffectinstance.m_19557_() > 20) {
                    mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobeffectinstance, (float)1.0f)});
                }
                list.add((Component)mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_()));
            }
        }
    }

    public ItemStack displayStack(BaseCuisineRecipe<?> recipe) {
        ItemStack ans = this.m_7968_();
        CompoundTag ctag = ans.m_41698_(KEY_DISPLAY);
        ctag.m_128347_("min", recipe.getMinSaturationBonus());
        ctag.m_128347_("max", recipe.getMaxSaturationBonus());
        return ans;
    }
}

