/*
 * Decompiled with CFR 0.152.
 */
package com.serpenssolida.createtransmission;

import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class CTShapes {
    private static final VoxelShape SHAPE_CHAIN = CTShapes.box(new Vec3(5.0, 5.0, 0.0), new Vec3(11.0, 11.0, 2.0));
    private static final VoxelShape SHAPE_CHAIN_CONNECTED = CTShapes.box(new Vec3(5.0, 5.0, 0.0), new Vec3(16.0, 11.0, 2.0));
    private static final VoxelShape SHAPE_CHAIN_BELT = Shapes.m_83110_((VoxelShape)SHAPE_CHAIN_CONNECTED, (VoxelShape)CTShapes.rotated(SHAPE_CHAIN_CONNECTED, new Vec3(180.0, 90.0, 0.0)));
    public static final VoxelShaper CHAIN = new Builder(SHAPE_CHAIN).forDirectional();
    public static final VoxelShaper CHAIN_CONNECTED_RIGHT = new Builder(SHAPE_CHAIN_CONNECTED).forDirectional();
    public static final VoxelShaper CHAIN_CONNECTED_BOTTOM = new Builder(CTShapes.rotated(SHAPE_CHAIN_CONNECTED, new Vec3(0.0, 0.0, 270.0))).forDirectional();
    public static final VoxelShaper CHAIN_CONNECTED_LEFT = new Builder(CTShapes.rotated(SHAPE_CHAIN_CONNECTED, new Vec3(0.0, 0.0, 180.0))).forDirectional();
    public static final VoxelShaper CHAIN_CONNECTED_TOP = new Builder(CTShapes.rotated(SHAPE_CHAIN_CONNECTED, new Vec3(0.0, 0.0, 90.0))).forDirectional();
    public static final VoxelShaper CHAIN_BELT_RIGHT = new Builder(SHAPE_CHAIN_BELT).forDirectional();
    public static final VoxelShaper CHAIN_BELT_BOTTOM = new Builder(CTShapes.rotated(SHAPE_CHAIN_BELT, new Vec3(0.0, 0.0, 270.0))).forDirectional();
    public static final VoxelShaper CHAIN_BELT_LEFT = new Builder(CTShapes.rotated(SHAPE_CHAIN_BELT, new Vec3(0.0, 0.0, 180.0))).forDirectional();
    public static final VoxelShaper CHAIN_BELT_TOP = new Builder(CTShapes.rotated(SHAPE_CHAIN_BELT, new Vec3(0.0, 0.0, 90.0))).forDirectional();

    private CTShapes() {
    }

    protected static VoxelShape rotated(VoxelShape shape, Vec3 rotation) {
        if (rotation.equals((Object)Vec3.f_82478_)) {
            return shape;
        }
        MutableObject result = new MutableObject((Object)Shapes.m_83040_());
        Vec3 center = new Vec3(8.0, 8.0, 8.0);
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            Vec3 v1 = new Vec3(x1, y1, z1).m_82490_(16.0).m_82546_(center);
            Vec3 v2 = new Vec3(x2, y2, z2).m_82490_(16.0).m_82546_(center);
            v1 = VecHelper.rotate((Vec3)v1, (double)((float)rotation.f_82479_), (Direction.Axis)Direction.Axis.X);
            v1 = VecHelper.rotate((Vec3)v1, (double)((float)rotation.f_82480_), (Direction.Axis)Direction.Axis.Y);
            v1 = VecHelper.rotate((Vec3)v1, (double)((float)rotation.f_82481_), (Direction.Axis)Direction.Axis.Z).m_82549_(center);
            v2 = VecHelper.rotate((Vec3)v2, (double)((float)rotation.f_82479_), (Direction.Axis)Direction.Axis.X);
            v2 = VecHelper.rotate((Vec3)v2, (double)((float)rotation.f_82480_), (Direction.Axis)Direction.Axis.Y);
            v2 = VecHelper.rotate((Vec3)v2, (double)((float)rotation.f_82481_), (Direction.Axis)Direction.Axis.Z).m_82549_(center);
            VoxelShape rotated = CTShapes.box(v1, v2);
            result.setValue((Object)Shapes.m_83110_((VoxelShape)((VoxelShape)result.getValue()), (VoxelShape)rotated));
        });
        return (VoxelShape)result.getValue();
    }

    protected static VoxelShape box(Vec3 v1, Vec3 v2) {
        return Block.m_49796_((double)Math.min(v1.f_82479_, v2.f_82479_), (double)Math.min(v1.f_82480_, v2.f_82480_), (double)Math.min(v1.f_82481_, v2.f_82481_), (double)Math.max(v1.f_82479_, v2.f_82479_), (double)Math.max(v1.f_82480_, v2.f_82480_), (double)Math.max(v1.f_82481_, v2.f_82481_));
    }

    public static class Builder {
        private VoxelShape shape;

        public Builder(VoxelShape shape) {
            this.shape = shape;
        }

        public Builder add(VoxelShape shape) {
            this.shape = Shapes.m_83110_((VoxelShape)this.shape, (VoxelShape)shape);
            return this;
        }

        public VoxelShape build() {
            return this.shape;
        }

        public VoxelShaper forDirectional() {
            return new VoxelShaper().withShape(this.shape, Direction.NORTH).withShape(CTShapes.rotated(this.shape, new Vec3(0.0, 270.0, 0.0)), Direction.EAST).withShape(CTShapes.rotated(this.shape, new Vec3(0.0, 180.0, 0.0)), Direction.SOUTH).withShape(CTShapes.rotated(this.shape, new Vec3(0.0, 90.0, 0.0)), Direction.WEST).withShape(CTShapes.rotated(this.shape, new Vec3(90.0, 0.0, 0.0)), Direction.UP).withShape(CTShapes.rotated(this.shape, new Vec3(270.0, 0.0, 0.0)), Direction.DOWN);
        }
    }
}

