/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.biomespy.structure;

import com.moepus.biomespy.biome.BiomeEnvelopeSelector;
import com.moepus.biomespy.biome.LazyBiomeNoiseChecker;
import com.moepus.biomespy.compat.alexscaves.AlexBiome;
import com.moepus.biomespy.compat.alexscaves.AlexsCavesCompat;
import com.moepus.biomespy.mixin.StructureCheckAccessor;
import com.moepus.biomespy.mixin.StructureManagerAccessor;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public class StructureChecker {
    static TagKey<Structure> UNINITED_SAFE_STRUCTURES = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("biomespy", "uninit_safe"));

    private static boolean tryAddReference(StructureManager pStructureManager, StructureStart pStructureStart) {
        if (pStructureStart.m_73606_()) {
            pStructureManager.m_220484_(pStructureStart);
            return true;
        }
        return false;
    }

    private static StructureCheckResult checkStructureInfo(Object2IntMap<Structure> pStructureChunks, Structure pStructure, boolean pSkipKnownStructures) {
        int i = pStructureChunks.getOrDefault((Object)pStructure, -1);
        return i == -1 || pSkipKnownStructures && i != 0 ? StructureCheckResult.START_NOT_PRESENT : StructureCheckResult.START_PRESENT;
    }

    public static Pair<BlockPos, Holder<Structure>> getStructureGeneratingAt(Map<Holder<Structure>, BiomeEnvelopeSelector> pStructureHoldersSet, LevelReader pLevel, StructureManager pStructureManager, boolean pSkipKnownStructures, StructurePlacement pPlacement, ChunkPos pChunkPos, Climate.ParameterList<Holder<Biome>> parameters) {
        StructureCheckAccessor structureCheckAccessor = (StructureCheckAccessor)((StructureManagerAccessor)pStructureManager).getStructureCheck();
        Climate.Sampler sampler = structureCheckAccessor.getRandomState().m_224579_();
        Object2IntMap structureChunkMap = (Object2IntMap)structureCheckAccessor.getLoadedChunks().get(pChunkPos.m_45588_());
        int x = pChunkPos.m_45604_();
        int z = pChunkPos.m_45605_();
        for (Map.Entry<Holder<Structure>, BiomeEnvelopeSelector> entry : pStructureHoldersSet.entrySet()) {
            ChunkAccess chunkaccess;
            StructureStart structurestart;
            StructureCheckResult structurecheckresult;
            Holder<Structure> holder = entry.getKey();
            if (structureChunkMap != null) {
                structurecheckresult = StructureChecker.checkStructureInfo((Object2IntMap<Structure>)structureChunkMap, (Structure)holder.m_203334_(), pSkipKnownStructures);
            } else {
                LazyBiomeNoiseChecker biomeChecker;
                if ((!AlexsCavesCompat.ALEXS_CAVES_INSTALLED || !AlexBiome.isAlexsCavesChunk(entry.getValue(), x, z)) && !(biomeChecker = new LazyBiomeNoiseChecker(entry.getValue(), parameters, x, z)).matches(sampler)) continue;
                structurecheckresult = pStructureManager.m_220473_(pChunkPos, (Structure)holder.m_203334_(), pSkipKnownStructures);
            }
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!pSkipKnownStructures) {
                if (structurecheckresult == StructureCheckResult.START_PRESENT) {
                    return Pair.of((Object)pPlacement.m_227039_(pChunkPos), holder);
                }
                if (holder.m_203656_(UNINITED_SAFE_STRUCTURES)) {
                    return Pair.of((Object)pPlacement.m_227039_(pChunkPos), holder);
                }
            }
            if ((structurestart = pStructureManager.m_220512_(SectionPos.m_175562_((ChunkAccess)(chunkaccess = pLevel.m_46819_(pChunkPos.f_45578_, pChunkPos.f_45579_, ChunkStatus.f_62315_))), (Structure)holder.m_203334_(), (StructureAccess)chunkaccess)) == null || !structurestart.m_73603_() || pSkipKnownStructures && !StructureChecker.tryAddReference(pStructureManager, structurestart)) continue;
            return Pair.of((Object)pPlacement.m_227039_(structurestart.m_163625_()), holder);
        }
        return null;
    }
}

