/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.biomespy.mixin.compat.terrablender;

import com.moepus.biomespy.biome.BiomeEnvelope;
import com.moepus.biomespy.compat.terrablender.IParameterListExtendedInfo;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.worldgen.IExtendedParameterList;

@Mixin(value={Climate.ParameterList.class})
public abstract class ParameterListMixin<T>
implements IParameterListExtendedInfo,
IExtendedParameterList<T> {
    @Shadow
    @Final
    private List<Pair<Climate.ParameterPoint, T>> f_186846_;
    @Unique
    private boolean biomeSpy$initialized = false;
    @Unique
    private HashMap<T, BiomeEnvelope>[] biomeSpy$uniqueTrees;

    @Override
    public void biomeSpy$gatherExtendedInfo(RegistryAccess registryAccess, RegionType regionType, long seed) {
        if (this.biomeSpy$initialized) {
            return;
        }
        this.biomeSpy$initialized = true;
        this.biomeSpy$uniqueTrees = new HashMap[Regions.getCount((RegionType)regionType)];
        Registry biomeRegistry = registryAccess.m_175515_(Registries.f_256952_);
        for (Region region : Regions.get((RegionType)regionType)) {
            HashMap<Object, BiomeEnvelope> biomeEnvelopeHashMap;
            int regionIndex = Regions.getIndex((RegionType)regionType, (ResourceLocation)region.getName());
            if (regionIndex == 0) {
                biomeEnvelopeHashMap = new HashMap<Object, BiomeEnvelope>();
                for (Pair<Climate.ParameterPoint, T> p : this.f_186846_) {
                    Object biome = p.getSecond();
                    biomeEnvelopeHashMap.computeIfAbsent(biome, k -> new BiomeEnvelope()).add((Climate.ParameterPoint)p.getFirst());
                }
                this.biomeSpy$uniqueTrees[0] = biomeEnvelopeHashMap;
                continue;
            }
            biomeEnvelopeHashMap = new HashMap();
            region.addBiomes(biomeRegistry, pair -> {
                Optional biome = biomeRegistry.m_203636_((ResourceKey)pair.getSecond());
                if (biome.isPresent()) {
                    Holder biomeHolder = (Holder)biome.get();
                    biomeEnvelopeHashMap.computeIfAbsent(biomeHolder, k -> new BiomeEnvelope()).add((Climate.ParameterPoint)pair.getFirst());
                }
            });
            this.biomeSpy$uniqueTrees[regionIndex] = biomeEnvelopeHashMap;
        }
    }

    @Override
    public BiomeEnvelope biomeSpy$getEnvelopeForBiomes(List<Holder<Biome>> biomes, int regionIndex) {
        BiomeEnvelope combinedEnvelope = new BiomeEnvelope();
        combinedEnvelope.impossible = true;
        HashMap<T, BiomeEnvelope> biomeEnvelopeHashMap = this.biomeSpy$uniqueTrees[regionIndex];
        for (Holder<Biome> biome : biomes) {
            BiomeEnvelope envelope = biomeEnvelopeHashMap.get(biome);
            if (envelope == null) continue;
            combinedEnvelope.add(envelope);
            combinedEnvelope.impossible = false;
        }
        return combinedEnvelope;
    }

    @Override
    public void biomeSpy$visitAllEnvelopes(BiConsumer<Integer, HashMap<Holder<Biome>, BiomeEnvelope>> visitor) {
        for (int i = 0; i < this.biomeSpy$uniqueTrees.length; ++i) {
            visitor.accept(i, this.biomeSpy$uniqueTrees[i]);
        }
    }

    public Climate.ParameterList<T> clone() {
        try {
            return (Climate.ParameterList)super.clone();
        }
        catch (CloneNotSupportedException var2) {
            throw new AssertionError();
        }
    }
}

