/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.biomespy.compat.alexscaves;

import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationConfig;
import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationNoiseCondition;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRarity;
import com.github.alexmodguy.alexscaves.server.level.biome.BiomeSourceAccessor;
import com.github.alexmodguy.alexscaves.server.misc.VoronoiGenerator;
import com.moepus.biomespy.biome.BiomeEnvelope;
import com.moepus.biomespy.biome.BiomeEnvelopeSelector;
import com.moepus.biomespy.compat.alexscaves.AlexsCavesBiomeSourceExtendedInfo;
import com.moepus.biomespy.mixin.compat.alexscaves.BiomeGenerationNoiseConditionAccessor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.phys.Vec3;

public class AlexBiome {
    public static AlexsCavesBiomeSourceExtendedInfo getExtendedInfo(MultiNoiseBiomeSource biomeSource) {
        try {
            Field f = biomeSource.getClass().getDeclaredField("lastSampledWorldSeed");
            f.setAccessible(true);
            long seed = (Long)f.get(biomeSource);
            Field f2 = biomeSource.getClass().getDeclaredField("lastSampledDimension");
            f2.setAccessible(true);
            ResourceKey dimension = (ResourceKey)f2.get(biomeSource);
            return new AlexsCavesBiomeSourceExtendedInfo(seed, (ResourceKey<Level>)dimension);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void initAlexsCavesData(BiomeEnvelopeSelector envelopeMap, Collection<Holder<Biome>> biomes, Climate.ParameterList<Holder<Biome>> parameters, MultiNoiseBiomeSource biomeSource) {
        AlexsCavesBiomeSourceExtendedInfo extendedInfo = AlexBiome.getExtendedInfo(biomeSource);
        if (extendedInfo == null) {
            return;
        }
        ResourceKey<Level> dimension = extendedInfo.lastSampledDimension();
        HashMap<Integer, AlexBiomeInfo> alexsCavesEnvelopeMap = new HashMap<Integer, AlexBiomeInfo>();
        for (Map.Entry condition : BiomeGenerationConfig.BIOMES.entrySet()) {
            if (((BiomeGenerationNoiseCondition)condition.getValue()).isDisabledCompletely()) continue;
            Holder biomeHolder = (Holder)((BiomeSourceAccessor)biomeSource).getResourceKeyMap().get(condition.getKey());
            BiomeGenerationNoiseConditionAccessor conditionAccessor = (BiomeGenerationNoiseConditionAccessor)condition.getValue();
            if (dimension != null && !conditionAccessor.getDimensions().contains(dimension.m_135782_().toString())) continue;
            int rarityOffset = ((BiomeGenerationNoiseCondition)condition.getValue()).getRarityOffset();
            BiomeEnvelope envelope = new BiomeEnvelope();
            float[] continentalness = conditionAccessor.getContinentalness();
            float[] erosion = conditionAccessor.getErosion();
            float[] humidity = conditionAccessor.getHumidity();
            float[] temperature = conditionAccessor.getTemperature();
            float[] weirdness = conditionAccessor.getWeirdness();
            if (continentalness != null && continentalness.length >= 2) {
                envelope.cMin = Climate.m_186779_((float)continentalness[0]);
                envelope.cMax = Climate.m_186779_((float)continentalness[1]);
            }
            if (erosion != null && erosion.length >= 2) {
                envelope.eMin = Climate.m_186779_((float)erosion[0]);
                envelope.eMax = Climate.m_186779_((float)erosion[1]);
            }
            if (weirdness != null && weirdness.length >= 2) {
                envelope.wMin = Climate.m_186779_((float)weirdness[0]);
                envelope.wMax = Climate.m_186779_((float)weirdness[1]);
            }
            if (humidity != null && humidity.length >= 2) {
                envelope.hMin = Climate.m_186779_((float)humidity[0]);
                envelope.hMax = Climate.m_186779_((float)humidity[1]);
            }
            if (temperature != null && temperature.length >= 2) {
                envelope.tMin = Climate.m_186779_((float)temperature[0]);
                envelope.tMax = Climate.m_186779_((float)temperature[1]);
            }
            float[] depth = conditionAccessor.getDepth();
            long dMin = Long.MAX_VALUE;
            long dMax = Long.MIN_VALUE;
            if (depth != null && depth.length >= 2) {
                dMin = Climate.m_186779_((float)depth[0]);
                dMax = Climate.m_186779_((float)depth[1]);
            }
            AlexBiomeInfo verticalEnvelope = new AlexBiomeInfo((Holder<Biome>)biomeHolder, envelope, dMin, dMax, conditionAccessor.getDistanceFromSpawn());
            alexsCavesEnvelopeMap.put(rarityOffset, verticalEnvelope);
        }
        envelopeMap.setPlatformData(AlexsCavesData.class, new AlexsCavesData(extendedInfo, alexsCavesEnvelopeMap, new HashMap<Long, Optional<Holder<Biome>>>()));
    }

    private static boolean isFarEnoughFromSpawn(int x, int z, double dist) {
        return (double)(x * x + z * z) >= dist * dist;
    }

    public static boolean isAlexsCavesChunk(BiomeEnvelopeSelector envelopeSelector, int x, int z) {
        Object object = envelopeSelector.getPlatformData(AlexsCavesData.class);
        if (!(object instanceof AlexsCavesData)) {
            return false;
        }
        AlexsCavesData data = (AlexsCavesData)object;
        AlexsCavesBiomeSourceExtendedInfo extendedInfo = data.extendedInfo;
        VoronoiGenerator.VoronoiInfo voronoiInfo = ACBiomeRarity.getRareBiomeInfoForQuad((long)extendedInfo.lastSampledWorldSeed(), (int)QuartPos.m_175400_((int)x), (int)QuartPos.m_175400_((int)z));
        return voronoiInfo != null;
    }

    public static Holder<Biome> getAlexsCavesBiome(BiomeEnvelopeSelector envelopeSelector, Climate.Sampler sampler, int x, int y, int z) {
        Object object = envelopeSelector.getPlatformData(AlexsCavesData.class);
        if (!(object instanceof AlexsCavesData)) {
            return null;
        }
        AlexsCavesData data = (AlexsCavesData)object;
        Map<Integer, AlexBiomeInfo> envelopeMap = data.envelopeMap;
        AlexsCavesBiomeSourceExtendedInfo extendedInfo = data.extendedInfo;
        VoronoiGenerator.VoronoiInfo voronoiInfo = ACBiomeRarity.getRareBiomeInfoForQuad((long)extendedInfo.lastSampledWorldSeed(), (int)QuartPos.m_175400_((int)x), (int)QuartPos.m_175400_((int)z));
        if (voronoiInfo == null) {
            return null;
        }
        Vec3 rareBiomeCenter = ACBiomeRarity.getRareBiomeCenter((VoronoiGenerator.VoronoiInfo)voronoiInfo);
        if (rareBiomeCenter == null) {
            return null;
        }
        int foundRarityOffset = ACBiomeRarity.getRareBiomeOffsetId((VoronoiGenerator.VoronoiInfo)voronoiInfo);
        AlexBiomeInfo biomeInfo = envelopeMap.get(foundRarityOffset);
        if (biomeInfo == null) {
            return null;
        }
        if (!AlexBiome.isFarEnoughFromSpawn(x, z, biomeInfo.distanceFromSpawn)) {
            return null;
        }
        DensityFunction.SinglePointContext ctx = new DensityFunction.SinglePointContext(QuartPos.m_175402_((int)((int)Math.floor(rareBiomeCenter.f_82479_))), y, QuartPos.m_175402_((int)((int)Math.floor(rareBiomeCenter.f_82481_))));
        long depth = Climate.m_186779_((float)((float)sampler.f_207849_().m_207386_((DensityFunction.FunctionContext)ctx)));
        if (depth < biomeInfo.dMin || depth > biomeInfo.dMax) {
            return null;
        }
        long blockPos = (long)ctx.m_207115_() << 32 | (long)ctx.m_207113_() & 0xFFFFFFFFL;
        return data.cachedBiomes.computeIfAbsent(blockPos, pos -> biomeInfo.biomeEnvelope.matches(sampler, ctx) ? Optional.of(biomeInfo.biome) : Optional.empty()).orElse(null);
    }

    public record AlexBiomeInfo(Holder<Biome> biome, BiomeEnvelope biomeEnvelope, long dMin, long dMax, int distanceFromSpawn) {
    }

    public record AlexsCavesData(AlexsCavesBiomeSourceExtendedInfo extendedInfo, Map<Integer, AlexBiomeInfo> envelopeMap, Map<Long, Optional<Holder<Biome>>> cachedBiomes) {
    }
}

