/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.biomespy.biome;

import com.moepus.biomespy.biome.BiomeEnvelope;
import com.moepus.biomespy.biome.BiomeEnvelopeSelector;
import com.moepus.biomespy.biome.BiomeNoiseCheckState;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;

public final class LazyBiomeNoiseChecker {
    private final BiomeEnvelopeSelector envelopeSelector;
    private final DensityFunction.SinglePointContext ctx;
    private final Climate.ParameterList<Holder<Biome>> parameters;
    private Long temperature;
    private Long humidity;
    private Long continentalness;
    private Long erosion;
    private Long weirdness;

    public LazyBiomeNoiseChecker(BiomeEnvelopeSelector envelopeSelector, Climate.ParameterList<Holder<Biome>> parameters, int x, int z) {
        this.envelopeSelector = envelopeSelector;
        this.parameters = parameters;
        this.ctx = new DensityFunction.SinglePointContext(x, 0, z);
    }

    private long getTemperature(Climate.Sampler sampler) {
        if (this.temperature == null) {
            this.temperature = Climate.m_186779_((float)((float)sampler.f_207845_().m_207386_((DensityFunction.FunctionContext)this.ctx)));
        }
        return this.temperature;
    }

    private long getHumidity(Climate.Sampler sampler) {
        if (this.humidity == null) {
            this.humidity = Climate.m_186779_((float)((float)sampler.f_207846_().m_207386_((DensityFunction.FunctionContext)this.ctx)));
        }
        return this.humidity;
    }

    private long getContinentalness(Climate.Sampler sampler) {
        if (this.continentalness == null) {
            this.continentalness = Climate.m_186779_((float)((float)sampler.f_207847_().m_207386_((DensityFunction.FunctionContext)this.ctx)));
        }
        return this.continentalness;
    }

    private long getErosion(Climate.Sampler sampler) {
        if (this.erosion == null) {
            this.erosion = Climate.m_186779_((float)((float)sampler.f_207848_().m_207386_((DensityFunction.FunctionContext)this.ctx)));
        }
        return this.erosion;
    }

    private long getWeirdness(Climate.Sampler sampler) {
        if (this.weirdness == null) {
            this.weirdness = Climate.m_186779_((float)((float)sampler.f_207850_().m_207386_((DensityFunction.FunctionContext)this.ctx)));
        }
        return this.weirdness;
    }

    private long computeDepth(Climate.Sampler sampler, int y) {
        DensityFunction.SinglePointContext depthCtx = new DensityFunction.SinglePointContext(this.ctx.m_207115_(), y, this.ctx.m_207113_());
        return Climate.m_186779_((float)((float)sampler.f_207849_().m_207386_((DensityFunction.FunctionContext)depthCtx)));
    }

    public boolean matches(Climate.Sampler sampler) {
        BiomeEnvelope env = this.envelopeSelector.getEnvelope(this.parameters, QuartPos.m_175400_((int)this.ctx.m_207115_()), 0, QuartPos.m_175400_((int)this.ctx.m_207113_()));
        if (env.impossible) {
            return false;
        }
        for (BiomeNoiseCheckState.NoiseType type : BiomeNoiseCheckState.NoiseType.values()) {
            if (this.checkSingleNoise(sampler, env, type)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Climate.Sampler sampler, BiomeNoiseCheckState state, int y) {
        BiomeEnvelope env = this.envelopeSelector.getEnvelope(this.parameters, QuartPos.m_175400_((int)this.ctx.m_207115_()), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)this.ctx.m_207113_()));
        if (env.impossible) {
            return false;
        }
        BiomeNoiseCheckState.NoiseType priority = state.getLastFilteredNoise();
        if (priority != BiomeNoiseCheckState.NoiseType.NONE && !this.checkSingleNoise(sampler, env, priority)) {
            state.setLastFilteredNoise(priority);
            return false;
        }
        for (BiomeNoiseCheckState.NoiseType type : BiomeNoiseCheckState.NoiseType.values()) {
            if (type == priority || this.checkSingleNoise(sampler, env, type)) continue;
            state.setLastFilteredNoise(type);
            return false;
        }
        return true;
    }

    private boolean checkSingleNoise(Climate.Sampler sampler, BiomeEnvelope env, BiomeNoiseCheckState.NoiseType type) {
        switch (type) {
            case TEMPERATURE: {
                long v;
                if (env.tMin > env.tMax || env.tMin + 20000L <= env.tMax || (v = this.getTemperature(sampler)) >= env.tMin && v <= env.tMax) break;
                return false;
            }
            case HUMIDITY: {
                long v;
                if (env.hMin > env.hMax || env.hMin + 20000L <= env.hMax || (v = this.getHumidity(sampler)) >= env.hMin && v <= env.hMax) break;
                return false;
            }
            case CONTINENTALNESS: {
                long v;
                if (env.cMin > env.cMax || env.cMin + 20000L <= env.cMax || (v = this.getContinentalness(sampler)) >= env.cMin && v <= env.cMax) break;
                return false;
            }
            case EROSION: {
                long v;
                if (env.eMin > env.eMax || env.eMin + 20000L <= env.eMax || (v = this.getErosion(sampler)) >= env.eMin && v <= env.eMax) break;
                return false;
            }
            case WEIRDNESS: {
                long v;
                if (env.wMin > env.wMax || env.wMin + 20000L <= env.wMax || (v = this.getWeirdness(sampler)) >= env.wMin && v <= env.wMax) break;
                return false;
            }
        }
        return true;
    }

    public Climate.TargetPoint toTargetPoint(Climate.Sampler sampler, int y) {
        return new Climate.TargetPoint(this.getTemperature(sampler), this.getHumidity(sampler), this.getContinentalness(sampler), this.getErosion(sampler), this.computeDepth(sampler, y), this.getWeirdness(sampler));
    }
}

