/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.mixin.pathfinding;

import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.mixinhelper.INodeBreakable;
import io.github.flemmli97.improvedmobs.utils.PathFindingUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WalkNodeEvaluator.class})
public abstract class GroundNodeMixin
extends NodeEvaluator {
    @Unique
    private final Object2BooleanMap<AABB> collisionBreakableCache = new Object2BooleanOpenHashMap();
    @Unique
    private final Object2BooleanMap<Long> breakableMap = new Object2BooleanOpenHashMap();
    @Shadow
    private Object2BooleanMap<AABB> f_77546_;

    @ModifyVariable(method={"getNeighbors"}, at=@At(value="RETURN"), ordinal=0)
    private int addAdditionalPoints(int nodeCounts, Node[] points, Node origin) {
        if (((INodeBreakable)((Object)this)).canClimbLadder()) {
            return PathFindingUtils.createLadderNodeFor(nodeCounts, points, origin, p -> this.m_77349_((BlockPos)p), (BlockGetter)this.f_77312_, this.f_77313_);
        }
        return nodeCounts;
    }

    @Inject(method={"done"}, at={@At(value="RETURN")})
    private void clearStuff(CallbackInfo info) {
        this.collisionBreakableCache.clear();
        this.breakableMap.clear();
    }

    @Inject(method={"findAcceptedNode"}, at={@At(value="HEAD")}, cancellable=true)
    private void breakableNodes(int x, int y, int z, int steps, double groundY, Direction direction, BlockPathTypes blockPathTypes, CallbackInfoReturnable<Node> info) {
        if (!((INodeBreakable)((Object)this)).canBreakBlocks()) {
            return;
        }
        Node node = PathFindingUtils.notFloatingNodeModifier(this.f_77313_, (BlockGetter)this.f_77312_, x, y, z, steps, direction, blockPathTypes, pos -> this.m_77567_(this.f_77313_, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), aabb -> this.collisionBreakableCache.computeIfAbsent(aabb, object -> !PathFindingUtils.noCollision(this.f_77312_, (Entity)this.f_77313_, aabb)), aabb -> this.f_77546_.computeIfAbsent(aabb, object -> !this.f_77312_.m_45756_((Entity)this.f_77313_, aabb)), p -> this.m_77349_((BlockPos)p), this.breakableMap);
        if (node != null) {
            info.setReturnValue((Object)node);
            info.cancel();
        }
    }

    @Redirect(method={"getBlockPathTypes"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/pathfinder/WalkNodeEvaluator;getBlockPathType(Lnet/minecraft/world/level/BlockGetter;III)Lnet/minecraft/world/level/pathfinder/BlockPathTypes;"))
    private BlockPathTypes breakable(WalkNodeEvaluator nodeEvaluator, BlockGetter getter, int x, int y, int z) {
        if (!((INodeBreakable)((Object)this)).canBreakBlocks()) {
            return nodeEvaluator.m_8086_(getter, x, y, z);
        }
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = getter.m_8055_(pos);
        if (this.breakableMap.computeIfAbsent((Object)BlockPos.m_121882_((int)x, (int)y, (int)z), l -> Config.CommonConfig.breakableBlocks.canBreak(state, pos, getter, (Entity)this.f_77313_, this.f_77313_ == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)this.f_77313_)))) {
            return BlockPathTypes.WALKABLE;
        }
        return nodeEvaluator.m_8086_(getter, x, y, z);
    }

    @Inject(method={"hasCollisions"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasNoBreakableCollisions(AABB aabb, CallbackInfoReturnable<Boolean> info) {
        if (((INodeBreakable)((Object)this)).canBreakBlocks()) {
            info.setReturnValue((Object)this.collisionBreakableCache.computeIfAbsent((Object)aabb, object -> !PathFindingUtils.noCollision(this.f_77312_, (Entity)this.f_77313_, aabb)));
            info.cancel();
        }
    }

    @Shadow
    protected abstract BlockPathTypes m_77567_(Mob var1, int var2, int var3, int var4);
}

