/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.tenshilib.api.config.IConfigListValue;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

public class MobClassMapConfig
implements IConfigListValue<MobClassMapConfig> {
    private final Map<ResourceLocation, List<EntityType<?>>> map = Maps.newLinkedHashMap();
    public Map<ResourceLocation, Predicate<Class<? extends Mob>>> preds = new HashMap<ResourceLocation, Predicate<Class<? extends Mob>>>();

    @Nullable
    public List<EntityType<?>> get(ResourceLocation res) {
        return this.map.get(res);
    }

    public MobClassMapConfig readFromString(List<String> ss) {
        this.map.clear();
        for (String s : ss) {
            String[] sub = s.replace(" ", "").split("-");
            if (sub.length < 2) continue;
            EntityType type = (EntityType)PlatformUtils.INSTANCE.entities().getFromId(new ResourceLocation(sub[1]));
            if (type == null) {
                ImprovedMobs.logger.error("Entity {} does not exist/is not registered", (Object)sub[1]);
                continue;
            }
            this.map.merge(new ResourceLocation(sub[0]), Lists.newArrayList((Object[])new EntityType[]{type}), (old, oth) -> {
                old.add(type);
                return old;
            });
        }
        return this;
    }

    public List<String> writeToString() {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<ResourceLocation, List<EntityType<?>>> ent : this.map.entrySet()) {
            for (EntityType<?> type : ent.getValue()) {
                l.add(ent.getKey().toString() + "-" + String.valueOf(PlatformUtils.INSTANCE.entities().getIDFrom(type)));
            }
        }
        return l;
    }

    public static String use() {
        return "[mob id]-[mob id] where second value is the target.\n e.g. minecraft:zombie-minecraft:skeleton makes all zombies target skeletons";
    }
}

