/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai.util;

import io.github.flemmli97.improvedmobs.ai.util.ItemAI;
import io.github.flemmli97.improvedmobs.ai.util.ItemAIs;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ItemAITasks {
    private static final Map<Item, ItemAI> itemMap = new HashMap<Item, ItemAI>();

    public static void initAI() {
        ItemAITasks.initVanilla();
    }

    public static void registerAI(Item item, ItemAI ai) {
        itemMap.put(item, ai);
    }

    @Nullable
    public static ItemAI getAI(Item item) {
        return itemMap.get(item);
    }

    @Nullable
    public static Pair<ItemAI, InteractionHand> getAI(Mob entity) {
        ItemStack heldMain = entity.m_21205_();
        ItemStack heldOff = entity.m_21206_();
        if (heldMain.m_41720_() instanceof ArrowItem && heldOff.m_41720_() instanceof BowItem) {
            entity.m_8061_(EquipmentSlot.MAINHAND, heldOff.m_41777_());
            entity.m_8061_(EquipmentSlot.OFFHAND, heldMain.m_41777_());
            heldMain = entity.m_21205_();
            heldOff = entity.m_21206_();
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemAI ai = itemMap.get(heldMain.m_41720_());
        if ((ai == null || ai.prefHand() == ItemAI.UsableHand.OFF || ItemAITasks.blockedAI(entity, heldMain.m_41720_()) || !ai.applies(heldMain)) && (ai = itemMap.get(heldOff.m_41720_())) != null) {
            if (ai.prefHand() == ItemAI.UsableHand.MAIN || ai.isIncompatibleWith((LivingEntity)entity, heldMain) || ItemAITasks.blockedAI(entity, heldOff.m_41720_()) || !ai.applies(heldOff)) {
                ai = null;
            } else {
                hand = InteractionHand.OFF_HAND;
            }
        }
        return Pair.of((Object)ai, (Object)hand);
    }

    private static boolean blockedAI(Mob entity, Item item) {
        return Config.CommonConfig.itemuseWhitelist && !Config.CommonConfig.itemuseBlacklist.contains(PlatformUtils.INSTANCE.items().getIDFrom((Object)item).toString()) || Config.CommonConfig.itemuseBlacklist.contains(PlatformUtils.INSTANCE.items().getIDFrom((Object)item).toString()) || Config.CommonConfig.entityItemConfig.preventUse((Entity)entity, item);
    }

    private static void initVanilla() {
        for (Item item : PlatformUtils.INSTANCE.items().getIterator()) {
            if (item instanceof SplashPotionItem) {
                ItemAITasks.registerAI(item, ItemAIs.SPLASH);
            }
            if (item instanceof LingeringPotionItem) {
                ItemAITasks.registerAI(item, ItemAIs.LINGERINGPOTIONS);
            }
            if (item instanceof CrossbowItem) {
                ItemAITasks.registerAI(item, ItemAIs.CROSSBOWS);
            }
            if (item instanceof BowItem) {
                ItemAITasks.registerAI(item, ItemAIs.BOWS);
            }
            if (!(item instanceof ShieldItem)) continue;
            ItemAITasks.registerAI(item, ItemAIs.SHIELDS);
        }
        ItemAITasks.registerAI(Items.f_42452_, ItemAIs.SNOWBALL);
        ItemAITasks.registerAI(Items.f_42584_, ItemAIs.ENDER_PEARL);
        ItemAITasks.registerAI(Items.f_42448_, ItemAIs.LAVABUCKET);
        ItemAITasks.registerAI(Items.f_42409_, ItemAIs.FLINT_N_STEEL);
        ItemAITasks.registerAI(Blocks.f_50077_.m_5456_(), ItemAIs.TNT);
        ItemAITasks.registerAI(Items.f_42713_, ItemAIs.TRIDENT);
        ItemAITasks.registerAI(Items.f_42690_, ItemAIs.ENCHANTEDBOOK);
    }
}

