/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.event;

import com.mafuyu404.oelib.forge.data.DataManager;
import com.mafuyu404.oelib.forge.event.DataReloadEvent;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.event.base.AbstractReplacementEventHandler;
import com.mafuyu404.oneenoughitem.init.ItemReplacementCache;
import com.mafuyu404.oneenoughitem.init.config.DomainConfig;
import com.mafuyu404.oneenoughitem.init.config.OEIConfig;
import com.mafuyu404.oneenoughitem.util.Utils;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="oneenoughitem")
public class ServerEventHandler {
    private static final Handler HANDLER = new Handler();

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        HANDLER.rebuildReplacementCache("oei-server-start", (DataManager<Replacements>)DataManager.get(Replacements.class));
    }

    @SubscribeEvent
    public static void onDataReload(DataReloadEvent event) {
        if (event.isDataType(Replacements.class)) {
            HANDLER.rebuildReplacementCache("server-data-reload", (DataManager<Replacements>)DataManager.get(Replacements.class));
            Oneenoughitem.LOGGER.info("Server replacement cache rebuilt due to data reload: {} entries loaded, {} invalid", (Object)event.getLoadedCount(), (Object)event.getInvalidCount());
            ItemReplacementCache.endReloadOverride();
        }
    }

    private static class Handler
    extends AbstractReplacementEventHandler {
        private Handler() {
        }

        @Override
        protected void clearModuleCache() {
            ItemReplacementCache.clearCache();
        }

        @Override
        protected void putToModuleCache(Replacements r) {
            ItemReplacementCache.putReplacement(this.buildReplacements(r));
        }

        @Override
        protected boolean tryResolveData(String id) {
            return Utils.getItemById(id) != null;
        }

        @Override
        protected boolean tryResolveTag(String tagId) {
            return Utils.isTagExists(new ResourceLocation(tagId));
        }

        @Override
        protected boolean acceptLocation(ResourceLocation location) {
            return "oei".equals(location.m_135827_());
        }

        @Override
        protected Replacements buildReplacements(Replacements r) {
            DomainConfig.DefaultRules dr = OEIConfig.getDefaultRules("oei");
            if (r.rules().isEmpty() && dr != null) {
                return new Replacements(r.match(), r.result(), Optional.of(dr.toRules()));
            }
            return r;
        }
    }
}

