/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.event;

import com.mafuyu404.oelib.forge.data.DataManager;
import com.mafuyu404.oelib.forge.event.DataReloadEvent;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.ModKeyMappings;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.cache.ItemGlobalReplacementCache;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.event.base.AbstractReplacementEventHandler;
import com.mafuyu404.oneenoughitem.init.ItemReplacementCache;
import com.mafuyu404.oneenoughitem.init.access.CreativeModeTabIconRefresher;
import com.mafuyu404.oneenoughitem.init.config.DomainConfig;
import com.mafuyu404.oneenoughitem.init.config.OEIConfig;
import com.mafuyu404.oneenoughitem.util.Utils;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(modid="oneenoughitem", value={Dist.CLIENT})
public class ClientEventHandler {
    private static final Handler HANDLER = new Handler();

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ModKeyMappings.OPEN_EDITOR);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            if (ModKeyMappings.OPEN_EDITOR.m_90859_() && mc.f_91080_ == null && ClientEventHandler.hasCtrlDown()) {
                mc.m_91152_((Screen)new ReplacementEditorScreen());
            }
        }
    }

    @SubscribeEvent
    public static void onDataReload(DataReloadEvent event) {
        if (event.isDataType(Replacements.class)) {
            Minecraft.m_91087_().execute(() -> {
                HANDLER.rebuildReplacementCache("client-data-reload", (DataManager<Replacements>)DataManager.get(Replacements.class));
                ItemGlobalReplacementCache.get().rebuild();
                ClientEventHandler.refreshAllCreativeModeTabIcons();
                Oneenoughitem.LOGGER.info("Replacement cache rebuilt due to data reload: {} entries loaded, {} invalid", (Object)event.getLoadedCount(), (Object)event.getInvalidCount());
                ItemReplacementCache.endReloadOverride();
            });
        }
    }

    private static void refreshAllCreativeModeTabIcons() {
        try {
            for (CreativeModeTab tab : CreativeModeTabs.m_257388_()) {
                if (!(tab instanceof CreativeModeTabIconRefresher)) continue;
                CreativeModeTabIconRefresher refresher = (CreativeModeTabIconRefresher)tab;
                refresher.oei$refreshIconCache();
            }
            Oneenoughitem.LOGGER.info("Refreshed creative mode tab icons after replacement reload");
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("Failed to refresh creative mode tab icons", (Throwable)e);
        }
    }

    private static boolean hasCtrlDown() {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        return GLFW.glfwGetKey((long)window, (int)341) == 1 || GLFW.glfwGetKey((long)window, (int)345) == 1;
    }

    private static class Handler
    extends AbstractReplacementEventHandler {
        private Handler() {
        }

        @Override
        protected void clearModuleCache() {
            ItemReplacementCache.clearCache();
        }

        @Override
        protected void putToModuleCache(Replacements r) {
            ItemReplacementCache.putReplacement(this.buildReplacements(r));
        }

        @Override
        protected boolean tryResolveData(String id) {
            return Utils.getItemById(id) != null;
        }

        @Override
        protected boolean tryResolveTag(String tagId) {
            return Utils.isTagExists(new ResourceLocation(tagId));
        }

        @Override
        protected Replacements buildReplacements(Replacements r) {
            DomainConfig.DefaultRules dr = OEIConfig.getDefaultRules("oei");
            if (r.rules().isEmpty() && dr != null) {
                return new Replacements(r.match(), r.result(), Optional.of(dr.toRules()));
            }
            return r;
        }

        @Override
        protected boolean acceptLocation(ResourceLocation location) {
            return "oei".equals(location.m_135827_());
        }
    }
}

