/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFW;

public class GuiUtils {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("oneenoughitem", "textures/gui/background.png");
    private static final ResourceLocation BUTTON_NORMAL_TEXTURE = new ResourceLocation("oneenoughitem", "textures/gui/button_0.png");
    private static final ResourceLocation BUTTON_PRESSED_TEXTURE = new ResourceLocation("oneenoughitem", "textures/gui/button_1.png");
    private static final ResourceLocation EDITOR_TEXTURE = new ResourceLocation("oneenoughitem", "textures/gui/editor.png");
    private static final ResourceLocation ITEM_BOX_TEXTURE = new ResourceLocation("oneenoughitem", "textures/gui/item_box.png");

    public static void drawTiledBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        int textureSize = 16;
        for (int tileX = 0; tileX < width; tileX += textureSize) {
            for (int tileY = 0; tileY < height; tileY += textureSize) {
                int tileWidth = Math.min(textureSize, width - tileX);
                int tileHeight = Math.min(textureSize, height - tileY);
                graphics.m_280163_(BACKGROUND_TEXTURE, x + tileX, y + tileY, 0.0f, 0.0f, tileWidth, tileHeight, textureSize, textureSize);
            }
        }
    }

    public static void drawItemBox(GuiGraphics graphics, int x, int y, int width, int height) {
        int textureSize = 18;
        int border = 6;
        GuiUtils.drawNinePatch(graphics, ITEM_BOX_TEXTURE, x, y, width, height, textureSize, border);
    }

    public static void drawStretchableButton(GuiGraphics graphics, int x, int y, int width, int height, boolean pressed) {
        ResourceLocation texture = pressed ? BUTTON_PRESSED_TEXTURE : BUTTON_NORMAL_TEXTURE;
        int textureSize = 18;
        int border = 6;
        GuiUtils.drawNinePatch(graphics, texture, x, y, width, height, textureSize, border);
    }

    private static void drawNinePatch(GuiGraphics graphics, ResourceLocation texture, int x, int y, int width, int height, int textureSize, int border) {
        graphics.m_280163_(texture, x, y, 0.0f, 0.0f, border, border, textureSize, textureSize);
        graphics.m_280163_(texture, x + width - border, y, (float)(textureSize - border), 0.0f, border, border, textureSize, textureSize);
        graphics.m_280163_(texture, x, y + height - border, 0.0f, (float)(textureSize - border), border, border, textureSize, textureSize);
        graphics.m_280163_(texture, x + width - border, y + height - border, (float)(textureSize - border), (float)(textureSize - border), border, border, textureSize, textureSize);
        if (width > border * 2) {
            graphics.m_280411_(texture, x + border, y, width - border * 2, border, (float)border, 0.0f, textureSize - border * 2, border, textureSize, textureSize);
        }
        if (width > border * 2) {
            graphics.m_280411_(texture, x + border, y + height - border, width - border * 2, border, (float)border, (float)(textureSize - border), textureSize - border * 2, border, textureSize, textureSize);
        }
        if (height > border * 2) {
            graphics.m_280411_(texture, x, y + border, border, height - border * 2, 0.0f, (float)border, border, textureSize - border * 2, textureSize, textureSize);
        }
        if (height > border * 2) {
            graphics.m_280411_(texture, x + width - border, y + border, border, height - border * 2, (float)(textureSize - border), (float)border, border, textureSize - border * 2, textureSize, textureSize);
        }
        if (width > border * 2 && height > border * 2) {
            graphics.m_280411_(texture, x + border, y + border, width - border * 2, height - border * 2, (float)border, (float)border, textureSize - border * 2, textureSize - border * 2, textureSize, textureSize);
        }
    }

    public static void drawPanelBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        GuiUtils.drawTiledBackground(graphics, x, y, width, height);
    }

    public static void drawListBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        GuiUtils.drawTiledBackground(graphics, x, y, width, height);
    }

    public static void drawFileEntryBackground(GuiGraphics graphics, int x, int y, int width, int height, boolean isHovered, boolean isSelected) {
        if (isSelected) {
            graphics.m_280509_(x, y, x + width, y + height, -2143272896);
        } else if (isHovered) {
            graphics.m_280509_(x, y, x + width, y + height, 0x40FFFFFF);
        }
    }

    public static void drawFileIcon(GuiGraphics graphics, int x, int y, String fileType) {
        graphics.m_280509_(x, y, x + 12, y + 12, -11751600);
        GuiUtils.drawBorder(graphics, x, y, 12, 12, -13730510);
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, fileType, x + 3, y + 2, 0xFFFFFF);
    }

    public static void drawObjectDropdownBackground(GuiGraphics graphics, int x, int y, int width, int height) {
        GuiUtils.drawTiledBackground(graphics, x, y, width, height);
    }

    public static Button createButton(Component text, Button.OnPress onPress, int x, int y, int width, int height) {
        return GuiUtils.createCustomButton(text, onPress, x, y, width, height);
    }

    public static Button createObjectDropdownButton(Component text, Button.OnPress onPress, int x, int y, int width, int height) {
        return GuiUtils.createCustomButton(text, onPress, x, y, width, height);
    }

    private static Button createCustomButton(Component text, Button.OnPress onPress, int x, int y, int width, int height) {
        return new Button(x, y, width, height, text, onPress, Button.f_252438_){

            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
                GuiUtils.renderCustomButton(graphics, this, mouseX, mouseY, partialTick);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.f_93623_ && this.f_93624_ && this.m_93680_(mouseX, mouseY)) {
                    return super.m_6375_(mouseX, mouseY, button);
                }
                return false;
            }

            public boolean m_6348_(double mouseX, double mouseY, int button) {
                return super.m_6348_(mouseX, mouseY, button);
            }
        };
    }

    private static void renderCustomButton(GuiGraphics graphics, Button button, int mouseX, int mouseY, float partialTick) {
        boolean hovered = button.m_274382_();
        boolean mouseDown = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) == 1;
        boolean pressed = hovered && mouseDown;
        GuiUtils.drawStretchableButton(graphics, button.m_252754_(), button.m_252907_(), button.m_5711_(), button.m_93694_(), pressed);
        int textColor = button.f_93623_ ? (hovered ? 0xFFFFA0 : 0xFFFFFF) : 0x808080;
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, button.m_6035_(), button.m_252754_() + button.m_5711_() / 2, button.m_252907_() + (button.m_93694_() - 8) / 2, textColor);
    }

    private static void drawBorder(GuiGraphics graphics, int x, int y, int width, int height, int borderColor) {
        graphics.m_280509_(x - 1, y - 1, x + width + 1, y, borderColor);
        graphics.m_280509_(x - 1, y + height, x + width + 1, y + height + 1, borderColor);
        graphics.m_280509_(x - 1, y, x, y + height, borderColor);
        graphics.m_280509_(x + width, y, x + width + 1, y + height, borderColor);
    }

    private static void drawHighlightBorder(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280509_(x, y, x + width, y + 1, -2130706433);
        graphics.m_280509_(x, y + height - 1, x + width, y + height, 0x40FFFFFF);
    }

    public static void drawEditorPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        int textureSize = 256;
        int border = 20;
        GuiUtils.drawNinePatch(graphics, EDITOR_TEXTURE, x, y, width, height, textureSize, border);
    }
}

