/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.editor;

import com.mafuyu404.oneenoughitem.client.gui.components.ScrollablePanel;
import com.mafuyu404.oneenoughitem.client.gui.manager.ReplacementEditorManager;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public final class ObjectDropdownController {
    private ObjectDropdownController() {
    }

    public static ScrollablePanel rebuildDropdownPanel(Button anchorButton, boolean show, ReplacementEditorManager manager, List<Button> objectIndexButtons, IntConsumer onSelectIndex, Runnable onDeleteCurrent) {
        if (!show || manager.getObjectSize() <= 0 || anchorButton == null) {
            return null;
        }
        int startX = anchorButton.m_252754_();
        int startY = anchorButton.m_252907_() + anchorButton.m_93694_() + 2;
        int rowHeight = 22;
        int visibleRows = Math.min(8, Math.max(1, manager.getObjectSize()));
        int dropdownWidth = 95;
        int dropdownHeight = visibleRows * rowHeight;
        ScrollablePanel panel = new ScrollablePanel(startX, startY, dropdownWidth, dropdownHeight);
        objectIndexButtons.clear();
        for (int i = 0; i < manager.getObjectSize(); ++i) {
            int index = i;
            Object btnText = String.valueOf(i + 1);
            if (manager.getCurrentObjectIndex() == i) {
                btnText = (String)btnText + " \u2713";
            }
            Button indexButton = GuiUtils.createObjectDropdownButton((Component)Component.m_237113_((String)btnText), btn -> onSelectIndex.accept(index), startX, startY + i * rowHeight, 40, 20);
            indexButton.m_252865_(panel.m_252754_());
            indexButton.m_253211_(panel.m_252907_() + i * rowHeight);
            objectIndexButtons.add(indexButton);
            panel.addWidget((AbstractWidget)indexButton);
        }
        if (manager.getCurrentObjectIndex() >= 0) {
            int idx = manager.getCurrentObjectIndex();
            Button deleteButton = GuiUtils.createObjectDropdownButton((Component)Component.m_237115_((String)"gui.oneenoughitem.object.delete"), btn -> onDeleteCurrent.run(), startX + 45, startY + idx * rowHeight, 50, 20);
            deleteButton.m_252865_(panel.m_252754_() + 45);
            deleteButton.m_253211_(panel.m_252907_() + idx * rowHeight);
            objectIndexButtons.add(deleteButton);
            panel.addWidget((AbstractWidget)deleteButton);
        }
        return panel;
    }

    public static Component buildDropdownButtonText(boolean show, ReplacementEditorManager manager) {
        Object base;
        Object object = base = show ? Component.m_237115_((String)"gui.oneenoughitem.object.element_up").getString() : Component.m_237115_((String)"gui.oneenoughitem.object.element_down").getString();
        if (manager.getCurrentObjectIndex() >= 0) {
            base = (String)base + " (" + (manager.getCurrentObjectIndex() + 1) + "/" + manager.getObjectSize() + ")";
        }
        return Component.m_237113_((String)base);
    }
}

