/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.components;

import com.mafuyu404.oneenoughitem.api.DomainRegistry;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.util.ReplacementControl;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public class DataDisplayWidget
extends AbstractWidget {
    private final String dataId;
    private final Button.OnPress removeAction;
    private final boolean skipReplacement;
    private static final ResourceLocation CROSS_TEX = new ResourceLocation("oneenoughitem", "textures/gui/cross.png");

    public DataDisplayWidget(int x, int y, String dataId, Button.OnPress removeAction, boolean skipReplacement) {
        super(x, y, 18, 18, (Component)Component.m_237119_());
        this.dataId = dataId;
        this.removeAction = removeAction;
        this.skipReplacement = skipReplacement;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        GuiUtils.drawItemBox(graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        if (this.dataId != null && !this.dataId.isEmpty()) {
            if (this.skipReplacement) {
                ReplacementControl.withSkipReplacement(() -> DomainRegistry.current().renderDataId(graphics, this.dataId, this.m_252754_(), this.m_252907_()));
            } else {
                DomainRegistry.current().renderDataId(graphics, this.dataId, this.m_252754_(), this.m_252907_());
            }
        }
        if (this.m_274382_() && this.removeAction != null) {
            int crossX = this.m_252754_() + this.f_93618_ - 9;
            int crossY = this.m_252907_() + 1;
            graphics.m_280163_(CROSS_TEX, crossX, crossY, 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.m_274382_() && !this.dataId.isEmpty()) {
            this.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.m_274382_() || this.dataId.isEmpty()) {
            return;
        }
        this.renderToolTip(graphics, mouseX, mouseY);
    }

    public void renderToolTip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.m_274382_() || this.dataId.isEmpty()) {
            return;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        Component name = this.skipReplacement ? ReplacementControl.withSkipReplacement(() -> DomainRegistry.current().displayName(this.dataId)) : DomainRegistry.current().displayName(this.dataId);
        if (name == null || name.getString().isBlank()) {
            name = Component.m_237113_((String)this.dataId);
        }
        lines.add(name);
        ResourceLocation rl = ResourceLocation.m_135820_((String)this.dataId);
        if (rl != null) {
            String modId = rl.m_135827_();
            String modName = ModList.get().getModContainerById(modId).map(c -> c.getModInfo().getDisplayName()).orElse(modId);
            lines.add(Component.m_237113_((String)modName).m_130940_(ChatFormatting.BLUE));
        }
        graphics.m_280666_(Minecraft.m_91087_().f_91062_, lines, mouseX, mouseY);
    }

    public String getDataId() {
        return this.dataId;
    }

    public void m_264152_(int x, int y) {
        this.m_252865_(x);
        this.m_253211_(y);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, DomainRegistry.current().displayName(this.dataId));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.m_274382_() && this.removeAction != null) {
            int crossX = this.m_252754_() + this.f_93618_ - 9;
            int crossY = this.m_252907_() + 1;
            if (mouseX >= (double)crossX && mouseX < (double)(crossX + 8) && mouseY >= (double)crossY && mouseY < (double)(crossY + 8)) {
                this.removeAction.m_93750_(null);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

