/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui;

import com.mafuyu404.oneenoughitem.api.DomainAdapter;
import com.mafuyu404.oneenoughitem.api.DomainRegistry;
import com.mafuyu404.oneenoughitem.client.gui.cache.EditorCache;
import com.mafuyu404.oneenoughitem.client.gui.components.DataDisplayWidget;
import com.mafuyu404.oneenoughitem.client.gui.components.ScrollablePanel;
import com.mafuyu404.oneenoughitem.client.gui.components.TagDisplayWidget;
import com.mafuyu404.oneenoughitem.client.gui.editor.DataController;
import com.mafuyu404.oneenoughitem.client.gui.editor.FileActions;
import com.mafuyu404.oneenoughitem.client.gui.editor.ObjectDropdownController;
import com.mafuyu404.oneenoughitem.client.gui.editor.PanelsLayoutHelper;
import com.mafuyu404.oneenoughitem.client.gui.manager.ReplacementEditorManager;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.client.gui.util.ModUtils;
import com.mafuyu404.oneenoughitem.web.WebEditorServer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ReplacementEditorScreen
extends Screen {
    private static final int PANEL_WIDTH = 220;
    private static final int PANEL_HEIGHT = 140;
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 18;
    private static final int MARGIN = 8;
    private static final float EDITOR_SCALE_X = 1.24f;
    private static final float EDITOR_SCALE_Y = 2.255f;
    private static final int EDITOR_SHIFT_X = 5;
    private static final int EDITOR_SHIFT_Y = 0;
    private static final int EDITOR_INNER_MARGIN_X = 13;
    private static final int EDITOR_HEADER_GAP = 13;
    private static final int EDITOR_BOTTOM_MARGIN = 14;
    private final ReplacementEditorManager manager;
    private EditBox datapackNameBox;
    private EditBox fileNameBox;
    private Button createFileButton;
    private Button selectFileButton;
    private Button reloadButton;
    private Button clearAllButton;
    private Button saveToJSONButton;
    private Button openWebEditorButton;
    private Button objectDropdownButton;
    private boolean showObjectDropdown = false;
    private final List<Button> objectIndexButtons = new ArrayList<Button>();
    private ScrollablePanel objectDropdownPanel;
    private Button domainDropdownButton;
    private boolean showDomainDropdown = false;
    private final List<Button> domainButtons = new ArrayList<Button>();
    private ScrollablePanel domainDropdownPanel;
    private Button addMatchItemButton;
    private Button addMatchTagButton;
    private Button clearMatchButton;
    private ScrollablePanel matchPanel;
    private final List<TagDisplayWidget> matchTagWidgets;
    private final List<DataDisplayWidget> matchDataWidgets;
    private DataDisplayWidget resultDataWidget;
    private Button selectResultItemButton;
    private Button clearResultButton;
    private ScrollablePanel resultPanel;
    private TagDisplayWidget resultTagWidget;
    private final PanelsLayoutHelper panelsHelper = new PanelsLayoutHelper();
    private final FileActions fileActions;
    private final DataController dataController;

    public ReplacementEditorScreen() {
        super((Component)Component.m_237115_((String)"gui.oneenoughitem.replacement_editor.title"));
        this.manager = new ReplacementEditorManager();
        this.matchDataWidgets = new ArrayList<DataDisplayWidget>();
        this.matchTagWidgets = new ArrayList<TagDisplayWidget>();
        this.fileActions = new FileActions(this.manager);
        this.dataController = new DataController(this.manager, this::syncManagerDataToWidgets);
        this.loadFromCache();
    }

    private void loadFromCache() {
        EditorCache.CacheData cache = EditorCache.loadCache();
        if (cache != null) {
            for (String dataId : cache.matchItems()) {
                this.manager.addMatchDataId(dataId);
                DataDisplayWidget widget = new DataDisplayWidget(0, 0, dataId, button -> this.removeMatchDataId(dataId), true);
                this.matchDataWidgets.add(widget);
            }
            for (String tagId : cache.matchTags()) {
                ResourceLocation id = new ResourceLocation(tagId);
                this.manager.addMatchTag(id);
                TagDisplayWidget widget = new TagDisplayWidget(0, 0, id, button -> this.removeMatchTag(id));
                this.matchTagWidgets.add(widget);
            }
            if (cache.resultItem() != null) {
                this.manager.setResultDataId(cache.resultItem());
                this.resultDataWidget = new DataDisplayWidget(0, 0, cache.resultItem(), null, false);
            }
            if (cache.resultTag() != null) {
                ResourceLocation id = new ResourceLocation(cache.resultTag());
                this.manager.setResultTag(id);
                this.resultTagWidget = new TagDisplayWidget(0, 0, id, null);
            }
            if (cache.fileName() != null) {
                this.manager.setCurrentFileName(cache.fileName());
            }
        }
    }

    private void saveToCache() {
        EditorCache.saveCache(this.manager.getMatchDataIds(), this.manager.getMatchTags(), this.manager.getResultDataId(), this.manager.getResultTag(), this.manager.getCurrentFileName());
        this.showMessage((Component)Component.m_237115_((String)"message.oneenoughitem.cache_saved").m_130940_(ChatFormatting.GREEN));
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int topY = 15;
        this.manager.setUiUpdateCallback(this::syncManagerDataToWidgets);
        this.objectDropdownButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.object.select_element"), button -> this.toggleObjectDropdown(), 10, 10, 140, 18);
        this.updateObjectDropdownVisibility();
        int fileY = topY + 25;
        this.datapackNameBox = new EditBox(Minecraft.m_91087_().f_91062_, centerX - 140, fileY, 80, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.datapack_name"));
        this.datapackNameBox.m_257771_((Component)Component.m_237115_((String)"gui.oneenoughitem.datapack_name.hint"));
        this.m_142416_((GuiEventListener)this.datapackNameBox);
        this.fileNameBox = new EditBox(Minecraft.m_91087_().f_91062_, centerX - 55, fileY, 80, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.file_name"));
        this.fileNameBox.m_257771_((Component)Component.m_237115_((String)"gui.oneenoughitem.file_name.hint"));
        this.fileNameBox.m_94144_(this.manager.getCurrentFileName());
        this.m_142416_((GuiEventListener)this.fileNameBox);
        this.createFileButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.create_file"), button -> this.createFile(), centerX + 30, fileY, 70, 18);
        this.m_142416_((GuiEventListener)this.createFileButton);
        this.selectFileButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.select_file"), button -> this.selectFile(), centerX + 105, fileY, 70, 18);
        this.m_142416_((GuiEventListener)this.selectFileButton);
        this.reloadButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.reload"), button -> this.reloadDatapacks(), centerX - 140, fileY + 25, 60, 18);
        this.m_142416_((GuiEventListener)this.reloadButton);
        this.clearAllButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear_all"), button -> this.clearAll(), centerX - 75, fileY + 25, 60, 18);
        this.m_142416_((GuiEventListener)this.clearAllButton);
        this.saveToJSONButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.save_to_json"), button -> this.saveToJson(), centerX - 10, fileY + 25, 80, 18);
        this.m_142416_((GuiEventListener)this.saveToJSONButton);
        int webBtnX = centerX - 10 + 80 + 8;
        this.openWebEditorButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.web_rules_injector"), button -> this.openWebEditor(), webBtnX, fileY + 25, 90, 18);
        this.m_142416_((GuiEventListener)this.openWebEditorButton);
        int panelY = fileY + 55;
        int leftPanelX = centerX - 220 - 8;
        int rightPanelX = centerX + 8;
        int offsetX = 10;
        this.addMatchItemButton = GuiUtils.createButton(DomainRegistry.current().selectObjectLabel(), button -> this.openObjectSelection(true), leftPanelX + 5 + offsetX, panelY, 70, 18);
        this.m_142416_((GuiEventListener)this.addMatchItemButton);
        this.addMatchTagButton = GuiUtils.createButton(DomainRegistry.current().selectTagLabel(), button -> this.openTagSelection(true), leftPanelX + 70 + 8 + offsetX, panelY, 70, 18);
        this.m_142416_((GuiEventListener)this.addMatchTagButton);
        this.clearMatchButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear"), button -> this.clearMatchData(), leftPanelX + 140 + 11 + offsetX, panelY, 50, 18);
        this.m_142416_((GuiEventListener)this.clearMatchButton);
        int resultButtonSpacing = 10;
        int totalResultButtonWidth = 70 + resultButtonSpacing + 50;
        int resultButtonStartX = rightPanelX + (220 - totalResultButtonWidth) / 2 + offsetX;
        this.selectResultItemButton = GuiUtils.createButton(DomainRegistry.current().selectObjectLabel(), button -> this.openObjectSelection(false), resultButtonStartX, panelY, 70, 18);
        this.m_142416_((GuiEventListener)this.selectResultItemButton);
        if (ModUtils.hasAnyDomainModLoaded()) {
            this.domainDropdownButton = GuiUtils.createButton((Component)Component.m_237110_((String)"gui.oneenoughitem.domain_switch", (Object[])new Object[]{DomainRegistry.current().id()}), b -> {
                this.showDomainDropdown = !this.showDomainDropdown;
                this.updateDomainDropdown();
            }, this.f_96543_ - 90, 8, 90, 18);
            this.m_142416_((GuiEventListener)this.domainDropdownButton);
        }
        this.clearResultButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.clear"), button -> this.clearResultData(), resultButtonStartX + 70 + resultButtonSpacing, panelY, 50, 18);
        this.m_142416_((GuiEventListener)this.clearResultButton);
        int editorW = Math.round(272.8f);
        int editorH = Math.round(315.7f);
        int editorY = panelY + 0;
        int leftEditorX = leftPanelX + 5;
        int marginX = Math.round(16.12f);
        int headerGap = Math.round(29.315002f);
        int bottomMargin = Math.round(31.570002f);
        this.matchPanel = new ScrollablePanel(leftEditorX + marginX, editorY + headerGap, editorW - marginX * 2, editorH - headerGap - bottomMargin);
        this.m_142416_((GuiEventListener)this.matchPanel);
        this.resultPanel = new ScrollablePanel(rightPanelX + 12, panelY + 32, 210, 110);
        this.m_142416_((GuiEventListener)this.resultPanel);
        this.rebuildPanels();
    }

    private void toggleObjectDropdown() {
        this.showObjectDropdown = !this.showObjectDropdown;
        this.updateObjectDropdown();
    }

    private void syncManagerDataToWidgets() {
        AbstractWidget widget;
        this.matchDataWidgets.clear();
        this.matchTagWidgets.clear();
        this.resultDataWidget = null;
        this.resultTagWidget = null;
        for (String dataId : this.manager.getMatchDataIds()) {
            widget = new DataDisplayWidget(0, 0, dataId, button -> this.removeMatchDataId(dataId), true);
            this.matchDataWidgets.add((DataDisplayWidget)widget);
        }
        for (ResourceLocation tagId : this.manager.getMatchTags()) {
            widget = new TagDisplayWidget(0, 0, tagId, button -> this.removeMatchTag(tagId));
            this.matchTagWidgets.add((TagDisplayWidget)widget);
        }
        if (this.manager.getResultDataId() != null) {
            this.resultDataWidget = new DataDisplayWidget(0, 0, this.manager.getResultDataId(), null, false);
        }
        if (this.manager.getResultTag() != null) {
            this.resultTagWidget = new TagDisplayWidget(0, 0, this.manager.getResultTag(), null);
        }
        this.rebuildPanels();
    }

    private void removeMatchDataId(String dataId) {
        if (dataId != null) {
            this.manager.removeMatchDataId(dataId);
            this.matchDataWidgets.removeIf(widget -> dataId.equals(widget.getDataId()));
            this.rebuildPanels();
        }
    }

    private void updateObjectDropdown() {
        for (Button b : this.objectIndexButtons) {
            this.m_169411_((GuiEventListener)b);
        }
        this.objectIndexButtons.clear();
        this.objectDropdownPanel = ObjectDropdownController.rebuildDropdownPanel(this.objectDropdownButton, this.showObjectDropdown, this.manager, this.objectIndexButtons, this::selectObjectIndex, this::deleteCurrentObjectElement);
        if (this.objectDropdownButton != null) {
            this.objectDropdownButton.m_93666_(ObjectDropdownController.buildDropdownButtonText(this.showObjectDropdown, this.manager));
        }
    }

    private void selectObjectIndex(int index) {
        this.manager.setCurrentObjectIndex(index);
        this.showObjectDropdown = false;
        this.updateObjectDropdown();
    }

    private void deleteCurrentObjectElement() {
        if (this.manager.getCurrentObjectIndex() >= 0) {
            this.manager.deleteObjectElement(this.manager.getCurrentObjectIndex());
            this.showObjectDropdown = false;
            this.updateObjectDropdown();
        }
    }

    private void updateObjectDropdownVisibility() {
        if (this.objectDropdownButton != null) {
            boolean shouldShow;
            this.objectDropdownButton.f_93624_ = shouldShow = this.manager.getCurrentObjectIndex() >= -1 && this.manager.getObjectSize() > 0;
            if (shouldShow) {
                this.m_142416_((GuiEventListener)this.objectDropdownButton);
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 83 && (modifiers & 2) != 0) {
            this.saveToCache();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.f_96543_ / 2;
        int topY = 15;
        int fileY = topY + 25;
        int panelY = fileY + 55;
        int leftPanelX = centerX - 220 - 8;
        int rightPanelX = centerX + 8;
        int editorW = Math.round(272.8f);
        int editorH = Math.round(315.7f);
        int editorY = panelY + 0;
        int leftEditorX = leftPanelX + 5;
        int rightEditorX = rightPanelX + 5;
        GuiUtils.drawEditorPanel(graphics, leftEditorX, editorY, editorW, editorH);
        GuiUtils.drawEditorPanel(graphics, rightEditorX, editorY, editorW, editorH);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, this.f_96539_, centerX, 20, 0xFFFFFF);
        MutableComponent fileName = this.manager.getCurrentFileName().isEmpty() ? Component.m_237115_((String)"gui.oneenoughitem.current_file.none").m_130940_(ChatFormatting.GRAY) : Component.m_237113_((String)this.manager.getCurrentFileName()).m_130940_(ChatFormatting.AQUA);
        MutableComponent fileInfo = Component.m_237110_((String)"gui.oneenoughitem.current_file", (Object[])new Object[]{fileName});
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)fileInfo, centerX, 8, 0xAAAAAA);
        MutableComponent matchComponent = Component.m_237110_((String)"gui.oneenoughitem.match", (Object[])new Object[]{this.getDataIdComponent()});
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)matchComponent, leftPanelX + 110, panelY - 12, 0xFFFFFF);
        MutableComponent resultComponent = Component.m_237110_((String)"gui.oneenoughitem.result", (Object[])new Object[]{this.getDataIdComponent()});
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)resultComponent, rightPanelX + 110, panelY - 12, 0xFFFFFF);
        MutableComponent summaryComponent = Component.m_237110_((String)"gui.oneenoughitem.match_summary", (Object[])new Object[]{this.getDataIdComponent(), this.matchDataWidgets.size(), this.matchTagWidgets.size()});
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)summaryComponent, leftPanelX, panelY + 140 + 8, 0xAAAAAA);
        MutableComponent resultText = this.resultDataWidget != null ? Component.m_237110_((String)"gui.oneenoughitem.selected", (Object[])new Object[]{this.getDataIdComponent()}) : (this.resultTagWidget != null ? Component.m_237115_((String)"gui.oneenoughitem.tag_selected") : Component.m_237115_((String)"gui.oneenoughitem.no_result"));
        graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)resultText, rightPanelX, panelY + 140 + 8, 0xAAAAAA);
        graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"gui.oneenoughitem.save_to_cache"), centerX, panelY + 140 + 25, 0xFFFF00);
        if (this.showObjectDropdown && this.objectDropdownPanel != null) {
            this.objectDropdownPanel.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
        if (this.showDomainDropdown && this.domainDropdownPanel != null) {
            this.domainDropdownPanel.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    private void createFile() {
        String datapackName = this.datapackNameBox.m_94155_().trim();
        String fileName = this.fileNameBox.m_94155_().trim();
        if (fileName.isEmpty()) {
            this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.file_name_empty").m_130940_(ChatFormatting.RED));
            return;
        }
        String newName = this.fileActions.createFile(datapackName, fileName);
        this.fileNameBox.m_94144_(newName);
    }

    private void saveToJson() {
        this.fileActions.saveToJson();
    }

    private void openWebEditor() {
        String message = WebEditorServer.openInBrowser();
        if (message != null) {
            this.showMessage((Component)Component.m_237113_((String)message).m_130940_(ChatFormatting.YELLOW));
        }
    }

    private void selectFile() {
        this.fileActions.selectFile(this.f_96541_, this);
    }

    public void onFileSelected(Path filePath, int mode) {
        switch (mode) {
            case 0: {
                this.manager.selectJsonFile(filePath, 0);
                this.syncManagerDataToWidgets();
                break;
            }
            case 1: {
                this.manager.selectJsonFile(filePath, 1);
                this.syncManagerDataToWidgets();
                break;
            }
            case 2: {
                this.manager.deleteFile(filePath);
            }
        }
    }

    private void reloadDatapacks() {
        this.manager.reloadDatapacks();
    }

    private void clearAll() {
        this.manager.clearAll();
        this.matchDataWidgets.clear();
        this.matchTagWidgets.clear();
        this.resultDataWidget = null;
        this.resultTagWidget = null;
        this.fileNameBox.m_94144_("");
        this.rebuildPanels();
        this.updateObjectDropdownVisibility();
        this.updateObjectDropdown();
        EditorCache.clearCache();
    }

    private void updateDomainDropdown() {
        for (Button b2 : this.domainButtons) {
            this.m_169411_((GuiEventListener)b2);
        }
        this.domainButtons.clear();
        if (!this.showDomainDropdown) {
            this.domainDropdownPanel = null;
            return;
        }
        int x = this.domainDropdownButton.m_252754_();
        int y = this.domainDropdownButton.m_252907_() + 18 + 2;
        int w = 120;
        int h = 4 + (DomainRegistry.all().size() - 1) * 22;
        this.domainDropdownPanel = new ScrollablePanel(x, y, w, Math.max(h, 60));
        int btnY = y + 4;
        String currentId = DomainRegistry.current() != null ? DomainRegistry.current().id() : "oei";
        for (Map.Entry<String, DomainAdapter> entry : DomainRegistry.all().entrySet()) {
            String id = entry.getKey();
            if (id.equalsIgnoreCase(currentId)) continue;
            Button btn = GuiUtils.createButton((Component)Component.m_237110_((String)"gui.domain_dropdown.page", (Object[])new Object[]{id.toUpperCase(Locale.ROOT)}), b -> {
                if (DomainRegistry.switchTo(id)) {
                    this.onDomainSwitched();
                }
                this.showDomainDropdown = false;
                this.updateDomainDropdown();
            }, x + 4, btnY, w - 8, 18);
            btn.f_93623_ = DomainRegistry.has(id);
            this.domainButtons.add(btn);
            this.m_142416_((GuiEventListener)btn);
            btnY += 22;
        }
    }

    private void onDomainSwitched() {
        this.showDomainDropdown = false;
        this.domainDropdownButton.m_93666_((Component)Component.m_237110_((String)"gui.oneenoughitem.domain_switch", (Object[])new Object[]{DomainRegistry.current().id()}));
        this.addMatchItemButton.m_93666_(DomainRegistry.current().selectObjectLabel());
        this.addMatchTagButton.m_93666_(DomainRegistry.current().selectTagLabel());
        this.selectResultItemButton.m_93666_(DomainRegistry.current().selectObjectLabel());
        this.refreshForCurrentDomain();
    }

    private void refreshForCurrentDomain() {
        this.manager.clearAll();
        this.matchDataWidgets.clear();
        this.matchTagWidgets.clear();
        this.resultDataWidget = null;
        this.resultTagWidget = null;
        if (this.fileNameBox != null) {
            this.fileNameBox.m_94144_("");
        }
        this.loadFromCache();
        this.rebuildPanels();
        this.updateObjectDropdownVisibility();
        this.showObjectDropdown = false;
        this.updateObjectDropdown();
        this.showDomainDropdown = false;
        this.updateDomainDropdown();
    }

    private void openObjectSelection(boolean isForMatch) {
        this.f_96541_.m_91152_(DomainRegistry.current().createObjectSelectionScreen(this, isForMatch));
    }

    private void openTagSelection(boolean isForMatch) {
        this.f_96541_.m_91152_(DomainRegistry.current().createTagSelectionScreen(this, isForMatch));
    }

    private void clearMatchData() {
        this.matchDataWidgets.clear();
        this.matchTagWidgets.clear();
        this.dataController.clearMatchData();
        this.rebuildPanels();
    }

    private void clearResultData() {
        this.resultDataWidget = null;
        this.resultTagWidget = null;
        this.dataController.clearResultData();
        this.rebuildPanels();
    }

    public void addMatchDataId(String dataId) {
        if (dataId != null) {
            String runtimeReplacement = DomainRegistry.current().runtimeCache().matchData(dataId);
            String globalReplacement = DomainRegistry.current().globalCache().getDataReplacement(dataId);
            if (runtimeReplacement != null || globalReplacement != null) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.item_already_replaced").m_130940_(ChatFormatting.RED));
                return;
            }
            if (DomainRegistry.current().globalCache().isDataUsedAsResult(dataId)) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.item_used_as_result").m_130940_(ChatFormatting.RED));
                return;
            }
        }
        this.dataController.addMatchDataId(dataId);
        this.syncManagerDataToWidgets();
    }

    public void setResultDataId(String dataId) {
        if (dataId != null) {
            String runtimeReplacement = DomainRegistry.current().runtimeCache().matchData(dataId);
            String globalReplacement = DomainRegistry.current().globalCache().getDataReplacement(dataId);
            if (runtimeReplacement != null || globalReplacement != null) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.result_item_already_replaced").m_130940_(ChatFormatting.RED));
                return;
            }
            if (DomainRegistry.current().globalCache().isDataReplaced(dataId)) {
                this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.result_item_used_as_match").m_130940_(ChatFormatting.RED));
                return;
            }
        }
        this.dataController.setResultDataId(dataId);
        this.syncManagerDataToWidgets();
    }

    public void addMatchItem(Item item) {
        String id = DomainRegistry.current().dataIdFromItem(item);
        if (id != null) {
            this.addMatchDataId(id);
        }
    }

    public void setResultItem(Item item) {
        String id = DomainRegistry.current().dataIdFromItem(item);
        if (id != null) {
            this.setResultDataId(id);
        }
    }

    public void addMatchTag(ResourceLocation tagId) {
        if (this.manager.getMatchTags().contains(tagId)) {
            this.showWarn((Component)Component.m_237115_((String)"warning.oneenoughitem.tag_exists").m_130940_(ChatFormatting.YELLOW));
            return;
        }
        if (DomainRegistry.current().runtimeCache().isTagReplaced(tagId) || DomainRegistry.current().globalCache().isTagReplaced(tagId.toString()) || DomainRegistry.current().globalCache().isTagUsedAsResult(tagId.toString())) {
            this.showError((Component)Component.m_237115_((String)"error.oneenoughitem.tag_already_replaced").m_130940_(ChatFormatting.RED));
            return;
        }
        this.dataController.addMatchTag(tagId);
        this.syncManagerDataToWidgets();
    }

    public void setResultTag(ResourceLocation tagId) {
        this.dataController.setResultTag(tagId);
        this.resultTagWidget = new TagDisplayWidget(0, 0, tagId, null);
        this.resultDataWidget = null;
        this.rebuildPanels();
    }

    private void removeMatchTag(ResourceLocation tagId) {
        this.dataController.removeMatchTag(tagId);
        this.matchTagWidgets.removeIf(widget -> widget.getTagId().equals((Object)tagId));
        this.rebuildPanels();
    }

    protected void rebuildPanels() {
        this.panelsHelper.rebuildPanels(this.matchPanel, this.resultPanel, this.matchDataWidgets, this.matchTagWidgets, this.resultDataWidget, this.resultTagWidget);
    }

    private void showError(Component message) {
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_(message, false);
        }
    }

    private void showWarn(Component message) {
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_(message, false);
        }
    }

    private void showMessage(Component message) {
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_(message, false);
        }
    }

    public List<Path> scanReplacementFiles() {
        return this.fileActions.scanReplacementFiles();
    }

    private Component getDataIdComponent() {
        String currentDataId = DomainRegistry.currentDataId().toLowerCase(Locale.ROOT);
        return Component.m_237115_((String)("gui.oneenoughitem.data_id." + currentDataId));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.showObjectDropdown && this.objectDropdownPanel != null && this.objectDropdownPanel.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.showObjectDropdown && this.domainDropdownPanel != null && this.domainDropdownPanel.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.showObjectDropdown && this.objectDropdownPanel != null && this.objectDropdownPanel.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.showObjectDropdown && this.domainDropdownPanel != null && this.domainDropdownPanel.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.showObjectDropdown && this.objectDropdownPanel != null && this.objectDropdownPanel.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.showObjectDropdown && this.domainDropdownPanel != null && this.domainDropdownPanel.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.showObjectDropdown && this.objectDropdownPanel != null && this.objectDropdownPanel.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        if (this.showObjectDropdown && this.domainDropdownPanel != null && this.domainDropdownPanel.m_6050_(mouseX, mouseY, delta)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }
}

