/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui;

import com.mafuyu404.oneenoughitem.client.gui.BaseObjectSelectionScreen;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.cache.ItemGlobalReplacementCache;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.init.ItemReplacementCache;
import com.mafuyu404.oneenoughitem.util.ReplacementControl;
import com.mafuyu404.oneenoughitem.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemSelectionScreen
extends BaseObjectSelectionScreen<Item> {
    public ItemSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        super(parent, isForMatch, (Component)Component.m_237115_((String)"gui.oneenoughitem.item_selection.title"));
        this.allObjects = this.loadAllObjects();
        this.filteredObjects = new ArrayList(this.allObjects);
    }

    @Override
    protected Component sortLabel() {
        return Component.m_237115_((String)"gui.oneenoughitem.sort.name");
    }

    @Override
    protected List<Item> loadAllObjects() {
        return ForgeRegistries.ITEMS.getValues().stream().filter(item -> item != Items.f_41852_).collect(Collectors.toList());
    }

    @Override
    protected String getId(Item obj) {
        return Utils.getItemRegistryName(obj);
    }

    @Override
    protected void renderObject(Item obj, GuiGraphics graphics, int x, int y) {
        ItemStack stack = ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)obj));
        GuiUtils.drawItemBox(graphics, x, y, 18, 18);
        graphics.m_280480_(stack, x + 1, y + 1);
        graphics.m_280370_(Minecraft.m_91087_().f_91062_, stack, x + 1, y + 1);
    }

    @Override
    protected void onSelectSingle(String id) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)id);
        if (rl == null) {
            return;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
        if (item == null || item == Items.f_41852_) {
            return;
        }
        if (this.isForMatch) {
            this.parent.addMatchItem(item);
        } else {
            this.parent.setResultItem(item);
        }
    }

    @Override
    protected boolean isSelectable(String id, boolean forMatch) {
        String runtimeReplacement = ItemReplacementCache.matchItem(id);
        String globalReplacement = ItemGlobalReplacementCache.get().getDataReplacement(id);
        if (runtimeReplacement != null || globalReplacement != null) {
            return false;
        }
        if (forMatch) {
            return !ItemGlobalReplacementCache.isItemUsedAsResult(id);
        }
        return !ItemGlobalReplacementCache.get().isDataReplaced(id);
    }

    @Override
    protected void onSort() {
        super.onSort();
    }

    @Override
    protected Comparator<Item> getComparator(BaseObjectSelectionScreen.SortMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case BaseObjectSelectionScreen.SortMode.NAME -> Comparator.comparing(item -> {
                ItemStack stack = ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)item));
                return stack.m_41786_().getString();
            });
            case BaseObjectSelectionScreen.SortMode.MOD -> Comparator.comparing(item -> Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).m_135827_());
            case BaseObjectSelectionScreen.SortMode.ID -> Comparator.comparing(item -> Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)).toString());
        };
    }

    @Override
    protected void updateGrid() {
        if (this.itemGrid == null) {
            return;
        }
        ArrayList<ItemStack> pageItems = new ArrayList<ItemStack>();
        int startIndex = this.currentPage * 45;
        int endIndex = Math.min(startIndex + 45, this.filteredObjects.size());
        int i = startIndex;
        while (i < endIndex) {
            int finalI = i++;
            ItemStack itemStack = ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)this.filteredObjects.get(finalI)));
            pageItems.add(itemStack);
        }
        this.itemGrid.setItems(pageItems);
        this.itemGrid.setSelectedItemIds(this.selectedIds);
    }
}

