/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_bs.content.vault;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_bs.content.TierMaterials;
import uwu.lopyluna.create_bs.content.vault.TieredVaultBlockEntity;
import uwu.lopyluna.create_bs.registry.BSBlockEntities;
import uwu.lopyluna.create_bs.registry.BSBlocks;

@MethodsReturnNonnullByDefault
public class TieredVaultBlock
extends Block
implements IWrenchable,
IBE<TieredVaultBlockEntity> {
    public static final Property<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.f_61364_;
    public static final BooleanProperty LARGE = BooleanProperty.m_61465_((String)"large");
    TierMaterials tierMaterials;

    public TieredVaultBlock(BlockBehaviour.Properties p_i48440_1_, TierMaterials tierMaterials) {
        super(p_i48440_1_);
        this.tierMaterials = tierMaterials;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HORIZONTAL_AXIS, LARGE});
        super.m_7926_(pBuilder);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState placedOn;
        Direction.Axis preferredAxis;
        if (!(pContext.m_43723_() != null && pContext.m_43723_().m_6144_() || (preferredAxis = TieredVaultBlock.getVaultBlockAxis(placedOn = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pContext.m_43719_().m_122424_())), this.tierMaterials)) == null)) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)preferredAxis);
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    @ParametersAreNonnullByDefault
    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.m_60734_() == pState.m_60734_()) {
            return;
        }
        if (pIsMoving) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, TieredVaultBlockEntity::updateConnectivity);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.m_43719_().m_122434_().m_122478_()) {
            BlockEntity be = context.m_43725_().m_7702_(context.m_8083_());
            if (be instanceof TieredVaultBlockEntity) {
                TieredVaultBlockEntity vault = (TieredVaultBlockEntity)be;
                ConnectivityHandler.splitMulti((BlockEntity)vault);
                vault.removeController(true);
            }
            state = (BlockState)state.m_61124_((Property)LARGE, (Comparable)Boolean.valueOf(false));
        }
        return super.onWrenched(state, context);
    }

    @ParametersAreNonnullByDefault
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean pIsMoving) {
        if (state.m_155947_() && (state.m_60734_() != newState.m_60734_() || !newState.m_155947_())) {
            BlockEntity be = world.m_7702_(pos);
            if (!(be instanceof TieredVaultBlockEntity)) {
                return;
            }
            TieredVaultBlockEntity vaultBE = (TieredVaultBlockEntity)be;
            ItemHelper.dropContents((Level)world, (BlockPos)pos, (IItemHandler)vaultBE.inventory);
            world.m_46747_(pos);
            ConnectivityHandler.splitMulti((BlockEntity)vaultBE);
        }
    }

    public static boolean isVault(BlockState state, TierMaterials tier) {
        return BSBlocks.VAULTS.get(tier).has(state);
    }

    @Nullable
    public static Direction.Axis getVaultBlockAxis(BlockState state, TierMaterials tier) {
        if (!TieredVaultBlock.isVault(state, tier)) {
            return null;
        }
        return (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
    }

    public static boolean isLarge(BlockState state, TierMaterials tier) {
        if (!TieredVaultBlock.isVault(state, tier)) {
            return false;
        }
        return (Boolean)state.m_61143_((Property)LARGE);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(HORIZONTAL_AXIS);
        return (BlockState)state.m_61124_(HORIZONTAL_AXIS, (Comparable)rot.m_55954_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122434_());
    }

    @ParametersAreNonnullByDefault
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public SoundType silencedSound() {
        SoundType type = this.tierMaterials.soundType;
        return new ForgeSoundType(0.1f, 1.5f, () -> ((SoundType)type).m_56775_(), () -> ((SoundType)type).m_56776_(), () -> ((SoundType)type).m_56777_(), () -> ((SoundType)type).m_56778_(), () -> ((SoundType)type).m_56779_());
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().m_128441_("SilenceVaultSound")) {
            return this.silencedSound();
        }
        return soundType;
    }

    public boolean m_7278_(@NotNull BlockState p_149740_1_) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        return this.getBlockEntityOptional((BlockGetter)pLevel, pPos).map(vte -> vte.getCapability(ForgeCapabilities.ITEM_HANDLER)).map(lo -> lo.map(ItemHelper::calcRedstoneFromInventory).orElse(0)).orElse(0);
    }

    public BlockEntityType<? extends TieredVaultBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BSBlockEntities.VAULTS.get(this.tierMaterials).get();
    }

    public Class<TieredVaultBlockEntity> getBlockEntityClass() {
        return TieredVaultBlockEntity.class;
    }

    public boolean isSeeThrough() {
        return this.tierMaterials.seeThrough;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pSide) {
        TieredVaultBlock block;
        Block block2;
        return this.isSeeThrough() ? (block2 = pAdjacentBlockState.m_60734_()) instanceof TieredVaultBlock && (block = (TieredVaultBlock)block2).isSeeThrough() || super.m_6104_(pState, pAdjacentBlockState, pSide) : super.m_6104_(pState, pAdjacentBlockState, pSide);
    }

    @ParametersAreNonnullByDefault
    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return this.isSeeThrough() ? Shapes.m_83040_() : super.m_5909_(pState, pReader, pPos, pContext);
    }

    @ParametersAreNonnullByDefault
    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return this.isSeeThrough() ? 1.0f : super.m_7749_(pState, pLevel, pPos);
    }

    @ParametersAreNonnullByDefault
    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return this.isSeeThrough() || super.m_7420_(pState, pReader, pPos);
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return this.isSeeThrough() || this.shouldDisplayFluidOverlay(state, world, pos, fluidState);
    }
}

