/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.part;

import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.blockentity.inventory.AppEngCellInventory;
import appeng.client.render.tesr.CellLedRenderer;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.storage.DriveWatcher;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CellDockPart
extends AEBasePart
implements InternalInventoryHost,
IChestOrDrive,
IPriorityHost,
IStorageProvider {
    @PartModels
    public static final IPartModel MODEL = new PartModel(MEGACells.makeId("part/cell_dock"));
    private final AppEngCellInventory cellInventory = new AppEngCellInventory((InternalInventoryHost)this, 1);
    private DriveWatcher cellWatcher;
    private boolean isCached = false;
    private boolean wasOnline = false;
    private int priority = 0;
    private Item clientCell = Items.f_41852_;
    private CellState clientCellState = CellState.ABSENT;

    public CellDockPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage(0.5).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).addService(IStorageProvider.class, (IGridNodeService)this);
        this.cellInventory.setFilter((IAEItemFilter)new CellInventoryFilter());
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.cellInventory.setItemDirect(0, ItemStack.m_41712_((CompoundTag)data.m_128469_("cell")));
        this.priority = data.m_128451_("priority");
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        CompoundTag cell = new CompoundTag();
        this.getCell().m_41739_(cell);
        data.m_128365_("cell", (Tag)cell);
        data.m_128405_("priority", this.priority);
    }

    public boolean readFromStream(FriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        Item oldCell = this.clientCell;
        CellState oldCellState = this.clientCellState;
        this.clientCell = (Item)BuiltInRegistries.f_257033_.m_7745_(data.m_130281_());
        this.clientCellState = (CellState)data.m_130066_(CellState.class);
        return changed || oldCell != this.clientCell || oldCellState != this.clientCellState;
    }

    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.m_130085_(BuiltInRegistries.f_257033_.m_7981_((Object)this.getCell().m_41720_()));
        this.clientCellState = this.getCellStatus(0);
        data.m_130068_((Enum)this.clientCellState);
    }

    public void readVisualStateFromNBT(CompoundTag data) {
        super.readVisualStateFromNBT(data);
        try {
            this.clientCell = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(data.m_128461_("cellId")));
        }
        catch (Exception e) {
            MEGACells.LOGGER.warn("Couldn't read cell item for {} from {}", (Object)this, (Object)data);
            this.clientCell = Items.f_41852_;
        }
        try {
            this.clientCellState = CellState.valueOf((String)data.m_128461_("cellStatus"));
        }
        catch (Exception e) {
            MEGACells.LOGGER.warn("Couldn't read cell status for {} from {}", (Object)this, (Object)data);
            this.clientCellState = CellState.ABSENT;
        }
    }

    public void writeVisualStateToNBT(CompoundTag data) {
        super.writeVisualStateToNBT(data);
        data.m_128359_("cellId", BuiltInRegistries.f_257033_.m_7981_((Object)this.getCell().m_41720_()).toString());
        data.m_128359_("cellStatus", this.getCellStatus(0).name());
    }

    private void recalculateDisplay() {
        CellState cellState = this.getCellStatus(0);
        if (this.clientCellState != cellState) {
            this.getHost().markForUpdate();
            this.clientCellState = cellState;
        }
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        boolean online = this.getMainNode().isOnline();
        if (online != this.wasOnline) {
            this.wasOnline = online;
            IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
            this.recalculateDisplay();
        }
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        if (!player.m_20193_().m_5776_()) {
            MenuOpener.open(MEGAMenus.CELL_DOCK, (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        drops.add(this.getCell());
    }

    public AppEngCellInventory getCellInventory() {
        return this.cellInventory;
    }

    private ItemStack getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    public int getCellCount() {
        return 1;
    }

    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Nullable
    public Item getCellItem(int slot) {
        return slot == 0 ? this.cellInventory.getStackInSlot(slot).m_41720_() : null;
    }

    @Nullable
    public MEStorage getCellInventory(int slot) {
        return slot == 0 && this.cellWatcher != null ? this.cellWatcher : null;
    }

    @Nullable
    public StorageCell getOriginalCellInventory(int slot) {
        return slot == 0 && this.cellWatcher != null ? this.cellWatcher.getCell() : null;
    }

    public CellState getCellStatus(int slot) {
        return this.isClientSide() ? this.clientCellState : (slot == 0 && this.cellWatcher != null ? this.cellWatcher.getStatus() : CellState.ABSENT);
    }

    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isOnline()) {
            this.updateState();
            if (this.cellWatcher != null) {
                storageMounts.mount((MEStorage)this.cellWatcher, this.priority);
            }
        }
    }

    public void saveChanges() {
        this.getHost().markForSave();
        this.getHost().markForUpdate();
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    private void updateState() {
        if (!this.isCached) {
            StorageCell cell;
            this.cellWatcher = null;
            this.cellInventory.setHandler(0, null);
            double power = 0.5;
            if (!this.getCell().m_41619_() && (cell = StorageCells.getCellInventory((ItemStack)this.getCell(), this::onCellContentChanged)) != null) {
                this.cellWatcher = new DriveWatcher(cell, this::recalculateDisplay);
                this.cellInventory.setHandler(0, cell);
                power += cell.getIdleDrain();
            }
            this.getMainNode().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    private void onCellContentChanged() {
        this.getLevel().m_151543_(this.getBlockEntity().m_58899_());
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.isCached = false;
        this.updateState();
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(MEGAMenus.CELL_DOCK, (Player)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public ItemStack getMainMenuIcon() {
        return MEGAItems.CELL_DOCK.stack();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 12.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 12.0);
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean requireDynamicRender() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        if (this.getLevel() == null || this.clientCell == Items.f_41852_) {
            return;
        }
        Direction front = this.getSide() == Direction.UP || this.getSide() == Direction.DOWN ? Direction.NORTH : Direction.UP;
        BlockOrientation orientation = BlockOrientation.get((Direction)front, (Direction)this.getSide());
        BakedModel cellModel = MEGACells.Client.PLATFORM.createCellModel(this.clientCell, orientation);
        if (cellModel == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(orientation.getQuaternion());
        poseStack.m_252880_(-0.1875f, 0.3125f, -0.25f);
        Minecraft.m_91087_().m_91289_().m_110937_().m_234379_((BlockAndTintGetter)this.getLevel(), cellModel, this.getBlockEntity().m_58900_(), this.getBlockEntity().m_58899_(), poseStack, buffers.m_6299_(RenderType.m_110463_()), false, RandomSource.m_216327_(), 0L, combinedOverlayIn);
        CellLedRenderer.renderLed((IChestOrDrive)this, (int)0, (VertexConsumer)buffers.m_6299_(CellLedRenderer.RENDER_LAYER), (PoseStack)poseStack, (float)partialTicks);
        poseStack.m_85849_();
    }

    private static class CellInventoryFilter
    implements IAEItemFilter {
        private CellInventoryFilter() {
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return StorageCells.isCellHandled((ItemStack)stack);
        }
    }
}

