/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.content.ponder;

import com.cak.pattern_schematics.content.item.PatternSchematicItem;
import com.cak.pattern_schematics.registry.PatternSchematicsRegistry;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.instruction.DisplayWorldSectionInstruction;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PatternSchematicPonderScenes {
    public static void schematicPrinting(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("schematic_printing", "Printing patterns with pattern schematics");
        scene.scaleSceneView(0.75f);
        scene.configureBasePlate(0, 0, 14);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.idle(20);
        BlockPos schematicSavingFrom = new BlockPos(5, 1, 4);
        BlockPos schematicSavingTo = new BlockPos(7, 3, 5);
        Selection schematicSavingSelection = util.select().fromTo(schematicSavingFrom, schematicSavingTo);
        scene.world().showSection(schematicSavingSelection, Direction.DOWN);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(6.0, 3.0, 5.0)).text("To use pattern schematics, you must first save a schematic to use as a source");
        scene.idle(50);
        ItemStack schematicAndQuillStack = AllItems.SCHEMATIC_AND_QUILL.asStack();
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, (Object)"schematic_saving", new AABB(schematicSavingFrom, schematicSavingTo.m_7918_(1, 1, 1)), 100);
        scene.overlay().showControls(Vec3.m_82512_((Vec3i)schematicSavingFrom), Pointing.DOWN, 50).rightClick().withItem(schematicAndQuillStack);
        scene.idle(30);
        scene.overlay().showControls(Vec3.m_82512_((Vec3i)schematicSavingTo), Pointing.DOWN, 30).rightClick().withItem(schematicAndQuillStack);
        scene.idle(50);
        scene.addKeyframe();
        scene.world().showSection(util.select().position(2, 1, 2), Direction.DOWN);
        scene.overlay().showText(70).placeNearTarget().pointAt(new Vec3(2.5, 1.0, 2.5)).text("Then, use a schematic table with an empty pattern schematic");
        scene.idle(40);
        ItemStack emptyPatternSchematicItem = PatternSchematicsRegistry.EMPTY_PATTERN_SCHEMATIC.asStack();
        ItemStack patternSchematicItem = PatternSchematicsRegistry.PATTERN_SCHEMATIC.asStack();
        ElementLink currentItem = scene.world().createItemEntity(new Vec3(2.5, 4.0, 2.5), new Vec3(0.0, 0.0, 0.0), emptyPatternSchematicItem);
        scene.idle(40);
        scene.overlay().showText(60).placeNearTarget().pointAt(new Vec3(2.5, 1.0, 2.5)).text("Use the table to upload the schematic");
        scene.idle(40);
        scene.world().modifyEntity(currentItem, Entity::m_6074_);
        scene.world().createItemEntity(new Vec3(2.5, 2.0, 2.5), new Vec3(0.0, 0.25, 0.0), patternSchematicItem);
        scene.idle(50);
        scene.addKeyframe();
        scene.overlay().showText(70).placeNearTarget().pointAt(new Vec3(2.5, 2.0, 2.5)).text("Then, using the clone tool in the options, the structure can be repeated");
        scene.idle(80);
        Vec3i sectionOffset = new Vec3i(3, 0, 0);
        BlockPos sectionMin = new BlockPos(1, 1, 11);
        BlockPos sectionMax = new BlockPos(3, 3, 12);
        scene.overlay().showText(60).placeNearTarget().pointAt(new Vec3(2.5, 2.0, 12.0)).text("Clones get placed next to each other");
        for (int i = 0; i < 4; ++i) {
            scene.world().showSection(util.select().fromTo(sectionMin.m_121955_(sectionOffset.m_142393_(i)), sectionMax.m_121955_(sectionOffset.m_142393_(i))), Direction.DOWN);
            scene.idle(2);
        }
        scene.idle(62);
        scene.addKeyframe();
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(2.5, 2.0, 2.5)).text("Additionally, the schematic can be rotated");
        scene.idle(60);
        Vec3i sectionOffset2 = new Vec3i(0, 0, 3);
        BlockPos sectionMin2 = new BlockPos(11, 1, 1);
        BlockPos sectionMax2 = new BlockPos(12, 3, 3);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(12.0, 2.0, 2.5)).text("This rotation will then apply to all clones");
        for (int i = 0; i < 3; ++i) {
            scene.world().showSection(util.select().fromTo(sectionMin2.m_121955_(sectionOffset2.m_142393_(i)), sectionMax2.m_121955_(sectionOffset2.m_142393_(i))), Direction.DOWN);
            scene.idle(2);
        }
        scene.idle(50);
        scene.markAsFinished();
    }

    public static void trainSchematicPrinting(SceneBuilder builder, SceneBuildingUtil util) {
        int z;
        int x;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("train_schematic_printing", "Infinite schematic printing with trains");
        scene.scaleSceneView(0.75f);
        scene.configureBasePlate(0, 0, 12);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.idle(20);
        BlockPos sectionFrom = new BlockPos(11, 1, 6);
        BlockPos selectionTo = new BlockPos(11, 2, 8);
        for (int i = 0; i <= 12; ++i) {
            scene.world().showSection(util.select().fromTo(sectionFrom, selectionTo), Direction.DOWN);
            scene.idle(2);
            sectionFrom = sectionFrom.m_7918_(-1, 0, 0);
            selectionTo = selectionTo.m_7918_(-1, 0, 0);
        }
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(10, 3, 7, 11, 4, 7), Direction.DOWN);
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(10, 3, 2, 10, 4, 6), Direction.SOUTH);
        scene.idle(20);
        scene.addKeyframe();
        scene.overlay().showOutlineWithText(util.select().fromTo(10, 3, 2, 10, 3, 4), 80).placeNearTarget().pointAt(new Vec3(10.5, 3.5, 3.5)).text("A single pattern schematic can be applied to a group of assembled deployers with Shift + Right Click");
        scene.idle(80);
        scene.overlay().showControls(new Vec3(10.5, 3.5, 3.5), Pointing.DOWN, 50).withItem(((PatternSchematicItem)((Object)PatternSchematicsRegistry.PATTERN_SCHEMATIC.get())).m_7968_()).rightClick().whileSneaking();
        scene.idle(60);
        scene.addKeyframe();
        ElementLink trainSection = scene.world().makeSectionIndependent(util.select().fromTo(10, 3, 2, 11, 4, 7));
        scene.world().moveSection(trainSection, new Vec3(-1.0, 0.0, 0.0), 10);
        scene.world().animateBogey(util.grid().at(10, 3, 7), 1.0f, 10);
        for (x = 10; x >= 9; --x) {
            for (z = 2; z <= 4; ++z) {
                scene.world().moveDeployer(util.grid().at(10, 3, z), 1.0f, 4);
            }
            scene.idle(4);
            scene.addInstruction((PonderInstruction)new DisplayWorldSectionInstruction(0, Direction.DOWN, util.select().fromTo(x, 1, 2, x, 2, 4), null));
            scene.idle(1);
            for (z = 2; z <= 4; ++z) {
                scene.world().moveDeployer(util.grid().at(10, 3, z), -1.0f, 4);
            }
            scene.idle(5);
        }
        scene.idle(30);
        scene.overlay().showOutlineWithText(util.select().fromTo(9, 1, 2, 10, 2, 4), 80).placeNearTarget().pointAt(new Vec3(10.0, 2.0, 3.5)).text("Here, the schematic has been placed as usual");
        scene.idle(90);
        scene.overlay().showText(80).placeNearTarget().pointAt(new Vec3(8.5, 3.5, 7.5)).text("But moving the train further will result in the schematic repeating");
        scene.idle(90);
        scene.world().moveSection(trainSection, new Vec3(-8.0, 0.0, 0.0), 80);
        scene.world().animateBogey(util.grid().at(10, 3, 7), 8.0f, 80);
        scene.idle(5);
        for (x = 8; x >= 1; --x) {
            for (z = 2; z <= 4; ++z) {
                scene.world().moveDeployer(util.grid().at(10, 3, z), 1.0f, 4);
            }
            scene.idle(4);
            scene.addInstruction((PonderInstruction)new DisplayWorldSectionInstruction(0, Direction.DOWN, util.select().fromTo(x, 1, 2, x, 2, 4), null));
            scene.idle(1);
            for (z = 2; z <= 4; ++z) {
                scene.world().moveDeployer(util.grid().at(10, 3, z), -1.0f, 4);
            }
            scene.idle(5);
        }
        scene.idle(20);
        scene.markAsFinished();
    }
}

