/*
 * Decompiled with CFR 0.152.
 */
package com.pyzpre.createbitterballen.block.mechanicalfryer;

import com.pyzpre.createbitterballen.block.mechanicalfryer.MechanicalFryerEntity;
import com.pyzpre.createbitterballen.index.RecipeRegistry;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DeepFryingRecipe
extends BasinRecipe {
    public static boolean match(BasinBlockEntity basin, MechanicalFryerEntity fryer, Recipe<?> recipe) {
        BasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_(basin.m_58904_().m_9598_()));
        if (recipe instanceof BasinRecipe && (basinRecipe = (BasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return DeepFryingRecipe.apply(basin, fryer, recipe, true);
    }

    public static boolean apply(SmartInventory inv, BasinBlockEntity basin, MechanicalFryerEntity fryer, Recipe<?> recipe) {
        boolean isDeepFryingRecipe = recipe instanceof DeepFryingRecipe;
        SmartInventory availableItems = fryer.inputInv;
        IFluidHandler availableFluids = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.m_58904_().m_8055_(basin.m_58899_().m_6625_(1)));
        if (isDeepFryingRecipe && !((DeepFryingRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ItemStack inputStack = availableItems.getStackInSlot(0);
        int itemCount = inputStack.m_41613_();
        if (itemCount <= 0) {
            return false;
        }
        NonNullList fluidIngredients = ((DeepFryingRecipe)recipe).getFluidIngredients();
        int maxProcessableItems = itemCount;
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            int requiredAmount = fluidIngredient.getRequiredAmount();
            int totalMatchingAmount = 0;
            for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                FluidStack fluidInTank = availableFluids.getFluidInTank(tank);
                if (!fluidIngredient.test(fluidInTank)) continue;
                totalMatchingAmount += fluidInTank.getAmount();
            }
            maxProcessableItems = Math.min(maxProcessableItems, totalMatchingAmount / requiredAmount);
        }
        if (maxProcessableItems <= 0) {
            return false;
        }
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            int drainedAmount;
            FluidStack fluidInTank;
            int amountToConsume = fluidIngredient.getRequiredAmount() * maxProcessableItems;
            for (int tank = 0; !(tank >= availableFluids.getTanks() || fluidIngredient.test(fluidInTank = availableFluids.getFluidInTank(tank)) && (amountToConsume -= (drainedAmount = availableFluids.drain(new FluidStack(fluidInTank, amountToConsume), IFluidHandler.FluidAction.EXECUTE).getAmount())) <= 0); ++tank) {
            }
        }
        inputStack.m_41774_(maxProcessableItems);
        List<ItemStack> recipeOutputItems = DeepFryingRecipe.generateOutputs(recipe, basin, maxProcessableItems);
        for (ItemStack itemStack : recipeOutputItems) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)fryer.outputInv, (ItemStack)itemStack, (boolean)false);
            if (remaining.m_41619_()) continue;
            return false;
        }
        basin.m_6596_();
        basin.sendData();
        fryer.sendData();
        fryer.m_6596_();
        return true;
    }

    private static boolean apply(BasinBlockEntity basin, MechanicalFryerEntity fryer, Recipe<?> recipe, boolean test) {
        boolean isDeepFryingRecipe = recipe instanceof DeepFryingRecipe;
        SmartInventory availableItems = fryer.inputInv;
        IFluidHandler availableFluids = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)basin.m_58904_().m_8055_(basin.m_58899_().m_6625_(1)));
        if (isDeepFryingRecipe && !((DeepFryingRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ItemStack inputStack = availableItems.getStackInSlot(0);
        int itemCount = inputStack.m_41613_();
        if (itemCount <= 0) {
            return false;
        }
        NonNullList fluidIngredients = isDeepFryingRecipe ? ((DeepFryingRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        int maxProcessableItems = itemCount;
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            int requiredAmount = fluidIngredient.getRequiredAmount();
            int totalMatchingAmount = 0;
            for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                FluidStack fluidInTank = availableFluids.getFluidInTank(tank);
                if (!fluidIngredient.test(fluidInTank)) continue;
                totalMatchingAmount += fluidInTank.getAmount();
            }
            maxProcessableItems = Math.min(maxProcessableItems, totalMatchingAmount / requiredAmount);
        }
        if (maxProcessableItems <= 0) {
            return false;
        }
        inputStack.m_41774_(maxProcessableItems);
        for (FluidIngredient fluidIngredient : fluidIngredients) {
            int drainedAmount;
            FluidStack fluidInTank;
            int amountToConsume = fluidIngredient.getRequiredAmount() * maxProcessableItems;
            for (int tank = 0; !(tank >= availableFluids.getTanks() || fluidIngredient.test(fluidInTank = availableFluids.getFluidInTank(tank)) && (amountToConsume -= (drainedAmount = availableFluids.drain(new FluidStack(fluidInTank, amountToConsume), IFluidHandler.FluidAction.EXECUTE).getAmount())) <= 0); ++tank) {
            }
        }
        List<ItemStack> recipeOutputItems = DeepFryingRecipe.generateOutputs(recipe, basin, maxProcessableItems);
        for (ItemStack itemStack : recipeOutputItems) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)fryer.outputInv, (ItemStack)itemStack, (boolean)false);
            if (remaining.m_41619_()) continue;
            return false;
        }
        basin.m_6596_();
        basin.sendData();
        fryer.sendData();
        fryer.m_6596_();
        return true;
    }

    private static List<ItemStack> generateOutputs(Recipe<?> recipe, BasinBlockEntity basin, int quantity) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (recipe instanceof BasinRecipe) {
            for (ItemStack result : ((BasinRecipe)recipe).rollResults()) {
                ItemStack stack = result.m_41777_();
                stack.m_41764_(result.m_41613_() * quantity);
                outputs.add(stack);
            }
            NonNullList fluidResults = ((BasinRecipe)recipe).getFluidResults();
            for (FluidStack fluidResult : fluidResults) {
                FluidStack outputFluidStack = fluidResult.copy();
                outputFluidStack.setAmount(outputFluidStack.getAmount() * quantity);
                if (!DeepFryingRecipe.inputFluidsToBasin(basin, outputFluidStack, false)) continue;
                basin.m_6596_();
                basin.sendData();
            }
        } else {
            ItemStack result = recipe.m_8043_(basin.m_58904_().m_9598_()).m_41777_();
            result.m_41764_(result.m_41613_() * quantity);
            outputs.add(result);
        }
        return outputs;
    }

    public static boolean consumeFluids(FluidIngredient fluidIngredient, IFluidHandler fluidHandler, BasinBlockEntity basin, boolean simulate) {
        int amountRequired = fluidIngredient.getRequiredAmount();
        for (FluidStack matchingFluid : fluidIngredient.getMatchingFluidStacks()) {
            FluidStack fluidToDrain = matchingFluid.copy();
            fluidToDrain.setAmount(amountRequired);
            FluidStack drained = fluidHandler.drain(fluidToDrain, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
            if (drained.isEmpty() || drained.getAmount() != amountRequired || !drained.isFluidStackIdentical(fluidToDrain)) continue;
            if (!simulate) {
                basin.m_6596_();
                basin.sendData();
            }
            return true;
        }
        return false;
    }

    private static boolean inputFluidsToBasin(BasinBlockEntity basin, FluidStack fluidStack, boolean simulate) {
        IFluidHandler basinFluidHandler = (IFluidHandler)basin.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (basinFluidHandler == null) {
            return false;
        }
        int filled = basinFluidHandler.fill(fluidStack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        if (!simulate && filled == fluidStack.getAmount()) {
            basin.m_6596_();
            basin.sendData();
        }
        return filled == fluidStack.getAmount();
    }

    protected DeepFryingRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    public DeepFryingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(RecipeRegistry.DEEP_FRYING, params);
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean m_5818_(Container inv, @Nonnull Level worldIn) {
        if (inv.m_7983_()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.m_8020_(0));
    }

    private static boolean hasMatchingNBT(FluidIngredient fluidIngredient, FluidStack fluidInTank) {
        for (FluidStack matchingFluid : fluidIngredient.getMatchingFluidStacks()) {
            boolean neitherHaveTag;
            boolean bothHaveTag = fluidInTank.hasTag() && matchingFluid.hasTag();
            boolean bl = neitherHaveTag = !fluidInTank.hasTag() && !matchingFluid.hasTag();
            if (!(bothHaveTag ? fluidInTank.getTag().equals((Object)matchingFluid.getTag()) : neitherHaveTag)) continue;
            return true;
        }
        return false;
    }
}

