/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.entity;

import net.brdle.collectorsreap.common.entity.WaterCreature;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class TigerPrawn
extends WaterCreature {
    public final AnimationState swimAnimationState = new AnimationState();
    public final AnimationState drownAnimationState = new AnimationState();

    public TigerPrawn(EntityType<? extends WaterCreature> type, Level level) {
        super(type, level);
        this.f_21342_ = new PrawnMoveControl(this);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22276_, 6.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    @NotNull
    public ItemStack m_28282_() {
        return ((Item)CRItems.TIGER_PRAWN_BUCKET.get()).m_7968_();
    }

    private boolean isMovingInWater() {
        return this.m_20184_().m_165925_() > 1.0E-6 && this.m_20072_();
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            if (this.m_21224_() || this.m_20146_() < this.m_6062_() - 20) {
                this.drownAnimationState.m_216982_(this.f_19797_);
            } else {
                this.drownAnimationState.m_216973_();
                if (this.isMovingInWater()) {
                    this.swimAnimationState.m_216982_(this.f_19797_);
                } else {
                    this.swimAnimationState.m_216973_();
                }
            }
        }
        super.m_8119_();
    }

    public void m_8107_() {
        if (this.m_20069_() && !this.m_20096_()) {
            this.sinkInFluid((FluidType)ForgeMod.WATER_TYPE.get());
        }
        super.m_8107_();
    }

    static class PrawnMoveControl
    extends MoveControl {
        private final TigerPrawn prawn;

        PrawnMoveControl(TigerPrawn prawn) {
            super((Mob)prawn);
            this.prawn = prawn;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.prawn.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.prawn.m_21133_(Attributes.f_22279_));
                this.prawn.m_7910_(Mth.m_14179_((float)0.125f, (float)this.prawn.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.prawn.m_20185_();
                double d1 = this.f_24976_ - this.prawn.m_20186_();
                double d2 = this.f_24977_ - this.prawn.m_20189_();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.prawn.m_20256_(this.prawn.m_20184_().m_82520_(0.0, (double)this.prawn.m_6113_() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.prawn.m_146922_(this.m_24991_(this.prawn.m_146908_(), f1, 90.0f));
                    this.prawn.f_20883_ = this.prawn.m_146908_();
                }
            } else {
                this.prawn.m_7910_(0.0f);
            }
        }
    }
}

