/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import net.brdle.collectorsreap.common.block.FruitBushBlock;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class LimeBushBlock
extends FruitBushBlock {
    public static final VoxelShape SMALL_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0);
    private static final VoxelShape MEDIUM_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0));
    private static final VoxelShape SHAPE_LOWER = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0));
    private static final VoxelShape SHAPE_UPPER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public LimeBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch ((Integer)state.m_61143_((Property)AGE)) {
            case 0 -> SMALL_SHAPE;
            case 1 -> MEDIUM_SHAPE;
            default -> state.m_61138_((Property)f_52858_) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? SHAPE_UPPER : SHAPE_LOWER;
        };
    }

    @Override
    public Item getFruit() {
        return (Item)CRItems.LIME.get();
    }

    @Override
    public Item getSeeds() {
        return (Item)CRItems.LIME_SEEDS.get();
    }

    @Override
    public boolean isSpecial(Level level, BlockPos pos) {
        return false;
    }

    public void m_213898_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (!(((Boolean)CRConfig.LIME_POLLINATION.get()).booleanValue() && age == 3 || age >= 4 || state.m_61143_((Property)f_52858_) != DoubleBlockHalf.LOWER || ((Boolean)state.m_61143_((Property)STUNTED)).booleanValue() || level.m_45524_(pos.m_7494_().m_7494_(), 0) < 9 || !ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(9) == 0 ? 1 : 0) != 0))) {
            this.m_214148_(level, random, pos, state);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7370_(@NotNull LevelReader level, @NotNull BlockPos pos, BlockState state, boolean pIsClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3 || (Boolean)CRConfig.LIME_POLLINATION.get() == false || (Integer)state.m_61143_((Property)AGE) >= 4;
    }

    public void m_7892_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity e) {
        if (!pLevel.m_5776_() && ((Boolean)CRConfig.LIME_POLLINATION.get()).booleanValue() && ((Boolean)CRConfig.FAST_POLLINATE.get()).booleanValue() && e instanceof Bee && (Integer)pState.m_61143_((Property)AGE) == 3 && pLevel.m_213780_().m_188503_(150) == 0) {
            this.m_214148_((ServerLevel)pLevel, pLevel.m_213780_(), pPos, pState);
        }
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        EntityCollisionContext ent;
        if (pContext instanceof EntityCollisionContext && (ent = (EntityCollisionContext)pContext).m_193113_() instanceof Bee && ((Boolean)CRConfig.LIME_POLLINATION.get()).booleanValue()) {
            return pState.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER ? Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0) : Shapes.m_83040_();
        }
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }
}

