/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common;

import java.util.List;
import java.util.Objects;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.CRParticleTypes;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.effect.CREffects;
import net.brdle.collectorsreap.common.entity.BeeGoToFruitBushGoal;
import net.brdle.collectorsreap.common.entity.BeeGrowFruitGoal;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.data.CREntityTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeEvents {
    private static boolean validateVolatile(LivingEntity attacker) {
        Player p;
        return attacker != null && attacker.m_21023_((MobEffect)CREffects.VOLATILITY.get()) && !attacker.m_6095_().m_204039_(CREntityTags.INVOLATILE) && (!(attacker instanceof Player) || (p = (Player)attacker).m_36403_(0.0f) == 1.0f);
    }

    @SubscribeEvent
    public void onBeeJoin(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            bee.m_148772_().m_25352_(3, (Goal)new BeeGrowFruitGoal(bee));
            bee.m_148772_().m_25352_(4, (Goal)new BeeGoToFruitBushGoal(bee));
        }
    }

    @SubscribeEvent
    public void onWanderingTrader(WandererTradesEvent e) {
        if (CRConfig.verify(CRItems.LIME) && CRConfig.verify(CRItems.LIME_SEEDS)) {
            e.getGenericTrades().add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), Util.gs(CRItems.LIME_SEEDS), 5, 1, 1.0f));
        }
        if (CRConfig.verify(CRItems.PORTOBELLO)) {
            e.getGenericTrades().add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_41952_, 4), Util.gs(CRItems.PORTOBELLO), 10, 1, 1.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCorrodeWeapon(LivingDamageEvent e) {
        InteractionHand hand;
        Player p;
        ItemStack stack;
        Entity entity;
        if (e.getEntity().m_21023_((MobEffect)CREffects.CORROSION.get()) && (entity = e.getSource().m_7639_()) instanceof Player && (stack = (p = (Player)entity).m_21120_(hand = p.m_7655_())).m_41763_()) {
            int damage = Objects.requireNonNull(e.getEntity().m_21124_((MobEffect)CREffects.CORROSION.get())).m_19564_();
            stack.m_41622_(damage, (LivingEntity)p, en -> en.m_21190_(hand));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCorrodeProjectile(ProjectileImpactEvent e) {
        LivingEntity victim;
        Entity entity;
        if (e.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)e.getRayTraceResult()).m_82443_()) instanceof LivingEntity && (victim = (LivingEntity)entity).m_21023_((MobEffect)CREffects.CORROSION.get())) {
            Level level;
            Projectile proj = e.getProjectile();
            if (proj.m_6095_().m_204039_(CREntityTags.CORROSION_IMMUNE)) {
                return;
            }
            e.setCanceled(true);
            if (!proj.m_9236_().m_5776_() && (level = proj.m_9236_()) instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                for (int i = 0; i < 3; ++i) {
                    server.m_8767_((ParticleOptions)((SimpleParticleType)CRParticleTypes.ACID.get()), proj.m_20208_(0.3), proj.m_20187_(), proj.m_20262_(0.3), 1, 0.0, 0.0, 0.0, 0.0);
                }
                victim.m_5496_(SoundEvents.f_12374_, 0.4f, 1.1f);
                if (proj instanceof ThrownTrident) {
                    ThrownTrident trident = (ThrownTrident)proj;
                    trident.f_37555_.m_220157_(5 * Objects.requireNonNull(victim.m_21124_((MobEffect)CREffects.CORROSION.get())).m_19564_(), trident.m_9236_().m_213780_(), null);
                } else {
                    proj.m_146870_();
                    proj.m_146850_(GameEvent.f_223707_);
                }
            }
        }
    }

    @SubscribeEvent
    public void onVolatile(LivingDamageEvent e) {
        Level level;
        LivingEntity victim = e.getEntity();
        if (victim instanceof Mob && e.getSource().m_7639_() != null && !victim.m_9236_().m_5776_() && (level = victim.m_9236_()) instanceof ServerLevel) {
            LivingEntity attacker;
            ServerLevel server = (ServerLevel)level;
            if (!victim.m_21023_(MobEffects.f_19606_) && (level = e.getSource().m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)level) != victim && ForgeEvents.validateVolatile(attacker)) {
                server.m_8767_((ParticleOptions)((SimpleParticleType)CRParticleTypes.SHOCKWAVE.get()), victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                int level2 = Objects.requireNonNull(attacker.m_21124_((MobEffect)CREffects.VOLATILITY.get())).m_19564_();
                List mobs = server.m_45971_(Mob.class, TargetingConditions.f_26872_.m_26888_(mob -> {
                    TamableAnimal tame;
                    return mob != attacker && mob != victim && !mob.m_6095_().m_204039_(CREntityTags.VOLATILITY_IMMUNE) && (!(mob instanceof TamableAnimal) || !(tame = (TamableAnimal)mob).m_21824_());
                }), victim, victim.m_20191_().m_82377_(4.0 + (double)level2, 2.0, 4.0 + (double)level2)).stream().limit(3 + level2).toList();
                if (!mobs.isEmpty()) {
                    float hurtAmount = (float)Math.round((e.getAmount() + ((float)level2 + 2.0f) * 0.85f) / (float)(mobs.size() + 1) * 2.0f) / 2.0f;
                    mobs.forEach(mob -> {
                        mob.m_147215_(new MobEffectInstance(MobEffects.f_19606_, 10, 0), null);
                        Vec3 vec32 = mob.m_146892_().m_82546_(victim.m_20182_().m_82520_(0.0, 1.0, 0.0)).m_82541_();
                        mob.m_5496_(SoundEvents.f_12090_, 0.2f, 1.75f);
                        mob.m_6469_(e.getSource(), hurtAmount);
                        double d1 = (1.0 - mob.m_21133_(Attributes.f_22278_)) * 0.75;
                        mob.m_5997_(vec32.m_7096_() * d1, vec32.m_7098_() * d1 * 0.35, vec32.m_7094_() * d1);
                    });
                }
            }
        }
    }
}

