/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.frycooks_delight.data.client;

import com.uraneptus.frycooks_delight.FrycooksDelight;
import com.uraneptus.frycooks_delight.common.blocks.CanolaOilCauldronBlock;
import com.uraneptus.frycooks_delight.core.registry.FCDBlocks;
import com.uraneptus.frycooks_delight.data.FCDDatagenUtil;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class FCDBlockStateProvider
extends BlockStateProvider {
    public FCDBlockStateProvider(PackOutput packOutput, ExistingFileHelper exFileHelper) {
        super(packOutput, "frycooks_delight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.crateBlock((Supplier<? extends Block>)FCDBlocks.CANOLA_CRATE, "canola");
        this.stageCropBlock((Supplier<? extends Block>)FCDBlocks.CANOLA_PLANT);
        this.wildCropBlock((Supplier<? extends Block>)FCDBlocks.WILD_CANOLA);
        this.canolaCauldronBlock((Supplier<? extends Block>)FCDBlocks.CANOLA_OIL_CAULDRON);
        this.basicBlock((Supplier<? extends Block>)FCDBlocks.LARD_BLOCK);
    }

    private void basicBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
        this.simpleBlockItem(block.get(), (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block.get()), this.models().existingFileHelper));
    }

    public void crateBlock(Supplier<? extends Block> block, String cropName) {
        this.simpleBlock(block.get(), (ModelFile)this.models().cubeBottomTop(FCDDatagenUtil.name(block.get()), FCDDatagenUtil.modBlockLocation(cropName + "_crate_side"), FCDDatagenUtil.fdBlockLocation("crate_bottom"), FCDDatagenUtil.modBlockLocation(cropName + "_crate_top")));
        this.simpleBlockItem(block.get(), (ModelFile)new ModelFile.ExistingModelFile(this.blockTexture(block.get()), this.models().existingFileHelper));
    }

    public void stageCropBlock(Supplier<? extends Block> block) {
        this.getVariantBuilder(block.get()).forAllStates(blockstate -> {
            int age = (Integer)blockstate.m_61143_((Property)CropBlock.f_52244_);
            ModelBuilder file = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(FCDDatagenUtil.name((Block)block.get()) + age, FCDDatagenUtil.fdBlockLocation("crop_cross"))).renderType("cutout")).texture("cross", FCDDatagenUtil.modBlockLocation(FCDDatagenUtil.name((Block)block.get()) + age));
            return ConfiguredModel.builder().modelFile((ModelFile)file).build();
        });
    }

    public void wildCropBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(FCDDatagenUtil.name(block.get()), FCDDatagenUtil.modBlockLocation(FCDDatagenUtil.name(block.get())))).renderType("cutout"));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(FCDDatagenUtil.name(block.get()))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", FCDDatagenUtil.modBlockLocation(FCDDatagenUtil.name(block.get())));
    }

    public void canolaCauldronBlock(Supplier<? extends Block> block) {
        this.getVariantBuilder(block.get()).forAllStates(blockState -> {
            int level = (Integer)blockState.m_61143_((Property)CanolaOilCauldronBlock.f_153514_);
            int oil_stage = (Integer)blockState.m_61143_((Property)CanolaOilCauldronBlock.OIL_STAGE);
            String levelSuffix = switch (level) {
                case 1 -> "_level1";
                case 2 -> "_level2";
                case 3 -> "_full";
                default -> "";
            };
            ResourceLocation templateLoc = level == 3 ? FCDDatagenUtil.modBlockLocation("fcd_template_cauldron_full") : FCDDatagenUtil.vanillaBlockLocation("template_cauldron" + levelSuffix);
            String oilStageSuffix = "_oil_stage_" + oil_stage;
            String modelName = FCDDatagenUtil.name((Block)block.get()) + oilStageSuffix + levelSuffix;
            ResourceLocation cauldronLoc = FCDDatagenUtil.vanillaBlockLocation(FCDDatagenUtil.name(Blocks.f_50256_));
            ResourceLocation contentTexture = oil_stage == 9 ? FCDDatagenUtil.modBlockLocation("lard_block") : FCDDatagenUtil.modBlockLocation("canola_oil" + oil_stage);
            ModelBuilder file = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, templateLoc)).texture("bottom", cauldronLoc + "_bottom")).texture("content", contentTexture)).texture("inside", cauldronLoc + "_inner")).texture("particle", cauldronLoc + "_side")).texture("side", cauldronLoc + "_side")).texture("top", cauldronLoc + "_top");
            return ConfiguredModel.builder().modelFile((ModelFile)file).build();
        });
        this.simpleBlockItem(block.get(), (ModelFile)new ModelFile.ExistingModelFile(FrycooksDelight.modPrefix("block/" + ForgeRegistries.BLOCKS.getKey((Object)block.get()).m_135815_() + "_oil_stage_1_full"), this.models().existingFileHelper));
    }
}

