/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.frycooks_delight.data;

import com.uraneptus.frycooks_delight.FrycooksDelight;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.registries.ForgeRegistries;

public class FCDDatagenUtil {
    public static final String LAYER0 = "layer0";
    public static final String PLANT = "plant";
    public static final String ENTITY = "builtin/entity";
    public static final ResourceLocation POTTED_CROSS = FCDDatagenUtil.vanillaBlockLocation("flower_pot_cross");
    public static final ResourceLocation GENERATED = FCDDatagenUtil.vanillaItemLocation("generated");
    public static final ResourceLocation HANDHELD = FCDDatagenUtil.vanillaItemLocation("handheld");
    public static final ResourceLocation SPAWN_EGG = FCDDatagenUtil.vanillaItemLocation("template_spawn_egg");

    @SafeVarargs
    public static HolderSet<PlacedFeature> getPlacedHolderSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... placedFeatures) {
        ObjectArrayList holders = new ObjectArrayList();
        for (ResourceKey<PlacedFeature> feature : placedFeatures) {
            holders.add(context.m_255420_(Registries.f_256988_).m_255043_(feature));
        }
        return HolderSet.m_205800_((List)holders);
    }

    public static String name(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public static String name(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    public static ResourceLocation modBlockLocation(String path) {
        return FrycooksDelight.modPrefix("block/" + path);
    }

    public static ResourceLocation modItemLocation(String path) {
        return FrycooksDelight.modPrefix("item/" + path);
    }

    public static ResourceLocation vanillaBlockLocation(String path) {
        return new ResourceLocation("block/" + path);
    }

    public static ResourceLocation vanillaItemLocation(String path) {
        return new ResourceLocation("item/" + path);
    }

    public static ResourceLocation fdBlockLocation(String path) {
        return new ResourceLocation("farmersdelight", "block/" + path);
    }

    public static ResourceLocation craftingPath(String name) {
        return FrycooksDelight.modPrefix("crafting/" + name);
    }

    public static ResourceLocation smeltingPath(String name) {
        return FrycooksDelight.modPrefix("smelting/" + name);
    }

    public static ResourceLocation blastingPath(String name) {
        return FrycooksDelight.modPrefix("blasting/" + name);
    }

    public static ResourceLocation smokingPath(String name) {
        return FrycooksDelight.modPrefix("smoking/" + name);
    }

    public static ResourceLocation campfire_cookingPath(String name) {
        return FrycooksDelight.modPrefix("campfire_cooking/" + name);
    }

    public static ResourceLocation stonecuttingPath(String name) {
        return FrycooksDelight.modPrefix("stonecutting/" + name);
    }

    public static ResourceLocation smithingPath(String name) {
        return FrycooksDelight.modPrefix("smithing/" + name);
    }
}

