/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.frycooks_delight.common.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.uraneptus.frycooks_delight.FrycooksDelight;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class HotGreaseFluidType
extends FluidType {
    private static final ResourceLocation UNDERWATER_LOCATION = FrycooksDelight.modPrefix("textures/misc/hot_grease_inside.png");
    private static final ResourceLocation STILL = new ResourceLocation("block/water_still");
    private static final ResourceLocation FLOW = new ResourceLocation("block/water_flow");
    private static final ResourceLocation OVERLAY = new ResourceLocation("block/water_overlay");

    public HotGreaseFluidType() {
        super(FluidType.Properties.create().canSwim(false).canDrown(false).density(3000).viscosity(6000).temperature(9000).motionScale(2.33E-4).pathType(BlockPathTypes.LAVA).adjacentPathType(null));
    }

    public void setItemMovement(ItemEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOW;
            }

            public ResourceLocation getOverlayTexture() {
                return OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return UNDERWATER_LOCATION;
            }

            public int getTintColor() {
                return -10928853;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.35f, 0.24f, 0.17f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)0.5f);
                RenderSystem.setShaderFogEnd((float)1.0f);
            }
        });
    }
}

