/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.frycooks_delight.common.blocks;

import com.uraneptus.frycooks_delight.client.OilBubbleOptions;
import com.uraneptus.frycooks_delight.common.recipe.FryingRecipe;
import com.uraneptus.frycooks_delight.core.other.FCDCriteriaTriggers;
import com.uraneptus.frycooks_delight.core.other.tags.FCDBlockTags;
import com.uraneptus.frycooks_delight.core.other.tags.FCDItemTags;
import com.uraneptus.frycooks_delight.core.registry.FCDBlocks;
import com.uraneptus.frycooks_delight.core.registry.FCDDamageTypes;
import com.uraneptus.frycooks_delight.core.registry.FCDItems;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CanolaOilCauldronBlock
extends LayeredCauldronBlock
implements WorldlyContainerHolder {
    public static final IntegerProperty OIL_STAGE = IntegerProperty.m_61631_((String)"oil_stage", (int)1, (int)9);
    private final Predicate<BlockState> HEATING_BLOCKS = blockstate -> {
        CampfireBlock campfireBlock;
        Block patt2429$temp;
        return blockstate.m_204336_(FCDBlockTags.FRY_HEAT_SOURCES) || (patt2429$temp = blockstate.m_60734_()) instanceof CampfireBlock && (Boolean)(campfireBlock = (CampfireBlock)patt2429$temp).m_49966_().m_61143_((Property)CampfireBlock.f_51227_) != false;
    };

    public CanolaOilCauldronBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, precipitation -> precipitation == Biome.Precipitation.NONE, null);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)OIL_STAGE, (Comparable)Integer.valueOf(1)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_(Items.f_42590_)) {
            if ((Integer)pState.m_61143_((Property)OIL_STAGE) < 8) {
                int currentLevel = (Integer)pState.m_61143_((Property)f_153514_);
                if (currentLevel > 1) {
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)f_153514_, (Comparable)Integer.valueOf(currentLevel - 1)), 3);
                    CanolaOilCauldronBlock.fillOilBottle(pPlayer, itemstack);
                    return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
                }
                if (currentLevel == 1) {
                    pLevel.m_7731_(pPos, Blocks.f_50256_.m_49966_(), 3);
                    CanolaOilCauldronBlock.fillOilBottle(pPlayer, itemstack);
                    return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
                }
            } else if (!pPlayer.m_150110_().f_35937_) {
                pPlayer.m_6469_(pLevel.m_269111_().m_269079_(FCDDamageTypes.FRYING), 1.0f);
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.m_150930_(Items.f_42446_)) {
            if ((Integer)pState.m_61143_((Property)OIL_STAGE) == 8) {
                itemstack.m_41774_(1);
                pPlayer.m_36356_(((Item)FCDItems.HOT_GREASE_BUCKET.get()).m_7968_());
                pLevel.m_7731_(pPos, Blocks.f_50256_.m_49966_(), 3);
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
        } else if (itemstack.m_41619_() && (Integer)pState.m_61143_((Property)OIL_STAGE) == 9) {
            pPlayer.m_36356_(((Block)FCDBlocks.LARD_BLOCK.get()).m_5456_().m_7968_());
            pLevel.m_7731_(pPos, Blocks.f_50256_.m_49966_(), 3);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)pState));
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static void fillOilBottle(Player player, ItemStack itemStack) {
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
            player.m_36356_(((Item)FCDItems.CANOLA_OIL.get()).m_7968_());
        }
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_6674_(player.m_7655_());
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this.isBoiling(pState, pLevel, pPos) && (Integer)pState.m_61143_((Property)OIL_STAGE) <= 8) {
            int color = (Integer)pState.m_61143_((Property)OIL_STAGE) < 8 ? 12955730 : 5848363;
            for (int i = 0; i < 2; ++i) {
                double xPos = (double)pPos.m_123341_() + 0.125 + 0.75 * (double)pRandom.m_188501_();
                double yPos = (float)pPos.m_123342_() + 0.9375f;
                double zPos = (double)pPos.m_123343_() + 0.125 + 0.75 * (double)pRandom.m_188501_();
                pLevel.m_7106_((ParticleOptions)new OilBubbleOptions(Vec3.m_82501_((int)color).m_252839_()), xPos, yPos, zPos, 0.0, 0.02, 0.0);
            }
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pos, RandomSource random) {
        if ((Integer)pState.m_61143_((Property)OIL_STAGE) < 8) {
            if (this.isBoiling(pState, (Level)pLevel, pos) && random.m_188503_(10) == 0) {
                BlockState state = (BlockState)pState.m_61124_((Property)OIL_STAGE, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)OIL_STAGE) + 1));
                pLevel.m_7731_(pos, state, 3);
            }
        } else if ((Integer)pState.m_61143_((Property)OIL_STAGE) == 8 && !this.HEATING_BLOCKS.test(pLevel.m_8055_(pos.m_7495_())) && !pLevel.m_6042_().f_63857_()) {
            BlockState state = (BlockState)pState.m_61124_((Property)OIL_STAGE, (Comparable)Integer.valueOf(9));
            pLevel.m_7731_(pos, state, 3);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (this.isBoiling(pState, pLevel, pPos)) {
            if (pEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)pEntity;
                ItemStack itemstack = itemEntity.m_32055_();
                int count = itemstack.m_41613_();
                if (itemstack.m_204117_(FCDItemTags.OIL_DESTROYS) || itemstack.m_41720_() instanceof BannerPatternItem) {
                    itemEntity.m_146870_();
                    pLevel.m_5594_(null, pPos, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.randomStageIncrease(itemstack, pLevel, pState, pPos);
                }
                if (itemstack.m_204117_(FCDItemTags.CAUSE_OIL_OVERFLOW)) {
                    pLevel.m_7731_(pPos.m_7494_(), ((LiquidBlock)FCDBlocks.HOT_GREASE.get()).m_49966_(), 3);
                    pLevel.m_7731_(pPos, Blocks.f_50256_.m_49966_(), 3);
                    pLevel.m_5594_(null, pPos, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    Entity entity = itemEntity.m_19749_();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        FCDCriteriaTriggers.FRYING_ICE.trigger(serverPlayer);
                    }
                    itemEntity.m_146870_();
                }
                if ((Integer)pState.m_61143_((Property)OIL_STAGE) == 8 && !itemstack.m_204117_(FCDItemTags.OIL_DESTROYS) && (itemstack.m_41614_() || itemstack.m_204117_(FCDItemTags.BURNS_TO_MORSEL) || itemstack.m_41720_() instanceof SpawnEggItem)) {
                    ItemStack burntNugget = ((Item)FCDItems.BURNT_MORSEL.get()).m_7968_();
                    burntNugget.m_41764_(itemEntity.m_32055_().m_41613_());
                    itemEntity.m_146870_();
                    CanolaOilCauldronBlock.finishFrying(burntNugget, pLevel, pPos, 1.0f);
                    this.randomStageIncrease(burntNugget, pLevel, pState, pPos);
                }
                if ((Integer)pState.m_61143_((Property)OIL_STAGE) < 8) {
                    boolean recipeFlag = false;
                    ArrayList<FryingRecipe> recipes = new ArrayList<FryingRecipe>(FryingRecipe.getRecipes(pLevel));
                    for (FryingRecipe recipe : recipes) {
                        for (ItemStack ingredient : ((Ingredient)recipe.m_7527_().iterator().next()).m_43908_()) {
                            if (!itemstack.m_150930_(ingredient.m_41720_())) continue;
                            recipeFlag = true;
                            for (ItemStack stack : recipe.getResults()) {
                                itemEntity.m_146870_();
                                int resultCount = count * stack.m_41613_();
                                CanolaOilCauldronBlock.finishFrying(stack.m_255036_(resultCount), pLevel, pPos, 1.0f);
                                this.randomStageIncrease(stack.m_255036_(resultCount), pLevel, pState, pPos);
                            }
                        }
                    }
                    if (!recipeFlag && (itemstack.m_41614_() || itemstack.m_204117_(FCDItemTags.BURNS_TO_MORSEL) || itemstack.m_41720_() instanceof SpawnEggItem)) {
                        if (itemstack.m_204117_(FCDItemTags.IS_FRIED)) {
                            result = itemstack.m_255036_(itemstack.m_41613_());
                            itemEntity.m_146870_();
                            CanolaOilCauldronBlock.finishFrying(result, pLevel, pPos, 0.5f);
                        } else {
                            result = ((Item)FCDItems.BURNT_MORSEL.get()).m_7968_();
                            result.m_41764_(itemEntity.m_32055_().m_41613_());
                            itemEntity.m_146870_();
                            CanolaOilCauldronBlock.finishFrying(result, pLevel, pPos, 1.0f);
                            this.randomStageIncrease(result, pLevel, pState, pPos);
                        }
                    }
                }
            } else if (pEntity instanceof LivingEntity) {
                pEntity.m_6469_(pLevel.m_269111_().m_269079_(FCDDamageTypes.FRYING), 2.0f);
            }
        }
    }

    public static void finishFrying(ItemStack resultItem, Level pLevel, BlockPos pPos, float volume) {
        pLevel.m_7967_((Entity)new ItemEntity(pLevel, (double)pPos.m_123341_() + 0.5, (double)((float)pPos.m_123342_() + 1.5f), (double)pPos.m_123343_() + 0.5, resultItem));
        pLevel.m_5594_(null, pPos, SoundEvents.f_12031_, SoundSource.BLOCKS, volume, 1.0f);
    }

    public void randomStageIncrease(ItemStack itemStack, Level pLevel, BlockState pState, BlockPos pPos) {
        int itemCount = itemStack.m_41613_();
        for (int i = 0; i < itemCount; ++i) {
            if (pLevel.f_46441_.m_188503_(10) != 0 || (Integer)pState.m_61143_((Property)OIL_STAGE) >= 8) continue;
            BlockState nextStage = (BlockState)pState.m_61124_((Property)OIL_STAGE, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)OIL_STAGE) + 1));
            pLevel.m_7731_(pPos, nextStage, 3);
        }
    }

    public boolean isBoiling(BlockState state, Level pLevel, BlockPos pPos) {
        return this.HEATING_BLOCKS.test(pLevel.m_8055_(pPos.m_7495_())) && (Integer)state.m_61143_((Property)f_153514_) == 3;
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)Items.f_42544_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OIL_STAGE});
    }

    public WorldlyContainer m_5840_(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        if ((Integer)pState.m_61143_((Property)OIL_STAGE) == 9) {
            return new OutputContainer(pState, pLevel, pPos);
        }
        return new EmptyContainer();
    }

    static class OutputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public OutputContainer(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
            super(new ItemStack[]{((Block)FCDBlocks.LARD_BLOCK.get()).m_5456_().m_7968_()});
            this.state = pState;
            this.level = pLevel;
            this.pos = pPos;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction pSide) {
            int[] nArray;
            if (pSide == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
            return false;
        }

        public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
            return !this.changed && pDirection == Direction.DOWN && pStack.m_150930_(((Block)FCDBlocks.LARD_BLOCK.get()).m_5456_());
        }

        public void m_6596_() {
            this.level.m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
            this.level.m_220407_(GameEvent.f_157792_, this.pos, GameEvent.Context.m_223719_(null, (BlockState)this.state));
            this.changed = true;
        }
    }

    static class EmptyContainer
    extends SimpleContainer
    implements WorldlyContainer {
        public EmptyContainer() {
            super(0);
        }

        public int[] m_7071_(Direction pSide) {
            return new int[0];
        }

        public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
            return false;
        }

        public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
            return false;
        }
    }
}

