/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.network.message;

import com.github.tartaricacid.netmusic.inventory.CDBurnerMenu;
import com.github.tartaricacid.netmusic.inventory.ComputerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class SetMusicIDMessage {
    private final ItemMusicCD.SongInfo song;

    public SetMusicIDMessage(ItemMusicCD.SongInfo song) {
        this.song = song;
    }

    public static SetMusicIDMessage decode(FriendlyByteBuf buf) {
        CompoundTag tag = buf.m_130260_();
        ItemMusicCD.SongInfo songData = ItemMusicCD.SongInfo.deserializeNBT(tag);
        return new SetMusicIDMessage(songData);
    }

    public static void encode(SetMusicIDMessage message, FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        ItemMusicCD.SongInfo.serializeNBT(message.song, tag);
        buf.m_130079_(tag);
    }

    public static void handle(SetMusicIDMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                AbstractContainerMenu patt1559$temp = sender.f_36096_;
                if (patt1559$temp instanceof CDBurnerMenu) {
                    CDBurnerMenu menu = (CDBurnerMenu)patt1559$temp;
                    menu.setSongInfo(message.song);
                    return;
                }
                AbstractContainerMenu patt1730$temp = sender.f_36096_;
                if (patt1730$temp instanceof ComputerMenu) {
                    ComputerMenu menu = (ComputerMenu)patt1730$temp;
                    menu.setSongInfo(message.song);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

