/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.backpack.data;

import com.github.tartaricacid.netmusic.compat.tlm.message.MaidMusicToClientMessage;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MusicPlayerBackpackData
implements IBackpackData {
    private int selectSlotId = 0;
    private int playTick = 0;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return MusicPlayerBackpackData.this.selectSlotId;
            }
            if (index == 1) {
                return MusicPlayerBackpackData.this.playTick;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                MusicPlayerBackpackData.this.selectSlotId = value;
            }
            if (index == 1) {
                MusicPlayerBackpackData.this.playTick = value;
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    public void load(CompoundTag compoundTag, EntityMaid entityMaid) {
        if (compoundTag.m_128425_("MusicPlayerSelectSlotId", 3)) {
            this.selectSlotId = compoundTag.m_128451_("MusicPlayerSelectSlotId");
        }
    }

    public void save(CompoundTag compoundTag, EntityMaid entityMaid) {
        compoundTag.m_128405_("MusicPlayerSelectSlotId", this.selectSlotId);
    }

    public void serverTick(EntityMaid entityMaid) {
        if (this.playTick > 0) {
            --this.playTick;
            if (this.playTick == 0) {
                this.playNextSong(entityMaid);
            }
        }
    }

    private void playNextSong(EntityMaid entityMaid) {
        int i;
        CombinedInvWrapper availableInv = entityMaid.getAvailableInv(false);
        int startSlot = this.selectSlotId + 6 + 1;
        int stopSlot = 30;
        for (i = startSlot; i < stopSlot; ++i) {
            if (!this.playMusic(entityMaid, availableInv, i)) continue;
            return;
        }
        for (i = 6; i <= startSlot; ++i) {
            if (!this.playMusic(entityMaid, availableInv, i)) continue;
            return;
        }
        this.selectSlotId = 0;
        this.playTick = 0;
    }

    private boolean playMusic(EntityMaid entityMaid, CombinedInvWrapper availableInv, int slotId) {
        ItemStack stackInSlot = availableInv.getStackInSlot(slotId);
        if (stackInSlot.m_150930_((Item)InitItems.MUSIC_CD.get())) {
            ItemMusicCD.SongInfo info = ItemMusicCD.getSongInfo(stackInSlot);
            if (info == null) {
                return false;
            }
            this.selectSlotId = slotId - 6;
            this.playTick = info.songTime * 20 + 64;
            MaidMusicToClientMessage msg = new MaidMusicToClientMessage(entityMaid.m_19879_(), info.songUrl, info.songTime, info.songName);
            MaidMusicToClientMessage.showLyric(entityMaid, info.songUrl, info.songName, info.songTime);
            NetworkHandler.sendToNearby(entityMaid.m_9236_(), entityMaid.m_20183_(), msg);
            return true;
        }
        return false;
    }
}

