/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.renderer;

import com.github.tartaricacid.netmusic.api.lyric.LyricRecord;
import com.github.tartaricacid.netmusic.client.model.ModelMusicPlayer;
import com.github.tartaricacid.netmusic.config.GeneralConfig;
import com.github.tartaricacid.netmusic.tileentity.TileEntityMusicPlayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.StringUtils;

public class MusicPlayerRenderer
implements BlockEntityRenderer<TileEntityMusicPlayer> {
    public static ModelMusicPlayer<?> MODEL;
    public static final ResourceLocation TEXTURE;
    public static MusicPlayerRenderer instance;
    private final Font font;
    private final BlockEntityRenderDispatcher dispatcher;

    public MusicPlayerRenderer(BlockEntityRendererProvider.Context context) {
        MODEL = new ModelMusicPlayer(context.m_173582_(ModelMusicPlayer.LAYER));
        instance = this;
        this.font = context.m_173586_();
        this.dispatcher = context.m_173581_();
    }

    public void render(TileEntityMusicPlayer te, float pPartialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction facing = (Direction)te.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        ItemStack cd = te.getPlayerInv().getStackInSlot(0);
        ModelPart disc = MODEL.getDiscBone();
        boolean bl = disc.f_104207_ = !cd.m_41619_();
        if (!cd.m_41619_() && te.isPlay()) {
            disc.f_104204_ = (float)(0.15707963267948966 * ((double)System.currentTimeMillis() / 50.0 % 40.0));
        }
        this.renderMusicPlayer(matrixStack, buffer, combinedLight, facing);
        this.renderLyric(te, matrixStack, buffer, combinedLight);
    }

    public void renderMusicPlayer(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, Direction facing) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
        matrixStack.m_85837_(0.6666666666666666, 1.5, 0.6666666666666666);
        switch (facing) {
            case SOUTH: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case EAST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case WEST: {
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
        }
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        MODEL.m_7695_(matrixStack, vertexBuilder, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    private void renderLyric(TileEntityMusicPlayer te, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        if (!((Boolean)GeneralConfig.ENABLE_PLAYER_LYRICS.get()).booleanValue()) {
            return;
        }
        LyricRecord lyricRecord = te.lyricRecord;
        if (lyricRecord == null) {
            return;
        }
        Int2ObjectSortedMap<String> lyrics = lyricRecord.getLyrics();
        if (lyrics == null || lyrics.isEmpty()) {
            return;
        }
        if (!te.isPlay()) {
            te.lyricRecord = null;
            return;
        }
        Camera camera = this.dispatcher.f_112249_;
        ChatFormatting currentLyricColor = ChatFormatting.GRAY;
        ChatFormatting transLyricColor = ChatFormatting.WHITE;
        float y = 0.5f;
        String lyric = (String)lyrics.get(lyrics.firstIntKey());
        MutableComponent currentLine = StringUtils.isNotBlank((CharSequence)lyric) ? Component.m_237113_((String)lyric) : Component.m_237119_();
        MutableComponent translatedLine = null;
        Int2ObjectSortedMap<String> transLyrics = lyricRecord.getTransLyrics();
        if (transLyrics != null && !transLyrics.isEmpty()) {
            String transLyric = (String)transLyrics.get(transLyrics.firstIntKey());
            if (StringUtils.isNotBlank((CharSequence)transLyric)) {
                translatedLine = Component.m_237113_((String)transLyric);
            }
            y += 0.5f;
        } else {
            currentLyricColor = ChatFormatting.WHITE;
        }
        currentLine = currentLine.m_130940_(currentLyricColor);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.625, 0.5);
        poseStack.m_252781_(camera.m_253121_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        float opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int bgColor = (int)(opacity * 255.0f) << 24;
        if (!currentLine.m_214077_().equals(ComponentContents.f_237124_)) {
            float currentLineWidth = -this.font.m_92852_((FormattedText)currentLine) / 2;
            this.font.m_272077_((Component)currentLine, currentLineWidth, -y, -1, false, poseStack.m_85850_().m_252922_(), bufferIn, Font.DisplayMode.NORMAL, bgColor, combinedLightIn);
        }
        if (translatedLine != null) {
            float translatedLineWidth = -this.font.m_92852_((FormattedText)translatedLine) / 2;
            translatedLine = translatedLine.m_130940_(transLyricColor);
            this.font.m_272077_((Component)translatedLine, translatedLineWidth, -y - 12.0f, -1, false, poseStack.m_85850_().m_252922_(), bufferIn, Font.DisplayMode.NORMAL, bgColor, combinedLightIn);
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(TileEntityMusicPlayer musicPlayer) {
        return true;
    }

    static {
        TEXTURE = new ResourceLocation("netmusic", "textures/block/music_player.png");
    }
}

