/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.gui;

import com.github.tartaricacid.netmusic.client.config.MusicListManage;
import com.github.tartaricacid.netmusic.inventory.CDBurnerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.SetMusicIDMessage;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.apache.commons.lang3.StringUtils;

@IPNIgnore
public class CDBurnerMenuScreen
extends AbstractContainerScreen<CDBurnerMenu> {
    private static final ResourceLocation BG = new ResourceLocation("netmusic", "textures/gui/cd_burner.png");
    private static final Pattern ID_REG = Pattern.compile("^\\d{4,}$");
    private static final Pattern DJ_ID_REG = Pattern.compile("^dj/(\\d+)$");
    private static final Pattern URL_1_REG = Pattern.compile("^https://music\\.163\\.com/song\\?id=(\\d+).*$");
    private static final Pattern URL_2_REG = Pattern.compile("^https://music\\.163\\.com/#/song\\?id=(\\d+).*$");
    private static final Pattern DJ_URL_1_REG = Pattern.compile("^https://music\\.163\\.com/dj\\?id=(\\d+).*$");
    private static final Pattern DJ_URL_2_REG = Pattern.compile("^https://music\\.163\\.com/#/dj\\?id=(\\d+).*$");
    private EditBox textField;
    private Checkbox readOnlyButton;
    private Component tips = Component.m_237119_();

    public CDBurnerMenuScreen(CDBurnerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97727_ = 176;
    }

    protected void m_7856_() {
        super.m_7856_();
        String perText = "";
        boolean focus = false;
        if (this.textField != null) {
            perText = this.textField.m_94155_();
            focus = this.textField.m_93696_();
        }
        this.textField = new EditBox(this.getMinecraft().f_91062_, this.f_97735_ + 12, this.f_97736_ + 18, 132, 16, (Component)Component.m_237113_((String)"Music ID Box")){

            public void m_94164_(String text) {
                Matcher matcher1 = URL_1_REG.matcher(text);
                if (matcher1.find()) {
                    String group = matcher1.group(1);
                    super.m_94164_(group);
                    return;
                }
                Matcher matcher2 = URL_2_REG.matcher(text);
                if (matcher2.find()) {
                    String group = matcher2.group(1);
                    super.m_94164_(group);
                    return;
                }
                Matcher matcher3 = DJ_URL_1_REG.matcher(text);
                if (matcher3.find()) {
                    String group = matcher3.group(1);
                    super.m_94164_("dj/" + group);
                    return;
                }
                Matcher matcher4 = DJ_URL_2_REG.matcher(text);
                if (matcher4.find()) {
                    String group = matcher4.group(1);
                    super.m_94164_("dj/" + group);
                    return;
                }
                super.m_94164_(text);
            }
        };
        this.textField.m_94144_(perText);
        this.textField.m_94182_(false);
        this.textField.m_94199_(19);
        this.textField.m_94202_(15986656);
        this.textField.m_93692_(focus);
        this.textField.m_94201_();
        this.m_7787_((GuiEventListener)this.textField);
        this.readOnlyButton = new Checkbox(this.f_97735_ + 66, this.f_97736_ + 34, 80, 20, (Component)Component.m_237115_((String)"gui.netmusic.cd_burner.read_only"), false);
        this.m_142416_((GuiEventListener)this.readOnlyButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.netmusic.cd_burner.craft"), b -> this.handleCraftButton()).m_252794_(this.f_97735_ + 7, this.f_97736_ + 35).m_253046_(55, 18).m_253136_());
    }

    private void handleCraftButton() {
        ItemStack cd = ((CDBurnerMenu)this.m_6262_()).getInput().getStackInSlot(0);
        if (cd.m_41619_()) {
            this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.cd_is_empty");
            return;
        }
        ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(cd);
        if (songInfo != null && songInfo.readOnly) {
            this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.cd_read_only");
            return;
        }
        if (Util.m_288217_((String)this.textField.m_94155_())) {
            this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.no_music_id");
            return;
        }
        Matcher djMatcher = DJ_ID_REG.matcher(this.textField.m_94155_());
        if (djMatcher.find()) {
            long djId = Long.parseLong(djMatcher.group(1));
            try {
                ItemMusicCD.SongInfo djSong = MusicListManage.getDjSong(djId);
                if (StringUtils.isBlank((CharSequence)djSong.songUrl) || StringUtils.isBlank((CharSequence)djSong.songName)) {
                    this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.get_info_error");
                    return;
                }
                djSong.readOnly = this.readOnlyButton.m_93840_();
                NetworkHandler.CHANNEL.sendToServer((Object)new SetMusicIDMessage(djSong));
                return;
            }
            catch (Exception e) {
                this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.get_info_error");
                e.printStackTrace();
                return;
            }
        }
        if (ID_REG.matcher(this.textField.m_94155_()).matches()) {
            long id = Long.parseLong(this.textField.m_94155_());
            try {
                ItemMusicCD.SongInfo song = MusicListManage.get163Song(id);
                if (StringUtils.isBlank((CharSequence)song.songUrl) || StringUtils.isBlank((CharSequence)song.songName)) {
                    this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.get_info_error");
                    return;
                }
                song.readOnly = this.readOnlyButton.m_93840_();
                NetworkHandler.CHANNEL.sendToServer((Object)new SetMusicIDMessage(song));
            }
            catch (Exception e) {
                this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.get_info_error");
                e.printStackTrace();
            }
        } else {
            this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.music_id_error");
        }
    }

    protected void m_280003_(GuiGraphics graphics, int x, int y) {
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        int posX = this.f_97735_;
        int posY = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(BG, posX, posY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.m_88315_(graphics, x, y, partialTicks);
        this.textField.m_88315_(graphics, x, y, partialTicks);
        if (Util.m_288217_((String)this.textField.m_94155_()) && !this.textField.m_93696_()) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.netmusic.cd_burner.id.tips").m_130940_(ChatFormatting.ITALIC), this.f_97735_ + 12, this.f_97736_ + 18, ChatFormatting.GRAY.m_126665_().intValue(), false);
        }
        graphics.m_280554_(this.f_96547_, (FormattedText)this.tips, this.f_97735_ + 8, this.f_97736_ + 57, 135, 0xCF0000);
        this.m_280072_(graphics, x, y);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String value = this.textField.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.textField.m_94144_(value);
    }

    protected void m_181908_() {
        this.textField.m_94120_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.textField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.textField);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.textField.m_93696_()) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_6697_(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.m_94144_(text);
        } else {
            this.textField.m_94164_(text);
        }
    }
}

