/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.block;

import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.tileentity.TileEntityMusicPlayer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.items.ItemStackHandler;

public class BlockMusicPlayer
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected static final VoxelShape BLOCK_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    public static final BooleanProperty CYCLE_DISABLE = BooleanProperty.m_61465_((String)"cycle_disable");

    public BlockMusicPlayer() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60978_(0.5f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.SOUTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityMusicPlayer(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, CYCLE_DISABLE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)CYCLE_DISABLE, (Comparable)Boolean.valueOf(true));
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos blockPos) {
        TileEntityMusicPlayer te;
        ItemStack stackInSlot;
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof TileEntityMusicPlayer && !(stackInSlot = (te = (TileEntityMusicPlayer)blockEntity).getPlayerInv().getStackInSlot(0)).m_41619_()) {
            if (te.isPlay()) {
                return 15;
            }
            return 7;
        }
        return 0;
    }

    public void m_6861_(BlockState state, Level level, BlockPos blockPos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockMusicPlayer.playerMusic(level, blockPos, level.m_276867_(blockPos));
    }

    private static void playerMusic(Level level, BlockPos blockPos, boolean signal) {
        TileEntityMusicPlayer player;
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof TileEntityMusicPlayer && signal != (player = (TileEntityMusicPlayer)blockEntity).hasSignal()) {
            if (signal) {
                if (player.isPlay()) {
                    player.setPlay(false);
                    player.setSignal(signal);
                    player.markDirty();
                    return;
                }
                ItemStack stackInSlot = player.getPlayerInv().getStackInSlot(0);
                if (stackInSlot.m_41619_()) {
                    player.setSignal(signal);
                    player.markDirty();
                    return;
                }
                ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(stackInSlot);
                if (songInfo != null) {
                    player.setPlayToClient(songInfo);
                }
            }
            player.setSignal(signal);
            player.markDirty();
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        BlockEntity te = worldIn.m_7702_(pos);
        if (!(te instanceof TileEntityMusicPlayer)) {
            return InteractionResult.PASS;
        }
        TileEntityMusicPlayer musicPlayer = (TileEntityMusicPlayer)te;
        ItemStackHandler handler = musicPlayer.getPlayerInv();
        if (!handler.getStackInSlot(0).m_41619_()) {
            ItemStack extract = handler.extractItem(0, 1, false);
            BlockMusicPlayer.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)extract);
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = playerIn.m_21205_();
        ItemMusicCD.SongInfo info = ItemMusicCD.getSongInfo(stack);
        if (info == null) {
            return InteractionResult.PASS;
        }
        if (info.vip) {
            if (worldIn.f_46443_) {
                playerIn.m_213846_((Component)Component.m_237115_((String)"message.netmusic.music_player.need_vip").m_130940_(ChatFormatting.RED));
            }
            return InteractionResult.FAIL;
        }
        handler.insertItem(0, stack.m_41777_(), false);
        if (!playerIn.m_7500_()) {
            stack.m_41774_(1);
        }
        musicPlayer.setPlayToClient(info);
        musicPlayer.markDirty();
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityMusicPlayer musicPlayer;
        ItemStack stack;
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof TileEntityMusicPlayer && !(stack = (musicPlayer = (TileEntityMusicPlayer)te).getPlayerInv().getStackInSlot(0)).m_41619_()) {
            Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> entityType) {
        return !level.f_46443_ ? BlockMusicPlayer.createTickerHelper(entityType, TileEntityMusicPlayer.TYPE, TileEntityMusicPlayer::tick) : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> entityType, BlockEntityType<E> type, BlockEntityTicker<? super E> ticker) {
        return type == entityType ? ticker : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BLOCK_AABB;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
                if (target instanceof BlockHitResult) {
                    BlockHitResult blockTarget = (BlockHitResult)target;
                    if (world instanceof ClientLevel) {
                        ClientLevel clientWorld = (ClientLevel)world;
                        BlockPos pos = blockTarget.m_82425_();
                        this.crack(clientWorld, pos, Blocks.f_50015_.m_49966_(), blockTarget.m_82434_());
                    }
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
                Minecraft.m_91087_().f_91061_.m_107355_(pos, Blocks.f_50015_.m_49966_());
                return true;
            }

            @OnlyIn(value=Dist.CLIENT)
            private void crack(ClientLevel world, BlockPos pos, BlockState state, Direction side) {
                if (state.m_60799_() != RenderShape.INVISIBLE) {
                    int posX = pos.m_123341_();
                    int posY = pos.m_123342_();
                    int posZ = pos.m_123343_();
                    AABB aabb = state.m_60808_((BlockGetter)world, pos).m_83215_();
                    double x = (double)posX + world.f_46441_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - 0.2) + 0.1 + aabb.f_82288_;
                    double y = (double)posY + world.f_46441_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - 0.2) + 0.1 + aabb.f_82289_;
                    double z = (double)posZ + world.f_46441_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - 0.2) + 0.1 + aabb.f_82290_;
                    if (side == Direction.DOWN) {
                        y = (double)posY + aabb.f_82289_ - 0.1;
                    }
                    if (side == Direction.UP) {
                        y = (double)posY + aabb.f_82292_ + 0.1;
                    }
                    if (side == Direction.NORTH) {
                        z = (double)posZ + aabb.f_82290_ - 0.1;
                    }
                    if (side == Direction.SOUTH) {
                        z = (double)posZ + aabb.f_82293_ + 0.1;
                    }
                    if (side == Direction.WEST) {
                        x = (double)posX + aabb.f_82288_ - 0.1;
                    }
                    if (side == Direction.EAST) {
                        x = (double)posX + aabb.f_82291_ + 0.1;
                    }
                    TerrainParticle diggingParticle = new TerrainParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
                    Minecraft.m_91087_().f_91061_.m_107344_(diggingParticle.updateSprite(state, pos).m_107268_(0.2f).m_6569_(0.6f));
                }
            }
        });
    }
}

