/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.BlockStateGenerator;
import com.github.talrey.createdeco.CreateDecoMod;
import com.github.talrey.createdeco.ItemRegistry;
import com.github.talrey.createdeco.api.Bars;
import com.github.talrey.createdeco.api.Bricks;
import com.github.talrey.createdeco.api.CageLamps;
import com.github.talrey.createdeco.api.Catwalks;
import com.github.talrey.createdeco.api.Coins;
import com.github.talrey.createdeco.api.Decals;
import com.github.talrey.createdeco.api.Doors;
import com.github.talrey.createdeco.api.Facades;
import com.github.talrey.createdeco.api.Hulls;
import com.github.talrey.createdeco.api.Ladders;
import com.github.talrey.createdeco.api.MeshFences;
import com.github.talrey.createdeco.api.Placards;
import com.github.talrey.createdeco.api.SheetMetal;
import com.github.talrey.createdeco.api.ShippingContainers;
import com.github.talrey.createdeco.api.Supports;
import com.github.talrey.createdeco.api.Wedges;
import com.github.talrey.createdeco.api.Windows;
import com.github.talrey.createdeco.blocks.CageLampBlock;
import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.blocks.CatwalkRailingBlock;
import com.github.talrey.createdeco.blocks.CatwalkStairBlock;
import com.github.talrey.createdeco.blocks.CoinStackBlock;
import com.github.talrey.createdeco.blocks.DecalBlock;
import com.github.talrey.createdeco.blocks.DyedPlacardBlock;
import com.github.talrey.createdeco.blocks.FacadeBlock;
import com.github.talrey.createdeco.blocks.HullBlock;
import com.github.talrey.createdeco.blocks.MeshFenceBlock;
import com.github.talrey.createdeco.blocks.ShippingContainerBlock;
import com.github.talrey.createdeco.blocks.SupportBlock;
import com.github.talrey.createdeco.blocks.SupportWedgeBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.MetalLadderBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedPillarBlock;
import com.simibubi.create.content.decoration.palettes.WindowBlock;
import com.simibubi.create.content.decoration.placard.PlacardBlock;
import com.simibubi.create.content.decoration.placard.PlacardRenderer;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;

public class BlockRegistry {
    public static HashMap<DyeColor, String> BRICK_COLORS = new HashMap<DyeColor, String>(){
        {
            this.put(DyeColor.LIGHT_BLUE, "blue");
            this.put(DyeColor.YELLOW, "dean");
            this.put(DyeColor.BLACK, "dusk");
            this.put(DyeColor.WHITE, "pearl");
            this.put(DyeColor.RED, "scarlet");
            this.put(DyeColor.GREEN, "verdant");
            this.put(DyeColor.BROWN, "umber");
            this.put(null, "red");
        }
    };
    public static HashMap<DyeColor, HashMap<String, BlockEntry<Block>>> BRICKS = new HashMap();
    public static HashMap<DyeColor, HashMap<String, BlockEntry<StairBlock>>> STAIRS = new HashMap();
    public static HashMap<DyeColor, HashMap<String, BlockEntry<SlabBlock>>> SLABS = new HashMap();
    public static HashMap<DyeColor, HashMap<String, BlockEntry<WallBlock>>> WALLS = new HashMap();
    public static HashMap<String, BlockEntry<DecalBlock>> DECALS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> YELLOW_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> RED_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> GREEN_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> BLUE_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<WindowBlock>> WINDOWS = new HashMap();
    public static HashMap<String, BlockEntry<WindowBlock>> WINDOW_PANES = new HashMap();
    public static HashMap<String, BlockEntry<DoorBlock>> DOORS = new HashMap();
    public static HashMap<String, BlockEntry<DoorBlock>> LOCK_DOORS = new HashMap();
    public static HashMap<String, BlockEntry<TrapDoorBlock>> TRAPDOORS = new HashMap();
    public static HashMap<String, BlockEntry<IronBarsBlock>> BARS = new HashMap();
    public static HashMap<String, BlockEntry<IronBarsBlock>> BAR_PANELS = new HashMap();
    public static HashMap<String, BlockEntry<MeshFenceBlock>> MESH_FENCES = new HashMap();
    public static HashMap<String, BlockEntry<ConnectedPillarBlock>> SHEET_METAL_PILLARS = new HashMap();
    public static HashMap<String, BlockEntry<CatwalkBlock>> CATWALKS = new HashMap();
    public static HashMap<String, BlockEntry<CatwalkStairBlock>> CATWALK_STAIRS = new HashMap();
    public static HashMap<String, BlockEntry<CatwalkRailingBlock>> CATWALK_RAILINGS = new HashMap();
    public static HashMap<String, BlockEntry<MetalLadderBlock>> LADDERS = new HashMap();
    public static HashMap<String, BlockEntry<HullBlock>> HULLS = new HashMap();
    public static HashMap<String, BlockEntry<SupportBlock>> SUPPORTS = new HashMap();
    public static HashMap<String, BlockEntry<SupportWedgeBlock>> WEDGES = new HashMap();
    public static HashMap<String, BlockEntry<FacadeBlock>> FACADES = new HashMap();
    public static HashMap<DyeColor, BlockEntry<? extends PlacardBlock>> PLACARDS = new HashMap();
    public static BlockEntityEntry<DyedPlacardBlock.Entity> PLACARD_ENTITIES;
    public static HashMap<String, BlockEntry<CoinStackBlock>> COIN_BLOCKS;
    public static HashMap<DyeColor, BlockEntry<ShippingContainerBlock>> SHIPPING_CONTAINERS;
    public static HashMap<DyeColor, BlockEntityEntry<ShippingContainerBlock.Entity>> CONTAINER_ENTITIES;
    public static final BlockEntry<WindowBlock> ANDESITE_WINDOW;
    public static final BlockEntry<WindowBlock> COPPER_WINDOW;
    public static final BlockEntry<WindowBlock> IRON_WINDOW;
    public static final BlockEntry<WindowBlock> INDUSTRIAL_IRON_WINDOW;
    public static final BlockEntry<WindowBlock> BRASS_WINDOW;
    public static final BlockEntry<WindowBlock> ZINC_WINDOW;
    public static final BlockEntry<ConnectedGlassPaneBlock> ANDESITE_WINDOW_PANE;
    public static final BlockEntry<ConnectedGlassPaneBlock> COPPER_WINDOW_PANE;
    public static final BlockEntry<ConnectedGlassPaneBlock> IRON_WINDOW_PANE;
    public static final BlockEntry<ConnectedGlassPaneBlock> INDUSTRIAL_IRON_WINDOW_PANE;
    public static final BlockEntry<ConnectedGlassPaneBlock> BRASS_WINDOW_PANE;
    public static final BlockEntry<ConnectedGlassPaneBlock> ZINC_WINDOW_PANE;

    public static DyeColor fromName(String color) {
        for (DyeColor dye : BRICK_COLORS.keySet()) {
            if (!BRICK_COLORS.get(dye).equals(color)) continue;
            return dye;
        }
        return null;
    }

    public static void init() {
        CreateDecoMod.LOGGER.info("Registering blocks for Create Deco");
        CreateDecoMod.REGISTRATE.defaultCreativeTab("props_tab");
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerBars);
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerFences);
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerCatwalks);
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerLadders);
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerHulls);
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerSupports);
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerCageLamps);
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerSheetMetal);
        ItemRegistry.METAL_TYPES.forEach(BlockRegistry::registerDoors);
        BlockRegistry.registerShippingContainers();
        BlockRegistry.registerDecals();
        BlockRegistry.registerPlacards();
        ItemRegistry.COIN_METALS.forEach(BlockRegistry::registerCoins);
        CreateDecoMod.REGISTRATE.defaultCreativeTab("bricks_tab");
        BlockRegistry.registerBricks();
    }

    private static void registerBars(String metal, Function<String, Item> getter) {
        boolean postFlag = metal.contains("Netherite") || metal.contains("Industrial Iron");
        BAR_PANELS.put(metal, (BlockEntry<IronBarsBlock>)Bars.build(CreateDecoMod.REGISTRATE, metal, "overlay", postFlag).recipe((ctx, prov) -> {
            Bars.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov);
            Bars.recipeCraftingPanels(metal, ctx, prov);
        }).register());
        if (metal.equals("Iron")) {
            return;
        }
        BARS.put(metal, (BlockEntry<IronBarsBlock>)Bars.build(CreateDecoMod.REGISTRATE, metal, "", postFlag).recipe((ctx, prov) -> {
            Bars.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov);
            Bars.recipeCrafting(() -> (Item)getter.apply("ingot"), ctx, prov);
        }).register());
    }

    private static void registerFences(String metal, Function<String, Item> getter) {
        MESH_FENCES.put(metal, (BlockEntry<MeshFenceBlock>)MeshFences.build(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> {
            MeshFences.fenceRecipe(metal, ctx, prov);
            Bars.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov);
        }).register());
    }

    private static void registerDecals() {
        ArrayList<BlockBuilder<DecalBlock, ?>> decals = Decals.build(CreateDecoMod.REGISTRATE);
        decals.forEach((Consumer<BlockBuilder<DecalBlock, ?>>)((Consumer<BlockBuilder>)bb -> DECALS.put(bb.getName(), (BlockEntry<DecalBlock>)bb.register())));
    }

    private static void registerCageLamps(String metal, Function<String, Item> getter) {
        ResourceLocation cage = new ResourceLocation("createdeco", "block/palettes/cage_lamp/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_lamp");
        ItemEntry material = metal == "Andesite" ? AllItems.ANDESITE_ALLOY : null;
        YELLOW_CAGE_LAMPS.put(metal, (BlockEntry<CageLampBlock>)CageLamps.build(CreateDecoMod.REGISTRATE, metal, DyeColor.YELLOW, cage, CageLamps.YELLOW_ON, CageLamps.YELLOW_OFF).recipe(CageLamps.recipe(metal, () -> Items.f_42000_, (Supplier<Item>)material)).register());
        RED_CAGE_LAMPS.put(metal, (BlockEntry<CageLampBlock>)CageLamps.build(CreateDecoMod.REGISTRATE, metal, DyeColor.RED, cage, CageLamps.RED_ON, CageLamps.RED_OFF).recipe(CageLamps.recipe(metal, () -> Items.f_41978_, (Supplier<Item>)material)).register());
        GREEN_CAGE_LAMPS.put(metal, (BlockEntry<CageLampBlock>)CageLamps.build(CreateDecoMod.REGISTRATE, metal, DyeColor.GREEN, cage, CageLamps.GREEN_ON, CageLamps.GREEN_OFF).recipe(CageLamps.recipe(metal, () -> Items.f_151079_, (Supplier<Item>)material)).register());
        BLUE_CAGE_LAMPS.put(metal, (BlockEntry<CageLampBlock>)CageLamps.build(CreateDecoMod.REGISTRATE, metal, DyeColor.BLUE, cage, CageLamps.BLUE_ON, CageLamps.BLUE_OFF).recipe(CageLamps.recipe(metal, () -> Items.f_42053_, (Supplier<Item>)material)).register());
    }

    private static void registerCatwalks(String metal, Function<String, Item> getter) {
        CATWALKS.put(metal, (BlockEntry<CatwalkBlock>)Catwalks.build(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> {
            Catwalks.recipeCatwalk(metal, (ItemLike)(metal.equals("Iron") ? Items.f_42025_ : (ItemLike)BARS.get(metal)), ctx, prov);
            Catwalks.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov, 4);
        }).register());
        CATWALK_STAIRS.put(metal, (BlockEntry<CatwalkStairBlock>)Catwalks.buildStair(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> {
            Catwalks.recipeStairs(metal, (ItemLike)(metal.equals("Iron") ? Items.f_42025_ : (ItemLike)BARS.get(metal)), ctx, prov);
            Catwalks.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov, 2);
        }).register());
        CATWALK_RAILINGS.put(metal, (BlockEntry<CatwalkRailingBlock>)Catwalks.buildRailing(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> {
            Catwalks.recipeRailing(metal, (ItemLike)(metal.equals("Iron") ? Items.f_42025_ : (ItemLike)BARS.get(metal)), ctx, prov);
            Catwalks.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov, 8);
        }).register());
        WEDGES.put(metal, (BlockEntry<SupportWedgeBlock>)Wedges.build(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> {
            Bars.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov);
            Wedges.recipe(metal, ctx, prov);
        }).register());
        FACADES.put(metal, (BlockEntry<FacadeBlock>)Facades.build(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> Bars.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov)).register());
    }

    private static void registerSheetMetal(String metal, Function<String, Item> getter) {
        SHEET_METAL_PILLARS.put(metal, (BlockEntry<ConnectedPillarBlock>)SheetMetal.buildBlock(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> SheetMetal.recipeCrafting(metal, ctx, prov)).register());
    }

    private static void registerDoors(String metal, Function<String, Item> getter) {
        if (metal.equals("Iron") || metal.equals("Gold") || metal.equals("Netherite")) {
            return;
        }
        DOORS.put(metal, (BlockEntry<DoorBlock>)Doors.build(CreateDecoMod.REGISTRATE, metal, false).recipe(Doors.recipe(() -> (Item)getter.apply("ingot"))).register());
        LOCK_DOORS.put(metal, (BlockEntry<DoorBlock>)Doors.build(CreateDecoMod.REGISTRATE, metal, true).recipe(Doors.lockedRecipe(() -> DOORS.get(metal).m_5456_())).register());
        TRAPDOORS.put(metal, (BlockEntry<TrapDoorBlock>)Doors.buildTrapdoor(CreateDecoMod.REGISTRATE, metal).recipe(Doors.trapdoorRecipe(() -> (Item)getter.apply("ingot"))).register());
    }

    private static void registerHulls(String metal, Function<String, Item> getter) {
        HULLS.put(metal, (BlockEntry<HullBlock>)Hulls.build(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> {
            Hulls.recipeCrafting(metal, ctx, prov);
            Hulls.recipeStonecutting(metal, ctx, prov);
        }).register());
    }

    private static void registerLadders(String metal, Function<String, Item> getter) {
        if (metal.contains("opper") || metal.contains("ndesite") || metal.contains("rass")) {
            return;
        }
        LADDERS.put(metal, (BlockEntry<MetalLadderBlock>)Ladders.build(CreateDecoMod.REGISTRATE, metal).recipe((ctx, prov) -> Ladders.recipeStonecutting(() -> (Item)getter.apply("ingot"), ctx, prov)).register());
    }

    private static void registerSupports(String metal, Function<String, Item> getter) {
        SUPPORTS.put(metal, (BlockEntry<SupportBlock>)Supports.build(CreateDecoMod.REGISTRATE, metal).recipe(Supports.recipe(() -> (Item)getter.apply("ingot"))).register());
    }

    private static void registerShippingContainers() {
        for (DyeColor color : DyeColor.values()) {
            SHIPPING_CONTAINERS.put(color, (BlockEntry<ShippingContainerBlock>)ShippingContainers.build(CreateDecoMod.REGISTRATE, color).recipe((ctx, prov) -> {
                ShippingContainers.recipeCrafting(color, ctx, prov);
                ShippingContainers.recipeDyeing(color, ctx, prov);
            }).register());
            CONTAINER_ENTITIES.put(color, (BlockEntityEntry<ShippingContainerBlock.Entity>)CreateDecoMod.REGISTRATE.blockEntity("shipping_container_" + color.m_41065_().toLowerCase(Locale.ROOT).replaceAll(" ", "_"), ShippingContainerBlock.Entity::new).validBlocks(new NonNullSupplier[]{(NonNullSupplier)SHIPPING_CONTAINERS.get(color)}).register());
        }
    }

    private static void registerPlacards() {
        for (DyeColor color : DyeColor.values()) {
            if (color == DyeColor.WHITE) continue;
            String regName = color.name().toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_placard";
            PLACARDS.put(color, (BlockEntry<? extends PlacardBlock>)((BlockBuilder)((BlockBuilder)CreateDecoMod.REGISTRATE.block(regName, DyedPlacardBlock::new).initialProperties(SharedProperties::copperMetal).transform(TagGen.pickaxeOnly())).blockstate((ctx, prov) -> BlockStateGenerator.placard(CreateDecoMod.REGISTRATE, color, ctx, prov)).simpleItem().recipe((ctx, prov) -> {
                Placards.recipeCrafting(color, ctx, prov);
                Placards.recipeDyeing(color, ctx, prov);
            }).onRegisterAfter(Registries.f_256913_, placard -> {
                TooltipModifier original = (TooltipModifier)TooltipModifier.REGISTRY.get((Object)AllBlocks.PLACARD.m_5456_());
                if (original == null) {
                    CreateDecoMod.LOGGER.info("placard tooltip was null");
                } else if (original.equals(TooltipModifier.EMPTY)) {
                    CreateDecoMod.LOGGER.info("placard tooltip was empty");
                }
            })).register());
        }
        BlockEntry[] validPlacards = new BlockEntry[PLACARDS.size()];
        int color = 0;
        Iterator<BlockEntry<? extends PlacardBlock>> iterator = PLACARDS.values().iterator();
        while (iterator.hasNext()) {
            BlockEntry<? extends PlacardBlock> block;
            validPlacards[color] = block = iterator.next();
        }
        PLACARD_ENTITIES = CreateDecoMod.REGISTRATE.blockEntity("dyed_placard", DyedPlacardBlock.Entity::new).renderer(() -> PlacardRenderer::new).validBlocks((NonNullSupplier[])PLACARDS.values().toArray(validPlacards)).register();
    }

    private static void registerCoins(String metal, Function<String, Item> getter) {
        if (metal.equals("Andesite")) {
            return;
        }
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        ResourceLocation side = new ResourceLocation("createdeco", "block/" + regName + "_coinstack_side");
        ResourceLocation top = new ResourceLocation("createdeco", "block/" + regName + "_coinstack_top");
        ResourceLocation bottom = new ResourceLocation("createdeco", "block/" + regName + "_coinstack_bottom");
        COIN_BLOCKS.put(metal, (BlockEntry<CoinStackBlock>)Coins.buildCoinStackBlock(CreateDecoMod.REGISTRATE, (NonNullSupplier<Item>)((NonNullSupplier)() -> (Item)ItemRegistry.COINSTACKS.get(metal).get()), metal, side, bottom, top).register());
    }

    private static void registerBricks() {
        BRICK_COLORS.forEach((color, name) -> {
            ArrayList<BlockBuilder<Block, ?>> blocks = Bricks.buildBlock(CreateDecoMod.REGISTRATE, name);
            blocks.forEach((Consumer<BlockBuilder<Block, ?>>)((Consumer<BlockBuilder>)bb -> {
                BRICKS.putIfAbsent((DyeColor)color, new HashMap());
                BRICKS.get(color).put(bb.getName(), (BlockEntry<Block>)bb.register());
            }));
            ArrayList<BlockBuilder<StairBlock, ?>> stairs = Bricks.buildStair(CreateDecoMod.REGISTRATE, name);
            stairs.forEach((Consumer<BlockBuilder<StairBlock, ?>>)((Consumer<BlockBuilder>)bb -> {
                STAIRS.putIfAbsent((DyeColor)color, new HashMap());
                STAIRS.get(color).put(bb.getName(), (BlockEntry<StairBlock>)bb.register());
            }));
            ArrayList<BlockBuilder<SlabBlock, ?>> slabs = Bricks.buildSlab(CreateDecoMod.REGISTRATE, name);
            slabs.forEach((Consumer<BlockBuilder<SlabBlock, ?>>)((Consumer<BlockBuilder>)bb -> {
                SLABS.putIfAbsent((DyeColor)color, new HashMap());
                SLABS.get(color).put(bb.getName(), (BlockEntry<SlabBlock>)bb.register());
            }));
            ArrayList<BlockBuilder<WallBlock, ?>> walls = Bricks.buildWall(CreateDecoMod.REGISTRATE, name);
            walls.forEach((Consumer<BlockBuilder<WallBlock, ?>>)((Consumer<BlockBuilder>)bb -> {
                WALLS.putIfAbsent((DyeColor)color, new HashMap());
                WALLS.get(color).put(bb.getName(), (BlockEntry<WallBlock>)bb.register());
            }));
        });
    }

    static {
        COIN_BLOCKS = new HashMap();
        SHIPPING_CONTAINERS = new HashMap();
        CONTAINER_ENTITIES = new HashMap();
        ANDESITE_WINDOW = Windows.metalWindowBlock("Andesite");
        COPPER_WINDOW = Windows.metalWindowBlock("Copper");
        IRON_WINDOW = Windows.metalWindowBlock("Iron");
        INDUSTRIAL_IRON_WINDOW = Windows.metalWindowBlock("Industrial Iron");
        BRASS_WINDOW = Windows.metalWindowBlock("Brass");
        ZINC_WINDOW = Windows.metalWindowBlock("Zinc");
        ANDESITE_WINDOW_PANE = Windows.metalWindowPane("Andesite", ANDESITE_WINDOW);
        COPPER_WINDOW_PANE = Windows.metalWindowPane("Copper", COPPER_WINDOW);
        IRON_WINDOW_PANE = Windows.metalWindowPane("Iron", IRON_WINDOW);
        INDUSTRIAL_IRON_WINDOW_PANE = Windows.metalWindowPane("Industrial Iron", INDUSTRIAL_IRON_WINDOW);
        BRASS_WINDOW_PANE = Windows.metalWindowPane("Brass", BRASS_WINDOW);
        ZINC_WINDOW_PANE = Windows.metalWindowPane("Zinc", ZINC_WINDOW);
    }
}

