/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.shared.network.compression;

import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.minecraft.network.FriendlyByteBuf;

public class MinecraftCompressEncoder
extends MessageToByteEncoder<ByteBuf> {
    private int threshold;
    private final VelocityCompressor compressor;

    public MinecraftCompressEncoder(int threshold, VelocityCompressor compressor) {
        this.threshold = threshold;
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        FriendlyByteBuf wrappedBuf = new FriendlyByteBuf(out);
        int uncompressed = msg.readableBytes();
        if (uncompressed < this.threshold) {
            wrappedBuf.m_130130_(0);
            out.writeBytes(msg);
        } else {
            wrappedBuf.m_130130_(uncompressed);
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (ByteBuf)msg);
            try {
                this.compressor.deflate(compatibleIn, out);
            }
            finally {
                compatibleIn.release();
            }
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        int initialBufferSize = msg.readableBytes() + 1;
        return MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)this.compressor, (int)initialBufferSize);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.compressor.close();
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

