/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.silentsdelight.datagen;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.scouter.silentsdelight.SilentsDelight;
import com.scouter.silentsdelight.blocks.SDBlocks;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class SDBlockStateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_ANGLE_OFFSET = 180;
    public static final List<Pair<BooleanProperty, Function<ResourceLocation, Variant>>> MULTIFACE_GENERATOR = List.of(Pair.of((Object)BlockStateProperties.f_61368_, p_176234_ -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, p_176234_)), Pair.of((Object)BlockStateProperties.f_61369_, p_176229_ -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, p_176229_).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)), Pair.of((Object)BlockStateProperties.f_61370_, p_176225_ -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, p_176225_).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)), Pair.of((Object)BlockStateProperties.f_61371_, p_176213_ -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, p_176213_).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)), Pair.of((Object)BlockStateProperties.f_61366_, p_176204_ -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, p_176204_).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)), Pair.of((Object)BlockStateProperties.f_61367_, p_176195_ -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, p_176195_).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)));
    public static BlockFamily family = null;

    public SDBlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "silentsdelight", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.pieBlock((Block)SDBlocks.SCULK_CATALYST_PIE.get());
        this.feastBlock((FeastBlock)SDBlocks.PLATED_WARDEN_HEART.get());
    }

    public void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(this.getName(block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.m_61143_((Property)servingsProperty);
            if (servings == 3 || servings == 4) {
                return ConfiguredModel.builder().modelFile(this.existingModel(this.getName((Block)block) + "_stage1")).rotationY(((int)((Direction)state.m_61143_((Property)FeastBlock.FACING)).m_122435_() + 180) % 360).build();
            }
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 2) {
                suffix = "_stage1";
            }
            if (servings == 1) {
                suffix = "_stage0";
            }
            if (servings == 0) {
                suffix = "_leftover";
            }
            return ConfiguredModel.builder().modelFile(this.existingModel(this.getName((Block)block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)FeastBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    private void createPottedPlant(RegistryObject<Block> plant, RegistryObject<Block> pottedPlant, String renderType) {
        ConfiguredModel cFfile = new ConfiguredModel(this.pottedPlant(this.name((Block)pottedPlant.get()), this.blockTexture((Block)plant.get()), renderType));
        this.getVariantBuilder((Block)pottedPlant.get()).partialState().setModels(new ConfiguredModel[]{cFfile});
    }

    public ModelFile pottedPlant(String name, ResourceLocation plant, String renderType) {
        return this.singleTexture(name, "block/flower_pot_cross", "plant", plant, renderType);
    }

    public void createFlatWaterEgg(Block block) {
        this.createFlatWaterEgg(block, "");
        this.flatWaterEgg(block);
        this.singleTexWaterEgg(block);
    }

    private BlockModelBuilder singleTexWaterEgg(Block block) {
        return this.generated(this.getName(block), new ResourceLocation("silentsdelight", "item/" + this.getName(block)));
    }

    private void flatWaterEgg(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.existingModel("eggs/" + this.getName(block))).build(), new Property[0]);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("silentsdelight", "block/" + path);
    }

    public void createHangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.createHangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void createHangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private void logBlock(RegistryObject<Block> block) {
        this.logBlock((Block)block.get());
    }

    private void logBlock(Block block) {
        this.axisBlock((RotatedPillarBlock)block, SilentsDelight.prefix("block/" + this.key(block).m_135815_()), SilentsDelight.prefix("block/" + this.key(block).m_135815_() + "_top"));
    }

    private void createAge3Block(Block pBlock, String renderTyp, boolean item) {
        String baseName = this.name(pBlock);
        this.getVariantBuilder(pBlock).forAllStatesExcept(state -> {
            int age = (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_);
            ResourceLocation textureSuspicious = SilentsDelight.prefix("block/" + baseName + "_" + age);
            ModelFile text = this.cross(baseName + "_" + age, textureSuspicious, renderTyp);
            return ConfiguredModel.builder().modelFile(text).build();
        }, new Property[0]);
        ModelFile.ExistingModelFile file = this.models().getExistingFile(SilentsDelight.prefix(baseName + "_0"));
        if (item) {
            this.simpleBlockItem(pBlock, (ModelFile)file);
        }
    }

    private void createCropBlock(Block pBlock, String renderTyp) {
        String baseName = this.name(pBlock);
        this.getVariantBuilder(pBlock).forAllStatesExcept(state -> {
            int age = (Integer)state.m_61143_((Property)CropBlock.f_52244_);
            ResourceLocation textureSuspicious = SilentsDelight.prefix("block/" + baseName + "_" + age);
            ModelFile text = this.cross(baseName + "_" + age, textureSuspicious, renderTyp);
            return ConfiguredModel.builder().modelFile(text).build();
        }, new Property[0]);
        ModelFile.ExistingModelFile file = this.models().getExistingFile(SilentsDelight.prefix(baseName + "_0"));
        this.simpleBlockItem(pBlock, (ModelFile)file);
    }

    private void createSkullBlocks(RegistryObject<Block> RegistryObject2) {
        Block block = (Block)RegistryObject2.get();
        String baseName = this.name(block);
        this.getVariantBuilder(block).forAllStates(state -> {
            ResourceLocation skullLoc = SilentsDelight.prefix("block/skulls/" + baseName);
            ModelFile.ExistingModelFile text = this.models().getExistingFile(skullLoc);
            return ConfiguredModel.builder().modelFile((ModelFile)text).build();
        });
        this.getVariantBuilder(this.getBlock(SilentsDelight.prefix(baseName + "_wall"))).forAllStates(state -> {
            ResourceLocation skullLoc = SilentsDelight.prefix("block/skulls/" + baseName + "_wall");
            ModelFile.ExistingModelFile text = this.models().getExistingFile(skullLoc);
            return ConfiguredModel.builder().modelFile((ModelFile)text).build();
        });
        this.singleTexItem(block);
        this.singleTexItem(this.getBlock(SilentsDelight.prefix(baseName + "_wall")));
    }

    private void createBrushableBlock(Block pBlock) {
        String baseName = this.name(pBlock);
        this.getVariantBuilder(pBlock).forAllStatesExcept(state -> {
            int dusted = (Integer)state.m_61143_((Property)BlockStateProperties.f_271112_);
            ResourceLocation textureSuspicious = SilentsDelight.prefix("block/" + baseName + "_" + dusted);
            ModelBuilder text = this.models().cubeAll(baseName + "_" + dusted, textureSuspicious);
            return ConfiguredModel.builder().modelFile((ModelFile)text).build();
        }, new Property[0]);
        ModelFile.ExistingModelFile file = this.models().getExistingFile(SilentsDelight.prefix(baseName + "_0"));
        this.simpleBlockItem(pBlock, (ModelFile)file);
    }

    private void simpleBlockLeaves(RegistryObject<Block> b, String renderType) {
        this.simpleBlock((Block)b.get(), this.leaves((Block)b.get(), renderType));
    }

    private void simpleBlock(RegistryObject<Block> b, String renderType) {
        this.simpleBlock((Block)b.get(), this.cubeAll((Block)b.get(), renderType));
    }

    public void cubeAllWithItem(Block block, String renderType) {
        ModelFile file = this.cubeAll(this.name(block), this.blockTexture(block), renderType);
        this.simpleBlockItem(block, file);
    }

    public ModelFile cubeAll(Block block, String renderType) {
        return this.cubeAll(this.name(block), this.blockTexture(block), renderType);
    }

    public ModelFile leaves(Block block, String renderType) {
        ModelFile leaves = this.leaves(this.name(block), this.blockTexture(block), renderType);
        this.simpleBlockItem(block, leaves);
        return leaves;
    }

    public ModelFile leaves(String name, ResourceLocation texture, String renderType) {
        return this.singleTexture(name, "block/leaves", "all", texture, renderType);
    }

    public ModelFile cubeAll(String name, ResourceLocation texture, String renderType) {
        return this.singleTexture(name, "block/cube_all", "all", texture, renderType);
    }

    private void buildLamp(Block block) {
        String baseName = this.name(block);
        ResourceLocation textureOn = SilentsDelight.prefix("block/" + baseName + "_on");
        ResourceLocation textureOff = SilentsDelight.prefix("block/" + baseName + "_off");
        ModelBuilder on = this.models().cubeAll(baseName + "_on", textureOn);
        ModelBuilder off = this.models().cubeAll(baseName + "_off", textureOff);
        this.simpleBlockItem(block, (ModelFile)off);
        this.buildLamp(block, (ModelFile)on, (ModelFile)off);
    }

    private void buildLamp(Block block, ModelFile on, ModelFile off) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            boolean isLit = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
            return ConfiguredModel.builder().modelFile(isLit ? on : off).build();
        }, new Property[0]);
    }

    public void generatePressurePlate(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.pressurePlateBlock((PressurePlateBlock)block, SilentsDelight.prefix("block/" + this.key(block1).m_135815_()));
    }

    public void generateWall(Block block) {
        this.wallBlockWithRenderType((WallBlock)block, SilentsDelight.prefix("block/" + this.key(block).m_135815_().replace("_wall", "")), "cutout");
        this.generatedWall(this.name(block), ResourceLocation.m_135820_((String)this.blockTexture(block).toString().replace("_wall", "")));
    }

    public void generateTrapDoor(Block block) {
        this.trapdoorBlockWithRenderType((TrapDoorBlock)block, SilentsDelight.prefix("block/" + this.key(block).m_135815_()), true, "cutout");
    }

    public void generateStair(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.stairsBlockWithRenderType((StairBlock)block, SilentsDelight.prefix("block/" + this.key(block1).m_135815_()), "cutout");
    }

    public void generateSlab(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.slabBlock((SlabBlock)block, SilentsDelight.prefix("block/" + this.key(block1).m_135815_()), SilentsDelight.prefix("block/" + this.key(block1).m_135815_()), SilentsDelight.prefix("block/" + this.key(block1).m_135815_()), SilentsDelight.prefix("block/" + this.key(block1).m_135815_()));
    }

    public void generateSign(Block signBlock) {
        LOGGER.error("Sign gen is not yet implemented!");
        String p = this.key(signBlock).m_135815_();
        String z = p.replace("_sign", "_wall_sign").replace("blocks/", "");
        ResourceLocation hanging = SilentsDelight.prefix(z);
        Block block = this.getBlock(hanging);
        this.signBlock((StandingSignBlock)signBlock, (WallSignBlock)block, SilentsDelight.prefix("entity/sign/" + this.key(signBlock).m_135815_().replace("_sign", "")));
    }

    public void generateFenceGate(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.fenceGateBlockWithRenderType((FenceGateBlock)block, SilentsDelight.prefix("block/" + this.key(block1).m_135815_()), "cutout");
    }

    public void generateFence(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.fenceBlockWithRenderType((FenceBlock)block, SilentsDelight.prefix("block/" + this.key(block1).m_135815_()), "cutout");
    }

    public void generateCracked(Block block) {
        this.blockWithItem(block);
    }

    public void generateChiseled(Block block) {
        this.blockWithItem(block);
    }

    public void generateDoor(Block doorBlock) {
        this.doorBlockWithRenderType((DoorBlock)doorBlock, SilentsDelight.prefix("block/" + this.key(doorBlock).m_135815_() + "_bottom"), SilentsDelight.prefix("block/" + this.key(doorBlock).m_135815_() + "_top"), "cutout");
    }

    public void generateButton(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        this.buttonBlock((ButtonBlock)block, SilentsDelight.prefix("block/" + this.key(block1).m_135815_()));
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void blockWithItem(Block blockRegistryObject, ModelFile file) {
        this.simpleBlockWithItem(blockRegistryObject, file);
    }

    private void blockWithItem(Block blockRegistryObject) {
        this.simpleBlockWithItem(blockRegistryObject, this.cubeAll(blockRegistryObject));
    }

    private void blockWithItemSlab(Block blockRegistryObject) {
        this.simpleBlockWithItem(blockRegistryObject, this.stripSlab(blockRegistryObject));
    }

    private ModelFile stripSlab(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.m_175951_();
        }
        return this.models().cubeAll(this.name(block), ResourceLocation.m_135820_((String)this.blockTexture(block1).toString().replace("_slab", "")));
    }

    private void createWallFan(RegistryObject<Block> b, String renderType) {
        ModelFile file = new ConfiguredModel((ModelFile)this.wallCoral((String)this.name((Block)((Block)b.get())), (ResourceLocation)this.blockTexture((Block)((Block)b.get())), (String)renderType)).model;
        this.getVariantBuilder((Block)b.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(file).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
        this.simpleBlockItem((Block)b.get(), file);
    }

    private void createTintedCross(RegistryObject<Block> b, String renderType) {
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(this.tintedCross(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType))});
    }

    public ModelFile tintedCross(String name, ResourceLocation cross, String renderType) {
        return this.singleTexture(name, "block/tinted_cross", "cross", cross, renderType);
    }

    private void createDoubleCross(RegistryObject<Block> b, String renderType) {
        String baseName = this.name((Block)b.get());
        this.getVariantBuilder((Block)b.get()).forAllStatesExcept(e -> {
            DoubleBlockHalf val = (DoubleBlockHalf)e.m_61143_((Property)DoublePlantBlock.f_52858_);
            String mod = val == DoubleBlockHalf.LOWER ? "bottom" : "top";
            ResourceLocation texture = SilentsDelight.prefix("block/" + baseName + "_" + mod);
            ModelFile text = this.cross(baseName + "_" + mod, texture, renderType);
            return ConfiguredModel.builder().modelFile(text).build();
        }, new Property[0]);
        this.singleTex((Block)b.get(), baseName + "_top");
    }

    private void createCross(RegistryObject<Block> b, String renderType) {
        ConfiguredModel cFfile = new ConfiguredModel(this.cross(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType));
        ModelFile file = cFfile.model;
        String baseName = this.name((Block)b.get());
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{cFfile});
        this.singleTex((Block)b.get(), baseName);
    }

    public ModelFile cross(String name, ResourceLocation cross, String renderType) {
        return this.singleTexture(name, "block/cross", "cross", cross, renderType);
    }

    private ModelFile singleTexture(String name, String parent, String textureKey, ResourceLocation texture, String renderType) {
        return this.singleTexture(name, this.mcLoc(parent), textureKey, texture, renderType);
    }

    public ModelFile wallCoral(String name, ResourceLocation fan, String renderType) {
        return this.singleTexture(name, "block/coral_wall_fan", "fan", fan, renderType);
    }

    private void createCoralFan(RegistryObject<Block> b, String renderType) {
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(this.coralFan(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType))});
        this.singleTex((Block)b.get());
    }

    public ModelFile coralFan(String name, ResourceLocation fan, String renderType) {
        return this.singleTexture(name, "block/coral_fan", "fan", fan, renderType);
    }

    public ModelFile singleTexture(String name, ResourceLocation parent, String textureKey, ResourceLocation texture, String renderType) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture(textureKey, texture)).renderType(renderType);
    }

    private BlockModelBuilder generatedWall(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("block/" + name, "block/wall_inventory");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private BlockModelBuilder generatedSlab(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("block/" + name, "block/slab");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private void blockWithTop(RegistryObject<Block> blockRegistryObject) {
        this.horizontalBlock((Block)blockRegistryObject.get(), SilentsDelight.prefix("block/" + this.key((Block)blockRegistryObject.get()).m_135815_()), SilentsDelight.prefix("block/" + this.key((Block)blockRegistryObject.get()).m_135815_()), SilentsDelight.prefix("block/" + this.key((Block)blockRegistryObject.get()).m_135815_() + "_top"));
        this.simpleBlockItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private BlockModelBuilder singleTexItem(Block block, ResourceLocation name) {
        return this.generated(this.name(block), name);
    }

    private BlockModelBuilder singleTexItem(Block block) {
        return this.generated(this.name(block), new ResourceLocation("silentsdelight", "item/" + this.name(block)));
    }

    private BlockModelBuilder singleTex(Block block) {
        return this.singleTex(block, this.name(block));
    }

    private BlockModelBuilder singleTex(Block block, String name) {
        return this.generated(this.name(block), new ResourceLocation("silentsdelight", "block/" + name));
    }

    private BlockModelBuilder generated(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("item/" + name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private String getName(Block block) {
        return this.key(block).toString().replace("silentsdelight:", "");
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    public ModelFile createFlatWaterEgg(Block block, String modifier) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + baseName.replace("silentsdelight:", ""), new ResourceLocation("silentsdelight", "block/template_eggs/template_flat_water_egg"), this.blockTextureEggs(block));
    }

    public ResourceLocation blockTextureEggs(Block block) {
        ResourceLocation name = this.key(block);
        return new ResourceLocation(name.m_135827_(), "block/eggs/" + name.m_135815_());
    }

    private String name(Block block) {
        return this.key(block).m_135815_();
    }

    private Block getBlock(ResourceLocation resourceLocation) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(resourceLocation);
    }
}

