/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.render;

import com.mojang.math.Axis;
import com.simibubi.create.content.fluids.FluidMesh;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class PipetteFluidVisual {
    private final SmartRecycler<TextureAtlasSprite, TransformedInstance> surface;
    private final VisualizationContext context;

    public PipetteFluidVisual(VisualizationContext context) {
        this.context = context;
        this.surface = new SmartRecycler(key -> (TransformedInstance)context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, FluidMesh.surface((TextureAtlasSprite)key, (float)1.0f)).createInstance());
    }

    public TransformedInstance createFluidInstance(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return null;
        }
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite stillTexture = (TextureAtlasSprite)atlas.apply(clientFluid.getStillTexture(fluidStack));
        TransformedInstance instance = (TransformedInstance)this.surface.get((Object)stillTexture);
        instance.colorArgb(clientFluid.getTintColor(fluidStack));
        return instance;
    }

    public void setupPipetteFluid(TransformedInstance fluidInstance, FluidStack fluidStack, int capacity, boolean isInjectMode) {
        if (fluidInstance == null || fluidStack.isEmpty()) {
            return;
        }
        float fillFactor = (float)fluidStack.getAmount() / (float)capacity;
        fluidInstance.setIdentityTransform();
        float needleRadius = 0.02f;
        float needleLength = 0.3f;
        float fluidLength = fillFactor * needleLength;
        fluidInstance.translate(0.0f, 0.0f, -0.15f);
        if (isInjectMode) {
            fluidInstance.translate(0.0f, 0.0f, -(needleLength - fluidLength) / 2.0f);
        } else {
            fluidInstance.translate(0.0f, 0.0f, (needleLength - fluidLength) / 2.0f);
        }
        fluidInstance.scaleX(needleRadius);
        fluidInstance.scaleY(needleRadius);
        fluidInstance.scaleZ(fluidLength);
        if (fluidStack.getFluid().getFluidType().isLighterThanAir()) {
            fluidInstance.rotateDegrees(180.0f, Axis.f_252403_);
        }
        fluidInstance.setChanged();
    }

    public void setupStorageFluid(TransformedInstance fluidInstance, FluidStack fluidStack, int capacity) {
        if (fluidInstance == null || fluidStack.isEmpty()) {
            return;
        }
        float fillFactor = (float)fluidStack.getAmount() / (float)capacity;
        float storageWidth = 0.125f;
        float storageHeight = 0.25f;
        fluidInstance.setIdentityTransform();
        fluidInstance.translate(0.0f, 0.0f, -0.5f);
        fluidInstance.translateY(-storageHeight / 2.0f + fillFactor * storageHeight / 2.0f);
        fluidInstance.scaleX(storageWidth);
        fluidInstance.scaleY(fillFactor * storageHeight);
        fluidInstance.scaleZ(storageWidth);
        fluidInstance.setChanged();
    }

    public void begin() {
        this.surface.resetCount();
    }

    public void end() {
        this.surface.discardExtra();
    }

    public void delete() {
        this.surface.delete();
    }
}

