/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.registry;

import com.adonis.fluid.CreateFluid;
import com.adonis.fluid.fluid.powdersnow.PowderSnowFluid;
import com.adonis.fluid.fluid.powdersnow.PowderSnowFluidType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CFFluid {
    private static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"fluid");
    public static final RegistryObject<Fluid> POWDER_SNOW = FLUIDS.register("powder_snow", PowderSnowFluid.Source::new);
    public static final RegistryObject<Fluid> POWDER_SNOW_FLOWING = FLUIDS.register("powder_snow_flowing", PowderSnowFluid.Flowing::new);

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        FLUIDS.register(modEventBus);
        PowderSnowFluidType.FLUID_TYPES.register(modEventBus);
        CreateFluid.LOGGER.info("Registering CF Fluids");
    }

    public static boolean isPowderSnowFluid(Fluid fluid) {
        return fluid == POWDER_SNOW.get() || fluid == POWDER_SNOW_FLOWING.get();
    }

    public static FluidStack getPowderSnowFluidStack(int amount) {
        return new FluidStack((Fluid)POWDER_SNOW.get(), amount);
    }
}

