/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.ponder;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.block.SmartFluidInterface.SmartFluidInterfaceBlockEntity;
import com.adonis.fluid.registry.CFFluid;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.mixer.MechanicalMixerBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PowderSnowScenes {
    public static void snow(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("powder_snow", "Powder Snow as Fluid");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        BlockPos cauldronPos = util.grid().at(2, 1, 2);
        BlockPos pipettePos = util.grid().at(0, 1, 3);
        BlockPos pipetteGear1Pos = util.grid().at(0, 1, 4);
        BlockPos pipetteGear2Pos = util.grid().at(0, 1, 5);
        BlockPos pipe1Pos = util.grid().at(3, 1, 2);
        BlockPos pipe2Pos = util.grid().at(3, 1, 3);
        BlockPos pumpPos = util.grid().at(3, 1, 4);
        BlockPos shaftPos = util.grid().at(3, 1, 5);
        BlockPos tankBottomPos = util.grid().at(3, 2, 4);
        BlockPos tankTopPos = util.grid().at(3, 3, 4);
        BlockPos smartInterfacePos = util.grid().at(2, 3, 4);
        BlockPos basinPos = util.grid().at(4, 1, 1);
        BlockPos mixerPos = util.grid().at(4, 3, 1);
        BlockPos mixerGearPos = util.grid().at(5, 3, 1);
        BlockPos lowerGearPos = util.grid().at(5, 0, 1);
        Selection cauldronSel = util.select().position(cauldronPos);
        Selection pipetteSel = util.select().position(pipettePos);
        Selection pipetteGearsSel = util.select().fromTo(0, 1, 4, 0, 1, 5);
        Selection pipesSel = util.select().fromTo(3, 1, 2, 3, 1, 3);
        Selection pumpSel = util.select().position(pumpPos);
        Selection shaftSel = util.select().position(shaftPos);
        Selection tankSel = util.select().fromTo(3, 2, 4, 3, 3, 4);
        Selection smartInterfaceSel = util.select().position(smartInterfacePos);
        Selection basinSel = util.select().position(basinPos);
        Selection mixerSel = util.select().position(mixerPos);
        Selection mixerShaftSel = util.select().fromTo(5, 1, 1, 5, 3, 1);
        Selection mixerGearSel = util.select().position(mixerGearPos);
        Selection lowerGearSel = util.select().position(lowerGearPos);
        Selection tankTopSel = util.select().position(tankTopPos);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        BlockState powderSnowCauldron = (BlockState)Blocks.f_152478_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3));
        scene.world().setBlock(cauldronPos, powderSnowCauldron, false);
        scene.idle(20);
        scene.world().showSection(cauldronSel, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("Powder Snow is now a fluid that can be collected from Cauldrons using pipes or Mechanical Pipettes").pointAt(util.vector().blockSurface(cauldronPos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        scene.world().showSection(pipesSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(pumpSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(shaftSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(tankSel, Direction.DOWN);
        scene.idle(10);
        scene.world().setKineticSpeed(pumpSel, 32.0f);
        scene.world().setKineticSpeed(shaftSel, 32.0f);
        scene.world().propagatePipeChange(pumpPos);
        scene.idle(40);
        scene.world().setBlock(cauldronPos, Blocks.f_50256_.m_49966_(), false);
        scene.idle(20);
        scene.world().showSection(smartInterfaceSel, Direction.DOWN);
        scene.idle(10);
        ItemStack powderSnowBucket = new ItemStack((ItemLike)Items.f_151055_);
        scene.overlay().showControls(util.vector().blockSurface(tankTopPos, Direction.WEST), Pointing.RIGHT, 40).rightClick().withItem(powderSnowBucket);
        scene.idle(7);
        scene.world().setFilterData(smartInterfaceSel, SmartFluidInterfaceBlockEntity.class, powderSnowBucket);
        scene.idle(10);
        scene.overlay().showOutlineWithText(smartInterfaceSel, 80).attachKeyFrame().colored(PonderPalette.OUTPUT).text("Powder Snow Buckets can be used to set filters for Powder Snow fluid").pointAt(util.vector().blockSurface(smartInterfacePos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        scene.world().showSection(pipetteSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(pipetteGearsSel, Direction.DOWN);
        scene.idle(10);
        scene.world().setKineticSpeed(pipetteSel, -48.0f);
        scene.world().setKineticSpeed(pipetteGearsSel, -48.0f);
        scene.world().multiplyKineticSpeed(util.select().position(0, 1, 5), -1.0f);
        scene.idle(20);
        PowderSnowScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_INPUT, FluidStack.EMPTY, 0);
        scene.idle(24);
        scene.world().modifyBlockEntity(tankBottomPos, FluidTankBlockEntity.class, be -> be.getTankInventory().drain(1000, IFluidHandler.FluidAction.EXECUTE));
        scene.idle(10);
        FluidStack powderSnowFluid = CFFluid.getPowderSnowFluidStack(1000);
        PowderSnowScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_OUTPUTS, powderSnowFluid, -1);
        scene.idle(20);
        PowderSnowScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.MOVE_TO_OUTPUT, powderSnowFluid, 0);
        scene.idle(24);
        scene.world().setBlock(cauldronPos, powderSnowCauldron, false);
        scene.idle(10);
        PowderSnowScenes.instructPipette(scene, pipettePos, PipetteBlockEntity.Phase.SEARCH_INPUTS, FluidStack.EMPTY, -1);
        scene.idle(20);
        scene.world().showSection(basinSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(lowerGearSel, Direction.UP);
        scene.idle(5);
        scene.world().showSection(mixerShaftSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(mixerSel, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(mixerGearSel, Direction.DOWN);
        scene.idle(10);
        scene.world().setKineticSpeed(lowerGearSel, 32.0f);
        scene.world().setKineticSpeed(mixerShaftSel, 32.0f);
        scene.world().setKineticSpeed(mixerSel, 32.0f);
        scene.world().setKineticSpeed(mixerGearSel, 32.0f);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.GREEN).text("Powder Snow fluid can also be created using a Mechanical Mixer").pointAt(util.vector().blockSurface(basinPos, Direction.WEST)).placeNearTarget();
        scene.idle(90);
        ItemStack snowBlock = new ItemStack((ItemLike)Items.f_41981_);
        scene.overlay().showControls(util.vector().topOf(basinPos), Pointing.RIGHT, 30).rightClick().withItem(snowBlock);
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> be.getInputInventory().insertItem(0, snowBlock.m_41777_(), false));
        scene.idle(20);
        scene.world().modifyBlockEntity(mixerPos, MechanicalMixerBlockEntity.class, mixer -> mixer.startProcessingBasin());
        scene.idle(40);
        scene.world().modifyBlockEntity(basinPos, BasinBlockEntity.class, be -> {
            be.getInputInventory().extractItem(0, 64, false);
            be.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fh -> fh.fill(CFFluid.getPowderSnowFluidStack(1000), IFluidHandler.FluidAction.EXECUTE));
        });
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(basinPos), Pointing.RIGHT, 30).rightClick().withItem(powderSnowBucket);
        scene.idle(10);
        scene.overlay().showText(80).attachKeyFrame().colored(PonderPalette.WHITE).text("Right-click the Basin to obtain Powder Snow Buckets").pointAt(util.vector().blockSurface(basinPos, Direction.UP)).placeNearTarget();
        scene.idle(90);
        scene.markAsFinished();
    }

    private static void instructPipette(CreateSceneBuilder scene, BlockPos pipettePos, PipetteBlockEntity.Phase phase, FluidStack heldFluid, int targetedPoint) {
        scene.world().modifyBlockEntityNBT(scene.getScene().getSceneBuildingUtil().select().position(pipettePos), PipetteBlockEntity.class, compound -> {
            NBTHelper.writeEnum((CompoundTag)compound, (String)"Phase", (Enum)phase);
            compound.m_128365_("HeldFluid", (Tag)heldFluid.writeToNBT(new CompoundTag()));
            compound.m_128405_("TargetPointIndex", targetedPoint);
            compound.m_128350_("MovementProgress", 0.0f);
        });
    }
}

