/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PipetteParticlePacket
extends SimplePacketBase {
    private final Vec3 pos;
    private final FluidStack fluid;

    public PipetteParticlePacket(Vec3 pos, FluidStack fluid) {
        this.pos = pos;
        this.fluid = fluid;
    }

    public PipetteParticlePacket(FriendlyByteBuf buffer) {
        this.pos = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.pos.f_82479_);
        buffer.writeDouble(this.pos.f_82480_);
        buffer.writeDouble(this.pos.f_82481_);
        this.fluid.writeToPacket(buffer);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientHandler.handleParticle(this.pos, this.fluid)));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        private static void handleParticle(Vec3 pos, FluidStack fluid) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level == null || fluid.isEmpty()) {
                return;
            }
            ParticleOptions particle = FluidFX.getFluidParticle((FluidStack)fluid);
            for (int i = 0; i < 20; ++i) {
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)0.125f);
                motion = new Vec3(motion.f_82479_, -Math.abs(motion.f_82480_) * 0.5 - 0.1, motion.f_82481_);
                level.m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
    }
}

