/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.handler.PipetteFluidInteractionPointHandler;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PipetteFluidPlacementPacket
extends SimplePacketBase {
    private ListTag pointsTag;
    private BlockPos pos;

    public PipetteFluidPlacementPacket(Collection<FluidInteractionPoint> points, BlockPos pos) {
        this.pos = pos;
        this.pointsTag = new ListTag();
        points.stream().map(point -> point.serialize(pos)).forEach(arg_0 -> this.pointsTag.add(arg_0));
    }

    public PipetteFluidPlacementPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        CompoundTag nbt = buffer.m_130260_();
        this.pointsTag = nbt != null ? nbt.m_128437_("Points", 10) : new ListTag();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Points", (Tag)this.pointsTag);
        buffer.m_130079_(nbt);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            if (!world.m_46749_(this.pos)) {
                return;
            }
            BlockEntity be = world.m_7702_(this.pos);
            if (be instanceof PipetteBlockEntity) {
                PipetteBlockEntity pipette = (PipetteBlockEntity)be;
                pipette.inputs.clear();
                pipette.outputs.clear();
                pipette.setInteractionPointTag(this.pointsTag);
                pipette.resetMovementState();
                pipette.forceReloadInteractionPoints();
                pipette.m_6596_();
                pipette.sendData();
                world.m_7654_().execute(() -> world.m_7260_(this.pos, pipette.m_58900_(), pipette.m_58900_(), 3));
            }
        });
        return true;
    }

    public static class ClientBoundRequest
    extends SimplePacketBase {
        private BlockPos pos;

        public ClientBoundRequest(BlockPos pos) {
            this.pos = pos;
        }

        public ClientBoundRequest(FriendlyByteBuf buffer) {
            this.pos = buffer.m_130135_();
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130064_(this.pos);
        }

        public boolean handle(NetworkEvent.Context context) {
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PipetteFluidInteractionPointHandler.flushSettings(this.pos)));
            return true;
        }
    }
}

