/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.handler;

import com.adonis.fluid.block.CentrifugalPump.CentrifugalPumpBlock;
import com.adonis.fluid.block.CentrifugalPump.CentrifugalPumpBlockEntity;
import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.item.BatonItem;
import com.adonis.fluid.mixin.accessor.ArmBlockEntityAccessor;
import com.adonis.fluid.packet.CentrifugalPumpModeTogglePacket;
import com.adonis.fluid.packet.PipetteFluidPlacementPacket;
import com.adonis.fluid.packet.QuartzLampTogglePacket;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmPlacementPacket;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.depot.EjectorPlacementPacket;
import com.simibubi.create.content.logistics.depot.EntityLauncher;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BatonInteractionHandler {
    private static BlockEntity selectedTarget = null;
    private static BlockPos selectedTargetPos = null;
    private static List<ArmInteractionPoint> currentArmSelection = new ArrayList<ArmInteractionPoint>();
    private static List<FluidInteractionPoint> currentPipetteSelection = new ArrayList<FluidInteractionPoint>();
    private static BlockPos selectedEjectorPos = null;
    private static BlockPos ejectorTargetPos = null;
    private static EntityLauncher launcher = null;
    private static SelectionType selectionType = SelectionType.NONE;
    private static int particleCounter = 0;

    public static boolean isInSelectionMode() {
        return selectionType != SelectionType.NONE;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof BatonItem)) {
            return;
        }
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        boolean sneaking = player.m_6144_();
        if (!level.f_46443_) {
            BlockEntity be = level.m_7702_(pos);
            if (!(!(be instanceof CentrifugalPumpBlockEntity) || state.m_61138_((Property)CentrifugalPumpBlock.ENCASED) && ((Boolean)state.m_61143_((Property)CentrifugalPumpBlock.ENCASED)).booleanValue())) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            if (be instanceof ArmBlockEntity || be instanceof PipetteBlockEntity || be instanceof EjectorBlockEntity && selectionType != SelectionType.ARM && selectionType != SelectionType.PIPETTE || state.m_60734_() instanceof RoseQuartzLampBlock) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            if (BatonInteractionHandler.canBeInteractionPoint(level, pos, state)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        BlockEntity be = level.m_7702_(pos);
        if (BatonInteractionHandler.isInSelectionMode() && selectionType != SelectionType.EJECTOR && !sneaking) {
            if (selectionType == SelectionType.ARM) {
                if (be instanceof EjectorBlockEntity || BatonInteractionHandler.canBeInteractionPoint(level, pos, state)) {
                    BatonInteractionHandler.handleArmPointInteraction(level, pos, state, player);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
            } else if (selectionType == SelectionType.PIPETTE && (be instanceof EjectorBlockEntity || BatonInteractionHandler.canBeInteractionPoint(level, pos, state))) {
                BatonInteractionHandler.handlePipettePointInteraction(level, pos, state, player);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
        }
        if (state.m_60734_() instanceof RoseQuartzLampBlock) {
            AllPackets.getChannel().sendToServer((Object)new QuartzLampTogglePacket(pos));
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 1.0f, false);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (be instanceof CentrifugalPumpBlockEntity) {
            CentrifugalPumpBlockEntity pump = (CentrifugalPumpBlockEntity)be;
            if (!(state.m_61138_((Property)CentrifugalPumpBlock.ENCASED) && ((Boolean)state.m_61143_((Property)CentrifugalPumpBlock.ENCASED)).booleanValue() || sneaking || pump.pumpMode == null)) {
                AllPackets.getChannel().sendToServer((Object)new CentrifugalPumpModeTogglePacket(pos));
                int currentMode = pump.pumpMode.getValue();
                int nextMode = (currentMode + 1) % CentrifugalPumpBlockEntity.PumpMode.values().length;
                CentrifugalPumpBlockEntity.PumpMode newMode = CentrifugalPumpBlockEntity.PumpMode.values()[nextMode];
                CreateLang.builder().translate(newMode.getTranslationKey(), new Object[0]).style(ChatFormatting.AQUA).sendStatus(player);
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 1.5f, false);
                BatonInteractionHandler.createPumpModeToggleParticles(level, pos);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
            return;
        }
        if (be instanceof ArmBlockEntity) {
            ArmBlockEntity arm = (ArmBlockEntity)be;
            if (sneaking) {
                BatonInteractionHandler.handleArmDanceToggle(arm, player, level);
            } else {
                BatonInteractionHandler.handleArmTargetClick(be, pos, player, level);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (be instanceof PipetteBlockEntity) {
            if (!sneaking) {
                BatonInteractionHandler.handlePipetteTargetClick(be, pos, player, level);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        if (be instanceof EjectorBlockEntity) {
            BatonInteractionHandler.handleEjectorClick(be, pos, player, level, sneaking);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (selectionType == SelectionType.EJECTOR && selectedEjectorPos != null) {
            if (!sneaking) {
                BatonInteractionHandler.handleEjectorTargetSelection(pos, player, level);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
            return;
        }
    }

    private static boolean canBeInteractionPoint(Level level, BlockPos pos, BlockState state) {
        if (ArmInteractionPoint.isInteractable((Level)level, (BlockPos)pos, (BlockState)state)) {
            return true;
        }
        return FluidInteractionPoint.create(level, pos, state) != null;
    }

    private static void handleArmDanceToggle(ArmBlockEntity arm, Player player, Level level) {
        boolean isDancing;
        ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)arm;
        boolean bl = isDancing = accessor.getPhase() == ArmBlockEntity.Phase.DANCING;
        if (isDancing) {
            accessor.setPhase(ArmBlockEntity.Phase.SEARCH_INPUTS);
            CreateLang.builder().translate("fluid.baton.arm.dance_stopped", new Object[0]).style(ChatFormatting.YELLOW).sendStatus(player);
        } else {
            accessor.setPhase(ArmBlockEntity.Phase.DANCING);
            CreateLang.builder().translate("fluid.baton.arm.dance_started", new Object[0]).style(ChatFormatting.GREEN).sendStatus(player);
        }
        level.m_7785_((double)arm.m_58899_().m_123341_() + 0.5, (double)arm.m_58899_().m_123342_() + 0.5, (double)arm.m_58899_().m_123343_() + 0.5, (SoundEvent)SoundEvents.f_12210_.get(), SoundSource.BLOCKS, 0.5f, isDancing ? 0.8f : 1.2f, false);
        BatonInteractionHandler.createDanceToggleParticles(level, arm.m_58899_());
    }

    private static void handleEjectorClick(BlockEntity be, BlockPos pos, Player player, Level level, boolean sneaking) {
        if (selectionType == SelectionType.EJECTOR && selectedEjectorPos != null && selectedEjectorPos.equals((Object)pos)) {
            BatonInteractionHandler.flushEjectorSettings(pos, player, level);
            return;
        }
        if (selectionType == SelectionType.EJECTOR && selectedEjectorPos != null && !selectedEjectorPos.equals((Object)pos)) {
            BatonInteractionHandler.handleEjectorTargetSelection(pos, player, level);
            return;
        }
        if (selectionType == SelectionType.NONE) {
            selectionType = SelectionType.EJECTOR;
            selectedEjectorPos = pos;
            launcher = null;
            EjectorBlockEntity ejector = (EjectorBlockEntity)be;
            BlockPos targetPos = ejector.getTargetPosition();
            ejectorTargetPos = !targetPos.equals((Object)pos) ? targetPos : null;
            CreateLang.builder().translate("fluid.baton.ejector.click_to_set", new Object[0]).style(ChatFormatting.GOLD).sendStatus(player);
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.5f, 1.0f, false);
            BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
        }
    }

    private static void handleEjectorTargetSelection(BlockPos pos, Player player, Level level) {
        ejectorTargetPos = pos;
        launcher = null;
        CreateLang.builder().translate("fluid.baton.ejector.target_set", new Object[0]).style(ChatFormatting.GOLD).sendStatus(player);
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.3f, 1.5f, false);
    }

    private static Direction getValidTargetDirection(BlockPos ejectorPos, BlockPos targetPos) {
        if (targetPos == null) {
            return null;
        }
        if (VecHelper.onSameAxis((BlockPos)ejectorPos, (BlockPos)targetPos, (Direction.Axis)Direction.Axis.Y)) {
            return null;
        }
        int xDiff = targetPos.m_123341_() - ejectorPos.m_123341_();
        int zDiff = targetPos.m_123343_() - ejectorPos.m_123343_();
        int max = (Integer)AllConfigs.server().kinetics.maxEjectorDistance.get();
        if (Math.abs(xDiff) > max || Math.abs(zDiff) > max) {
            return null;
        }
        if (xDiff == 0) {
            return Direction.m_122390_((Direction.AxisDirection)(zDiff < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)Direction.Axis.Z);
        }
        if (zDiff == 0) {
            return Direction.m_122390_((Direction.AxisDirection)(xDiff < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)Direction.Axis.X);
        }
        return null;
    }

    private static void flushEjectorSettings(BlockPos ejectorPos, Player player, Level level) {
        if (ejectorTargetPos == null) {
            CreateLang.builder().translate("fluid.baton.ejector.no_target", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            BatonInteractionHandler.cancelSelection();
            return;
        }
        Direction validDirection = BatonInteractionHandler.getValidTargetDirection(ejectorPos, ejectorTargetPos);
        if (validDirection == null) {
            CreateLang.builder().translate("fluid.baton.ejector.invalid_target", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            BatonInteractionHandler.cancelSelection();
            return;
        }
        int xDiff = ejectorTargetPos.m_123341_() - ejectorPos.m_123341_();
        int zDiff = ejectorTargetPos.m_123343_() - ejectorPos.m_123343_();
        int yDiff = ejectorTargetPos.m_123342_() - ejectorPos.m_123342_();
        int horizontalDistance = Math.max(Math.abs(xDiff), Math.abs(zDiff));
        AllPackets.getChannel().sendToServer((Object)new EjectorPlacementPacket(horizontalDistance, yDiff, ejectorPos, validDirection));
        CreateLang.builder().translate("weighted_ejector.targeting", new Object[]{ejectorTargetPos.m_123341_(), ejectorTargetPos.m_123342_(), ejectorTargetPos.m_123343_()}).style(ChatFormatting.GREEN).sendStatus(player);
        level.m_7785_((double)ejectorPos.m_123341_() + 0.5, (double)ejectorPos.m_123342_() + 0.5, (double)ejectorPos.m_123343_() + 0.5, (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
        BatonInteractionHandler.cancelSelection();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof BatonItem)) {
            return;
        }
        if (BatonInteractionHandler.isInSelectionMode()) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
            if (event.getLevel().f_46443_) {
                BlockPos pos = event.getPos();
                if (selectionType == SelectionType.EJECTOR) {
                    if (pos.equals((Object)ejectorTargetPos)) {
                        ejectorTargetPos = null;
                        launcher = null;
                        CreateLang.builder().translate("fluid.baton.ejector.target_cleared", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                    }
                } else {
                    boolean removed = false;
                    if (selectionType == SelectionType.ARM) {
                        int sizeBefore = currentArmSelection.size();
                        BatonInteractionHandler.removeArm(pos);
                        boolean bl = removed = currentArmSelection.size() < sizeBefore;
                        if (removed) {
                            CreateLang.builder().translate("fluid.baton.interaction_point_removed", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                            event.getLevel().m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 0.8f, false);
                        }
                    } else if (selectionType == SelectionType.PIPETTE) {
                        int sizeBefore = currentPipetteSelection.size();
                        BatonInteractionHandler.removePipette(pos);
                        boolean bl = removed = currentPipetteSelection.size() < sizeBefore;
                        if (removed) {
                            CreateLang.builder().translate("fluid.baton.interaction_point_removed", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                            event.getLevel().m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 0.8f, false);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof BatonItem)) {
            if (BatonInteractionHandler.isInSelectionMode()) {
                BatonInteractionHandler.cancelSelection();
            }
            return;
        }
        if (BatonInteractionHandler.isInSelectionMode()) {
            ++particleCounter;
            if (selectedTargetPos != null) {
                BatonInteractionHandler.createContinuousParticles((Level)Minecraft.m_91087_().f_91073_, selectedTargetPos);
            } else if (selectedEjectorPos != null) {
                BatonInteractionHandler.createContinuousParticles((Level)Minecraft.m_91087_().f_91073_, selectedEjectorPos);
            }
            if (selectionType == SelectionType.ARM) {
                BatonInteractionHandler.drawArmOutlines(currentArmSelection);
            } else if (selectionType == SelectionType.PIPETTE) {
                BatonInteractionHandler.drawPipetteOutlines(currentPipetteSelection);
            } else if (selectionType == SelectionType.EJECTOR) {
                BatonInteractionHandler.drawEjectorOutlines();
                BatonInteractionHandler.drawEjectorArc();
            }
        }
    }

    private static void drawEjectorOutlines() {
        ClientLevel level;
        BlockState state;
        VoxelShape shape;
        if (ejectorTargetPos != null && !(shape = (state = (level = Minecraft.m_91087_().f_91073_).m_8055_(ejectorTargetPos)).m_60808_((BlockGetter)level, ejectorTargetPos)).m_83281_()) {
            Outliner.getInstance().showAABB((Object)"ejector_target", shape.m_83215_().m_82338_(ejectorTargetPos)).colored(16763764).lineWidth(0.0625f);
        }
    }

    private static void drawEjectorArc() {
        if (selectedEjectorPos == null || ejectorTargetPos == null) {
            return;
        }
        int xDiff = ejectorTargetPos.m_123341_() - selectedEjectorPos.m_123341_();
        int zDiff = ejectorTargetPos.m_123343_() - selectedEjectorPos.m_123343_();
        int yDiff = ejectorTargetPos.m_123342_() - selectedEjectorPos.m_123342_();
        int validX = Math.abs(zDiff) > Math.abs(xDiff) ? 0 : xDiff;
        int validZ = Math.abs(zDiff) < Math.abs(xDiff) ? 0 : zDiff;
        boolean isValid = xDiff == validX && zDiff == validZ;
        int color = isValid ? 10416499 : 16736625;
        Direction validDirection = BatonInteractionHandler.getValidTargetDirection(selectedEjectorPos, ejectorTargetPos);
        if (validDirection == null) {
            if (Math.abs(validX) >= Math.abs(validZ)) {
                validDirection = validX != 0 ? (validX > 0 ? Direction.EAST : Direction.WEST) : Direction.NORTH;
            } else {
                Direction direction = validZ != 0 ? (validZ > 0 ? Direction.SOUTH : Direction.NORTH) : (validDirection = Direction.NORTH);
            }
        }
        if (launcher == null) {
            int horizontalDistance = Math.max(Math.abs(validX), Math.abs(validZ));
            if (horizontalDistance == 0) {
                horizontalDistance = 1;
            }
            launcher = new EntityLauncher(horizontalDistance, yDiff);
        }
        double totalFlyingTicks = launcher.getTotalFlyingTicks() + 3.0;
        int segments = (int)(totalFlyingTicks / 3.0) + 1;
        double tickOffset = totalFlyingTicks / (double)segments;
        Vector3f colorVec = new Color(color).asVectorF();
        DustParticleOptions data = new DustParticleOptions(colorVec, 1.0f);
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (!isValid) {
            BlockPos validPos = selectedEjectorPos.m_7918_(validX - xDiff, -yDiff, validZ - zDiff);
            AABB bb = new AABB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0).m_82338_(validPos);
            Outliner.getInstance().chaseAABB((Object)"valid", bb).colored(color).lineWidth(0.0625f);
        }
        for (int i = 0; i < segments; ++i) {
            double ticks = (double)(AnimationTickHolder.getRenderTime() / 3.0f) % tickOffset + (double)i * tickOffset;
            Vec3 vec = launcher.getGlobalPos(ticks, validDirection.m_122424_(), selectedEjectorPos);
            if (!isValid) {
                vec = vec.m_82520_((double)(xDiff - validX), 0.0, (double)(zDiff - validZ));
            }
            world.m_7106_((ParticleOptions)data, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private static void handleArmTargetClick(BlockEntity be, BlockPos pos, Player player, Level level) {
        if (selectedTarget == be && selectedTargetPos.equals((Object)pos)) {
            BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
            BatonInteractionHandler.flushArmSettings(pos);
            return;
        }
        BatonInteractionHandler.cancelSelection();
        selectedTarget = be;
        selectedTargetPos = pos;
        selectionType = SelectionType.ARM;
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
        ArmBlockEntity arm = (ArmBlockEntity)be;
        currentArmSelection.clear();
        ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)arm;
        List<ArmInteractionPoint> inputs = accessor.getInputs();
        List<ArmInteractionPoint> outputs = accessor.getOutputs();
        currentArmSelection.addAll(inputs);
        currentArmSelection.addAll(outputs);
        CreateLang.builder().translate("create.mechanical_arm.summary", new Object[]{inputs.size(), outputs.size()}).style(ChatFormatting.WHITE).sendStatus(player);
    }

    private static void handlePipetteTargetClick(BlockEntity be, BlockPos pos, Player player, Level level) {
        if (selectedTarget == be && selectedTargetPos.equals((Object)pos)) {
            BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
            BatonInteractionHandler.flushPipetteSettings(pos);
            return;
        }
        BatonInteractionHandler.cancelSelection();
        selectedTarget = be;
        selectedTargetPos = pos;
        selectionType = SelectionType.PIPETTE;
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
        PipetteBlockEntity pipette = (PipetteBlockEntity)be;
        currentPipetteSelection.clear();
        currentPipetteSelection.addAll(pipette.inputs);
        currentPipetteSelection.addAll(pipette.outputs);
        CreateLang.builder().translate("fluid.mechanical_pipette.summary", new Object[]{pipette.inputs.size(), pipette.outputs.size()}).style(ChatFormatting.WHITE).sendStatus(player);
    }

    private static void handleArmPointInteraction(Level level, BlockPos pos, BlockState state, Player player) {
        ArmInteractionPoint selected = BatonInteractionHandler.getSelectedArm(pos);
        if (selected == null) {
            ArmInteractionPoint point = ArmInteractionPoint.create((Level)level, (BlockPos)pos, (BlockState)state);
            if (point == null) {
                return;
            }
            selected = point;
            BatonInteractionHandler.putArm(point);
            BatonInteractionHandler.playSelectionEffects(level, pos, true);
        }
        selected.cycleMode();
        ArmInteractionPoint.Mode mode = selected.getMode();
        CreateLang.builder().translate(mode.getTranslationKey(), new Object[]{CreateLang.blockName((BlockState)state).style(ChatFormatting.WHITE)}).color(mode.getColor()).sendStatus(player);
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 2.0f, false);
    }

    private static void flushArmSettings(BlockPos armPos) {
        int removed = 0;
        Iterator<ArmInteractionPoint> iterator = currentArmSelection.iterator();
        while (iterator.hasNext()) {
            ArmInteractionPoint point = iterator.next();
            if (point.getPos().m_123314_((Vec3i)armPos, (double)ArmBlockEntity.getRange())) continue;
            iterator.remove();
            ++removed;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (removed > 0) {
            CreateLang.builder().translate("create.mechanical_arm.points_outside_range", new Object[]{removed}).style(ChatFormatting.RED).sendStatus((Player)player);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (ArmInteractionPoint point : currentArmSelection) {
                if (point.getMode() == ArmInteractionPoint.Mode.DEPOSIT) {
                    ++outputs;
                    continue;
                }
                ++inputs;
            }
            if (inputs + outputs > 0) {
                CreateLang.builder().translate("create.mechanical_arm.summary", new Object[]{inputs, outputs}).style(ChatFormatting.WHITE).sendStatus((Player)player);
            }
        }
        AllPackets.getChannel().sendToServer((Object)new ArmPlacementPacket(currentArmSelection, armPos));
        Minecraft.m_91087_().f_91073_.m_7785_((double)armPos.m_123341_() + 0.5, (double)armPos.m_123342_() + 0.5, (double)armPos.m_123343_() + 0.5, (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
        BatonInteractionHandler.cancelSelection();
    }

    private static void flushPipetteSettings(BlockPos pipettePos) {
        int removed = 0;
        Iterator<FluidInteractionPoint> iterator = currentPipetteSelection.iterator();
        while (iterator.hasNext()) {
            FluidInteractionPoint point = iterator.next();
            if (point.getPos().m_123314_((Vec3i)pipettePos, (double)PipetteBlockEntity.getRange())) continue;
            iterator.remove();
            ++removed;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (removed > 0) {
            CreateLang.builder().translate("fluid.mechanical_pipette.points_outside_range", new Object[]{removed}).style(ChatFormatting.RED).sendStatus((Player)player);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (FluidInteractionPoint point : currentPipetteSelection) {
                if (point.getMode() == FluidInteractionPoint.Mode.DEPOSIT) {
                    ++outputs;
                    continue;
                }
                ++inputs;
            }
            if (inputs + outputs > 0) {
                CreateLang.builder().translate("fluid.mechanical_pipette.summary", new Object[]{inputs, outputs}).style(ChatFormatting.WHITE).sendStatus((Player)player);
            }
        }
        AllPackets.getChannel().sendToServer((Object)new PipetteFluidPlacementPacket(currentPipetteSelection, pipettePos));
        Minecraft.m_91087_().f_91073_.m_7785_((double)pipettePos.m_123341_() + 0.5, (double)pipettePos.m_123342_() + 0.5, (double)pipettePos.m_123343_() + 0.5, (SoundEvent)SoundEvents.f_12211_.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
        BatonInteractionHandler.cancelSelection();
    }

    private static void handlePipettePointInteraction(Level level, BlockPos pos, BlockState state, Player player) {
        FluidInteractionPoint selected = BatonInteractionHandler.getSelectedPipette(pos);
        if (selected == null) {
            FluidInteractionPoint point = FluidInteractionPoint.create(level, pos, state);
            if (point == null) {
                return;
            }
            selected = point;
            BatonInteractionHandler.putPipette(point);
            BatonInteractionHandler.playSelectionEffects(level, pos, true);
        }
        selected.cycleMode();
        FluidInteractionPoint.Mode mode = selected.getMode();
        CreateLang.builder().translate(mode.getTranslationKey(), new Object[]{CreateLang.blockName((BlockState)state).style(ChatFormatting.WHITE)}).color(mode.getColor()).sendStatus(player);
        level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 2.0f, false);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem;
        Player player = event.getEntity();
        if (player != null && (heldItem = player.m_21205_()).m_41720_() instanceof BatonItem && BatonInteractionHandler.isInSelectionMode()) {
            event.setCanceled(true);
        }
    }

    private static void playSelectionEffects(Level level, BlockPos pos, boolean isNew) {
        if (isNew) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.3f, 1.5f, false);
        }
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + (random.nextDouble() - 0.5) * 0.6;
            double y = (double)pos.m_123342_() + 0.5 + (random.nextDouble() - 0.5) * 0.6;
            double z = (double)pos.m_123343_() + 0.5 + (random.nextDouble() - 0.5) * 0.6;
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void createSelectionSuccessParticles(Level level, BlockPos pos) {
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            double angle = Math.PI * 2 * (double)i / 20.0;
            double radius = 0.7;
            double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.5f), x, y, z, 0.0, 0.05, 0.0);
        }
    }

    private static void createDanceToggleParticles(Level level, BlockPos pos) {
        Random random = new Random();
        for (int i = 0; i < 8; ++i) {
            double angle = Math.PI * 2 * (double)i / 8.0;
            double radius = 1.0;
            double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
            double y = (double)pos.m_123342_() + 1.0 + random.nextDouble() * 0.5;
            double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123758_, x, y, z, random.nextDouble(), 0.0, 0.0);
        }
    }

    private static void createPumpModeToggleParticles(Level level, BlockPos pos) {
        Random random = new Random();
        for (int i = 0; i < 12; ++i) {
            double angle = Math.PI * 2 * (double)i / 12.0;
            double radius = 0.5;
            double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
            double y = (double)pos.m_123342_() + 0.5 + (double)i * 0.05;
            double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 1.0f), 1.0f), x, y, z, 0.0, 0.02, 0.0);
        }
    }

    private static void createContinuousParticles(Level level, BlockPos pos) {
        Random random = new Random();
        if (particleCounter % 10 == 0) {
            for (int i = 0; i < 6; ++i) {
                double angle = Math.PI * 2 * (double)i / 6.0;
                double radius = 0.7 + random.nextDouble() * 0.2;
                double x = (double)pos.m_123341_() + 0.5 + Math.cos(angle) * radius;
                double y = (double)pos.m_123342_() + 0.5 + random.nextDouble() * 0.8;
                double z = (double)pos.m_123343_() + 0.5 + Math.sin(angle) * radius;
                level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 0.6f), x, y, z, 0.0, 0.01, 0.0);
            }
        }
    }

    private static void putArm(ArmInteractionPoint point) {
        currentArmSelection.add(point);
    }

    private static void putPipette(FluidInteractionPoint point) {
        currentPipetteSelection.add(point);
    }

    private static ArmInteractionPoint removeArm(BlockPos pos) {
        ArmInteractionPoint result = BatonInteractionHandler.getSelectedArm(pos);
        if (result != null) {
            currentArmSelection.remove(result);
        }
        return result;
    }

    private static FluidInteractionPoint removePipette(BlockPos pos) {
        FluidInteractionPoint result = BatonInteractionHandler.getSelectedPipette(pos);
        if (result != null) {
            currentPipetteSelection.remove(result);
        }
        return result;
    }

    private static ArmInteractionPoint getSelectedArm(BlockPos pos) {
        for (ArmInteractionPoint point : currentArmSelection) {
            if (!point.getPos().equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    private static FluidInteractionPoint getSelectedPipette(BlockPos pos) {
        for (FluidInteractionPoint point : currentPipetteSelection) {
            if (!point.getPos().equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    public static void cancelSelection() {
        selectedTarget = null;
        selectedTargetPos = null;
        selectedEjectorPos = null;
        ejectorTargetPos = null;
        launcher = null;
        selectionType = SelectionType.NONE;
        currentArmSelection.clear();
        currentPipetteSelection.clear();
    }

    private static void drawArmOutlines(List<ArmInteractionPoint> selection) {
        Iterator<ArmInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            ArmInteractionPoint point = iterator.next();
            if (!point.isValid()) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.m_8055_(pos = point.getPos());
            VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
            if (shape.m_83281_()) continue;
            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB((Object)point, shape.m_83215_().m_82338_(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    private static void drawPipetteOutlines(List<FluidInteractionPoint> selection) {
        Iterator<FluidInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            FluidInteractionPoint point = iterator.next();
            if (!point.isValid()) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.m_8055_(pos = point.getPos());
            VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
            if (shape.m_83281_()) continue;
            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB((Object)point, shape.m_83215_().m_82338_(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    private static enum SelectionType {
        NONE,
        ARM,
        PIPETTE,
        EJECTOR;

    }
}

