/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.config;

import com.adonis.fluid.config.CFServer;
import com.adonis.fluid.config.CFStress;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="fluid", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CFConfig {
    private static final CFServer SERVER_CONFIG;
    private static final ForgeConfigSpec SERVER_SPEC;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
    }

    public static CFServer server() {
        return SERVER_CONFIG;
    }

    public static CFStress stress() {
        return CFConfig.SERVER_CONFIG.kinetics.stressValues;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SERVER_SPEC) {
            SERVER_CONFIG.onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SERVER_SPEC) {
            SERVER_CONFIG.onReload();
        }
    }

    static {
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(builder -> {
            CFServer config = new CFServer();
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        SERVER_CONFIG = (CFServer)((Object)serverSpecPair.getLeft());
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
    }
}

