/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Pipette;

import com.adonis.fluid.block.Pipette.PipetteBlock;
import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.registry.CFPartialModels;
import com.adonis.fluid.render.PipetteFluidVisual;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmRenderer;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.util.RecyclingPoseStack;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;

public class PipetteVisual
extends SingleAxisRotatingVisual<PipetteBlockEntity>
implements SimpleDynamicVisual {
    final TransformedInstance base;
    final TransformedInstance lowerBody;
    final TransformedInstance upperBody;
    final TransformedInstance claw;
    private final ArrayList<TransformedInstance> clawGrips;
    private final ArrayList<TransformedInstance> models;
    private final boolean ceiling;
    private final RecyclingPoseStack poseStack = new RecyclingPoseStack();
    @Nullable
    private final PipetteFluidVisual fluidVisual;
    private TransformedInstance fluidInstance;
    private FluidStack lastFluid = FluidStack.EMPTY;
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public PipetteVisual(VisualizationContext context, PipetteBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick, Models.partial((PartialModel)PipetteVisual.getRotatingModel()));
        this.base = this.createSafeInstance(CFPartialModels.PIPETTE_BASE, AllPartialModels.ARM_BASE);
        this.lowerBody = this.createSafeInstance(CFPartialModels.PIPETTE_LOWER_ARM, AllPartialModels.ARM_LOWER_BODY);
        this.upperBody = this.createSafeInstance(CFPartialModels.PIPETTE_UPPER_ARM, AllPartialModels.ARM_UPPER_BODY);
        PartialModel clawModel = blockEntity.goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE;
        this.claw = this.createSafeInstance(clawModel, AllPartialModels.ARM_CLAW_BASE);
        TransformedInstance clawGrip1 = this.createSafeInstance(AllPartialModels.ARM_CLAW_GRIP_UPPER, AllPartialModels.ARM_CLAW_GRIP_UPPER);
        TransformedInstance clawGrip2 = this.createSafeInstance(AllPartialModels.ARM_CLAW_GRIP_LOWER, AllPartialModels.ARM_CLAW_GRIP_LOWER);
        this.clawGrips = Lists.newArrayList((Object[])new TransformedInstance[]{clawGrip1, clawGrip2});
        this.models = Lists.newArrayList((Object[])new TransformedInstance[]{this.base, this.lowerBody, this.upperBody, this.claw, clawGrip1, clawGrip2});
        PipetteFluidVisual tempFluidVisual = null;
        try {
            tempFluidVisual = new PipetteFluidVisual(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fluidVisual = tempFluidVisual;
        this.ceiling = (Boolean)this.blockState.m_61143_((Property)PipetteBlock.CEILING);
        PoseTransformStack msr = TransformStack.of((PoseStack)this.poseStack);
        msr.translate((Vec3i)this.getVisualPosition());
        msr.center();
        if (this.ceiling) {
            msr.rotateXDegrees(180.0f);
        }
        this.animate(partialTick);
    }

    private static PartialModel getRotatingModel() {
        try {
            if (CFPartialModels.PIPETTE_COG != null) {
                return CFPartialModels.PIPETTE_COG;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AllPartialModels.ARM_COG;
    }

    private TransformedInstance createSafeInstance(PartialModel model, PartialModel fallback) {
        PartialModel modelToUse = model;
        if (modelToUse == null) {
            modelToUse = fallback;
        }
        try {
            return (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)modelToUse)).createInstance();
        }
        catch (Exception e) {
            if (fallback != null && fallback != modelToUse) {
                try {
                    return (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)fallback)).createInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                return (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.ARM_BASE)).createInstance();
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        try {
            if (this.fluidVisual != null) {
                this.fluidVisual.begin();
            }
            this.animate(ctx.partialTick());
            if (this.fluidVisual != null) {
                this.fluidVisual.end();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void animate(float pt) {
        try {
            float baseAngleNow = ((PipetteBlockEntity)this.blockEntity).baseAngle.getValue(pt);
            float lowerArmAngleNow = ((PipetteBlockEntity)this.blockEntity).lowerArmAngle.getValue(pt);
            float upperArmAngleNow = ((PipetteBlockEntity)this.blockEntity).upperArmAngle.getValue(pt);
            float headAngleNow = ((PipetteBlockEntity)this.blockEntity).headAngle.getValue(pt);
            boolean settled = Mth.m_14033_((float)this.baseAngle, (float)baseAngleNow) && Mth.m_14033_((float)this.lowerArmAngle, (float)lowerArmAngleNow) && Mth.m_14033_((float)this.upperArmAngle, (float)upperArmAngleNow) && Mth.m_14033_((float)this.headAngle, (float)headAngleNow);
            this.baseAngle = baseAngleNow;
            this.lowerArmAngle = lowerArmAngleNow;
            this.upperArmAngle = upperArmAngleNow;
            this.headAngle = headAngleNow;
            if (!settled) {
                this.animateArm();
            }
            if (this.fluidVisual != null) {
                this.updateFluidRendering(pt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateFluidRendering(float pt) {
        if (this.fluidVisual == null) {
            return;
        }
        try {
            FluidStack currentFluid = ((PipetteBlockEntity)this.blockEntity).heldFluid;
            if (!FluidStack.areFluidStackTagsEqual((FluidStack)currentFluid, (FluidStack)this.lastFluid) || currentFluid.getAmount() != this.lastFluid.getAmount()) {
                if (this.fluidInstance != null) {
                    this.fluidInstance.delete();
                    this.fluidInstance = null;
                }
                if (!currentFluid.isEmpty()) {
                    this.fluidInstance = this.fluidVisual.createFluidInstance(currentFluid);
                    if (this.fluidInstance != null) {
                        this.models.add(this.fluidInstance);
                    }
                }
                this.lastFluid = currentFluid.copy();
            }
            if (this.fluidInstance != null && !currentFluid.isEmpty()) {
                this.updateFluidTransform(currentFluid, pt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateFluidTransform(FluidStack fluid, float pt) {
        if (this.fluidInstance == null || this.fluidVisual == null) {
            return;
        }
        try {
            this.poseStack.m_85836_();
            PoseTransformStack msr = TransformStack.of((PoseStack)this.poseStack);
            ArmRenderer.transformBase((TransformStack)msr, (float)this.baseAngle);
            ArmRenderer.transformLowerArm((TransformStack)msr, (float)(this.lowerArmAngle - 135.0f));
            ArmRenderer.transformUpperArm((TransformStack)msr, (float)(this.upperArmAngle - 90.0f));
            ArmRenderer.transformHead((TransformStack)msr, (float)this.headAngle);
            if (this.ceiling && ((PipetteBlockEntity)this.blockEntity).goggles) {
                msr.rotateZDegrees(180.0f);
            }
            this.fluidVisual.setupPipetteFluid(this.fluidInstance, fluid, ((PipetteBlockEntity)this.blockEntity).getFluidCapacity(), ((PipetteBlockEntity)this.blockEntity).isInjectMode());
            this.fluidInstance.setTransform((PoseStack)this.poseStack).setChanged();
            this.poseStack.m_85849_();
        }
        catch (Exception e) {
            this.poseStack.m_85849_();
        }
    }

    private void animateArm() {
        this.updateAngles(this.baseAngle, this.lowerArmAngle - 135.0f, this.upperArmAngle - 90.0f, this.headAngle, 0xFFFFFF);
    }

    private void updateAngles(float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, int color) {
        try {
            int[] indices;
            FluidStack fluid;
            this.poseStack.m_85836_();
            PoseTransformStack msr = TransformStack.of((PoseStack)this.poseStack);
            if (this.base != null) {
                ArmRenderer.transformBase((TransformStack)msr, (float)baseAngle);
                this.base.setTransform((PoseStack)this.poseStack).setChanged();
            }
            if (this.lowerBody != null) {
                ArmRenderer.transformLowerArm((TransformStack)msr, (float)lowerArmAngle);
                this.lowerBody.setTransform((PoseStack)this.poseStack).colorRgb(color).setChanged();
            }
            if (this.upperBody != null) {
                ArmRenderer.transformUpperArm((TransformStack)msr, (float)upperArmAngle);
                this.upperBody.setTransform((PoseStack)this.poseStack).colorRgb(color).setChanged();
            }
            if (this.claw != null) {
                ArmRenderer.transformHead((TransformStack)msr, (float)headAngle);
                if (this.ceiling && ((PipetteBlockEntity)this.blockEntity).goggles) {
                    msr.rotateZDegrees(180.0f);
                }
                this.claw.setTransform((PoseStack)this.poseStack).setChanged();
            }
            if (this.ceiling && ((PipetteBlockEntity)this.blockEntity).goggles) {
                msr.rotateZDegrees(180.0f);
            }
            boolean hasFluid = !(fluid = ((PipetteBlockEntity)this.blockEntity).heldFluid).isEmpty();
            for (int index : indices = Iterate.zeroAndOne) {
                if (index >= this.clawGrips.size() || this.clawGrips.get(index) == null) continue;
                this.poseStack.m_85836_();
                int flip = index * 2 - 1;
                this.transformPipetteGrip(msr, hasFluid, flip);
                this.clawGrips.get(index).setTransform((PoseStack)this.poseStack).setChanged();
                this.poseStack.m_85849_();
            }
            this.poseStack.m_85849_();
        }
        catch (Exception e) {
            try {
                this.poseStack.m_85849_();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void transformPipetteGrip(PoseTransformStack msr, boolean hasFluid, int flip) {
        msr.translate(0.0, (double)((float)(-flip) * 0.0625f), -0.375);
    }

    public void update(float pt) {
        try {
            super.update(pt);
            PartialModel clawModel = ((PipetteBlockEntity)this.blockEntity).goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE;
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)clawModel)).stealInstance((Instance)this.claw);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateLight(float partialTick) {
        try {
            super.updateLight(partialTick);
            FlatLit[] litModels = (FlatLit[])this.models.stream().filter(Objects::nonNull).toArray(FlatLit[]::new);
            this.relight(litModels);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void _delete() {
        try {
            super._delete();
            this.models.forEach(model -> {
                if (model != null) {
                    model.delete();
                }
            });
            if (this.fluidVisual != null) {
                this.fluidVisual.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        try {
            super.collectCrumblingInstances(consumer);
            this.models.stream().filter(Objects::nonNull).forEach(consumer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

