/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Pipette;

import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class PipetteAngleTarget {
    public static final PipetteAngleTarget NO_TARGET = new PipetteAngleTarget();
    public float baseAngle;
    public float lowerArmAngle;
    public float upperArmAngle;
    public float headAngle;

    private PipetteAngleTarget() {
        this.lowerArmAngle = 135.0f;
        this.upperArmAngle = 45.0f;
        this.headAngle = 0.0f;
    }

    public PipetteAngleTarget(BlockPos armPos, Vec3 pointTarget, Direction clawFacing, boolean ceiling) {
        Vec3 target = pointTarget;
        Vec3 origin = VecHelper.getCenterOf((Vec3i)armPos).m_82520_(0.0, ceiling ? -0.375 : 0.375, 0.0);
        Vec3 clawTarget = target;
        target = target.m_82549_(Vec3.m_82528_((Vec3i)clawFacing.m_122424_().m_122436_()).m_82490_(0.5));
        Vec3 diff = target.m_82546_(origin);
        float horizontalDistance = (float)diff.m_82542_(1.0, 0.0, 1.0).m_82553_();
        float baseAngle = AngleHelper.deg((double)Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_)) + 180.0f;
        if (ceiling) {
            diff = diff.m_82542_(1.0, -1.0, 1.0);
            baseAngle = 180.0f - baseAngle;
        }
        float alphaOffset = AngleHelper.deg((double)Mth.m_14136_((double)diff.f_82480_, (double)horizontalDistance));
        float a = 0.875f;
        float a2 = a * a;
        float b = 0.9375f;
        float b2 = b * b;
        float diffLength = Mth.m_14036_((float)Mth.m_14116_((float)((float)(diff.f_82480_ * diff.f_82480_ + (double)(horizontalDistance * horizontalDistance)))), (float)0.125f, (float)(a + b));
        float diffLength2 = diffLength * diffLength;
        float alphaRatio = (-b2 + a2 + diffLength2) / (2.0f * a * diffLength);
        float alpha = AngleHelper.deg((double)Math.acos(alphaRatio)) + alphaOffset;
        float betaRatio = (-diffLength2 + a2 + b2) / (2.0f * b * a);
        float beta = AngleHelper.deg((double)Math.acos(betaRatio));
        if (Float.isNaN(alpha)) {
            alpha = 0.0f;
        }
        if (Float.isNaN(beta)) {
            beta = 0.0f;
        }
        Vec3 headPos = new Vec3(0.0, 0.0, 0.0);
        headPos = VecHelper.rotate((Vec3)headPos.m_82520_(0.0, (double)b, 0.0), (double)(beta + 180.0f), (Direction.Axis)Direction.Axis.X);
        headPos = VecHelper.rotate((Vec3)headPos.m_82520_(0.0, (double)a, 0.0), (double)(alpha - 90.0f), (Direction.Axis)Direction.Axis.X);
        headPos = VecHelper.rotate((Vec3)headPos, (double)baseAngle, (Direction.Axis)Direction.Axis.Y);
        headPos = VecHelper.rotate((Vec3)headPos, (double)(ceiling ? 180.0 : 0.0), (Direction.Axis)Direction.Axis.X);
        headPos = headPos.m_82549_(origin);
        Vec3 headDiff = clawTarget.m_82546_(headPos);
        if (ceiling) {
            headDiff = headDiff.m_82542_(1.0, -1.0, 1.0);
        }
        float horizontalHeadDistance = (float)headDiff.m_82542_(1.0, 0.0, 1.0).m_82553_();
        float headAngle = alpha + beta + 135.0f - AngleHelper.deg((double)Mth.m_14136_((double)headDiff.f_82480_, (double)horizontalHeadDistance));
        this.lowerArmAngle = alpha;
        this.upperArmAngle = beta;
        this.headAngle = -headAngle;
        this.baseAngle = baseAngle;
    }
}

