/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CopperTap;

import com.adonis.fluid.block.CopperTap.CopperTapBlock;
import com.adonis.fluid.packet.CopperTapParticlePacket;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.behaviour.spouting.CauldronSpoutingBehavior;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class CopperTapBlockEntity
extends SmartBlockEntity {
    private FluidStack renderingFluid = FluidStack.EMPTY;
    private int processingTicks = 0;
    private static final int FILLING_TIME = 20;
    private static final int TRANSFER_RATE = 250;
    private static final int TRANSFER_INTERVAL = 10;
    private int transferCooldown = 0;
    private ItemStack processingItem = ItemStack.f_41583_;
    private boolean isFillingItem = false;
    private FluidStack pendingFluid = FluidStack.EMPTY;
    private Direction sourceDirection = null;
    private BlockPos sourceBlockPos = null;
    private int continuousProcessingDelay = 0;
    private boolean shouldDrip = false;
    private int dripTickCounter = 0;
    private FluidStack dripFluid = FluidStack.EMPTY;
    private static final int DRIP_INTERVAL = 25;
    private static final TagKey<Block> TAP_FILLABLE = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation("fluid", "tap_fillable"));

    public CopperTapBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState state = this.m_58900_();
        boolean isOpen = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        if (!isOpen) {
            boolean needsUpdate = !this.renderingFluid.isEmpty() || !this.pendingFluid.isEmpty() || this.shouldDrip;
            this.renderingFluid = FluidStack.EMPTY;
            this.pendingFluid = FluidStack.EMPTY;
            this.dripFluid = FluidStack.EMPTY;
            this.isFillingItem = false;
            this.processingTicks = 0;
            this.processingItem = ItemStack.f_41583_;
            this.sourceDirection = null;
            this.sourceBlockPos = null;
            this.continuousProcessingDelay = 0;
            this.shouldDrip = false;
            this.dripTickCounter = 0;
            this.transferCooldown = 0;
            if (needsUpdate) {
                this.notifyUpdate();
                this.m_6596_();
                if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
            }
            return;
        }
        if (this.continuousProcessingDelay > 0) {
            --this.continuousProcessingDelay;
            if (this.continuousProcessingDelay == 0) {
                this.transferCooldown = 0;
            }
            return;
        }
        if (this.transferCooldown > 0) {
            --this.transferCooldown;
        }
        if (this.isFillingItem && this.processingTicks > 0) {
            --this.processingTicks;
            if (!this.validateItemStillPresent()) {
                this.cancelItemFilling();
                return;
            }
            if (this.processingTicks == 0) {
                this.finishItemFilling();
            }
            return;
        }
        if (this.transferCooldown == 0) {
            this.tryTransferFluid();
        }
        if (this.shouldDrip) {
            ++this.dripTickCounter;
            if (this.dripTickCounter >= 25) {
                this.dripTickCounter = 0;
                this.spawnDripParticle();
            }
        }
    }

    public void onTargetChanged() {
        if (this.isFillingItem) {
            this.cancelItemFilling();
        }
        this.transferCooldown = 0;
        this.continuousProcessingDelay = 0;
        this.shouldDrip = false;
        this.dripTickCounter = 0;
        this.dripFluid = FluidStack.EMPTY;
        this.notifyUpdate();
    }

    private boolean validateItemStillPresent() {
        if (this.processingItem.m_41619_()) {
            return false;
        }
        BlockPos targetPos = this.f_58858_.m_7495_();
        BlockEntity targetEntity = this.f_58857_.m_7702_(targetPos);
        if (targetEntity == null || !this.isDepot(targetEntity)) {
            return false;
        }
        ItemStack currentItem = this.getItemOnDepot(targetEntity);
        return ItemStack.m_150942_((ItemStack)currentItem, (ItemStack)this.processingItem) && currentItem.m_41613_() >= 1;
    }

    private void cancelItemFilling() {
        this.isFillingItem = false;
        this.processingTicks = 0;
        this.processingItem = ItemStack.f_41583_;
        this.renderingFluid = FluidStack.EMPTY;
        this.pendingFluid = FluidStack.EMPTY;
        this.sourceDirection = null;
        this.sourceBlockPos = null;
        this.continuousProcessingDelay = 0;
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.25f, 2.0f);
        this.notifyUpdate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void tryTransferFluid() {
        WaterloggedLeavesFluidHandler sourceHandler;
        BlockPos sourcePos;
        Direction attached;
        block14: {
            attached = (Direction)this.m_58900_().m_61143_((Property)CopperTapBlock.FACING);
            sourcePos = this.f_58858_.m_121945_(attached.m_122424_());
            BlockState sourceState = this.f_58857_.m_8055_(sourcePos);
            sourceHandler = null;
            if (sourceState.m_204336_(BlockTags.f_13035_)) {
                if (sourceState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)sourceState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    sourceHandler = new WaterloggedLeavesFluidHandler();
                    break block14;
                } else {
                    if (this.renderingFluid.isEmpty()) {
                        if (!this.shouldDrip) return;
                    }
                    this.renderingFluid = FluidStack.EMPTY;
                    this.shouldDrip = false;
                    this.dripTickCounter = 0;
                    this.notifyUpdate();
                    return;
                }
            }
            BlockEntity sourceEntity = this.f_58857_.m_7702_(sourcePos);
            if (sourceEntity == null) {
                if (this.renderingFluid.isEmpty()) {
                    if (!this.shouldDrip) return;
                }
                this.renderingFluid = FluidStack.EMPTY;
                this.shouldDrip = false;
                this.dripTickCounter = 0;
                this.notifyUpdate();
                return;
            }
            sourceHandler = (IFluidHandler)sourceEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, attached).orElse((Object)((IFluidHandler)sourceEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)));
        }
        if (sourceHandler == null) {
            if (this.renderingFluid.isEmpty()) {
                if (!this.shouldDrip) return;
            }
            this.renderingFluid = FluidStack.EMPTY;
            this.shouldDrip = false;
            this.dripTickCounter = 0;
            this.notifyUpdate();
            return;
        }
        FluidStack availableFluid = sourceHandler.drain(1, IFluidHandler.FluidAction.SIMULATE);
        if (availableFluid.isEmpty()) {
            if (this.renderingFluid.isEmpty()) {
                if (!this.shouldDrip) return;
            }
            this.renderingFluid = FluidStack.EMPTY;
            this.shouldDrip = false;
            this.dripTickCounter = 0;
            this.notifyUpdate();
            return;
        }
        BlockPos targetPos = this.f_58858_.m_7495_();
        boolean success = this.tryProcess(sourceHandler, targetPos, attached, sourcePos);
        if (success) {
            this.transferCooldown = 5;
            if (!this.shouldDrip) return;
            this.shouldDrip = false;
            this.dripTickCounter = 0;
            this.dripFluid = FluidStack.EMPTY;
            this.notifyUpdate();
            return;
        }
        this.transferCooldown = 10;
        boolean wasNotDripping = !this.shouldDrip;
        boolean fluidChanged = false;
        FluidStack newDripFluid = availableFluid.copy();
        newDripFluid.setAmount(Math.min(newDripFluid.getAmount(), 250));
        if (!this.dripFluid.isEmpty() && !this.dripFluid.isFluidEqual(newDripFluid)) {
            fluidChanged = true;
        }
        this.dripFluid = newDripFluid;
        this.shouldDrip = true;
        if (fluidChanged) {
            this.dripTickCounter = 24;
        }
        if (this.renderingFluid.isEmpty() && !wasNotDripping) {
            if (!fluidChanged) return;
        }
        this.renderingFluid = FluidStack.EMPTY;
        this.notifyUpdate();
    }

    private void spawnDripParticle() {
        Level level;
        if (this.f_58857_ == null || !((level = this.f_58857_) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.dripFluid.isEmpty()) {
            return;
        }
        ParticleOptions fluidParticle = FluidFX.getFluidParticle((FluidStack)this.dripFluid);
        Vec3 spoutPos = Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, -0.3, 0.0);
        for (int i = 0; i < 2; ++i) {
            double yOffset = -0.05 * (double)i;
            serverLevel.m_8767_(fluidParticle, spoutPos.f_82479_, spoutPos.f_82480_ + yOffset, spoutPos.f_82481_, 1, 0.005, 0.0, 0.005, 0.005);
        }
        serverLevel.m_8767_(fluidParticle, spoutPos.f_82479_, spoutPos.f_82480_ - 0.15, spoutPos.f_82481_, 1, 0.01, 0.0, 0.01, 0.15);
        serverLevel.m_8767_(fluidParticle, spoutPos.f_82479_, spoutPos.f_82480_ - 0.3, spoutPos.f_82481_, 1, 0.015, 0.0, 0.015, 0.25);
        if (this.f_58857_.f_46441_.m_188501_() < 0.2f) {
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_144128_, SoundSource.BLOCKS, 0.2f, 0.8f + this.f_58857_.f_46441_.m_188501_() * 0.4f);
        }
    }

    private boolean tryProcess(IFluidHandler sourceHandler, BlockPos targetPos, Direction sourceDir, BlockPos sourcePos) {
        BlockEntity targetEntity = this.f_58857_.m_7702_(targetPos);
        BlockState targetState = this.f_58857_.m_8055_(targetPos);
        if (targetEntity != null && this.isDepot(targetEntity)) {
            ItemStack itemOnDepot = this.getItemOnDepot(targetEntity);
            if (!itemOnDepot.m_41619_() && FillingBySpout.canItemBeFilled((Level)this.f_58857_, (ItemStack)itemOnDepot)) {
                return this.startItemFilling(sourceHandler, targetPos, itemOnDepot, sourceDir, sourcePos);
            }
            return false;
        }
        if (targetState.m_60713_(Blocks.f_50256_) || targetState.m_60713_(Blocks.f_152476_)) {
            return this.tryFillCauldron(sourceHandler, targetPos, targetState);
        }
        if (targetState.m_204336_(TAP_FILLABLE) && targetEntity != null) {
            return this.tryFillContainer(sourceHandler, targetEntity);
        }
        return false;
    }

    private boolean tryFillCauldron(IFluidHandler sourceHandler, BlockPos targetPos, BlockState targetState) {
        FluidStack availableFluid = sourceHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (availableFluid.isEmpty()) {
            return false;
        }
        if (availableFluid.getFluid() == Fluids.f_76193_) {
            int currentLevel;
            if (targetState.m_60713_(Blocks.f_50256_)) {
                return this.fillWaterCauldronLevel(sourceHandler, targetPos, targetState, 1);
            }
            if (targetState.m_60713_(Blocks.f_152476_) && targetState.m_61138_((Property)LayeredCauldronBlock.f_153514_) && (currentLevel = ((Integer)targetState.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) < 3) {
                return this.fillWaterCauldronLevel(sourceHandler, targetPos, targetState, currentLevel + 1);
            }
            return false;
        }
        if (!targetState.m_60713_(Blocks.f_50256_)) {
            return false;
        }
        CauldronSpoutingBehavior.CauldronInfo cauldronInfo = (CauldronSpoutingBehavior.CauldronInfo)CauldronSpoutingBehavior.CAULDRON_INFO.get((Object)availableFluid.getFluid());
        if (cauldronInfo == null) {
            return false;
        }
        if (availableFluid.getAmount() < cauldronInfo.amount()) {
            return false;
        }
        FluidStack drained = sourceHandler.drain(cauldronInfo.amount(), IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty() || drained.getAmount() < cauldronInfo.amount()) {
            return false;
        }
        this.f_58857_.m_46597_(targetPos, cauldronInfo.cauldron());
        this.renderingFluid = drained.copy();
        this.f_58857_.m_5594_(null, targetPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.sendFillingParticles(targetPos, drained);
        this.notifyUpdate();
        return true;
    }

    private boolean fillWaterCauldronLevel(IFluidHandler sourceHandler, BlockPos targetPos, BlockState currentState, int targetLevel) {
        int requiredAmount = 250;
        FluidStack availableWater = sourceHandler.drain(requiredAmount, IFluidHandler.FluidAction.SIMULATE);
        if (availableWater.isEmpty() || availableWater.getAmount() < requiredAmount || availableWater.getFluid() != Fluids.f_76193_) {
            return false;
        }
        FluidStack drained = sourceHandler.drain(requiredAmount, IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty() || drained.getAmount() < requiredAmount) {
            return false;
        }
        BlockState newState = (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(targetLevel));
        this.f_58857_.m_46597_(targetPos, newState);
        this.renderingFluid = drained.copy();
        float pitch = 0.8f + (float)targetLevel * 0.1f;
        this.f_58857_.m_5594_(null, targetPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 0.5f, pitch);
        this.sendFillingParticles(targetPos, drained);
        this.notifyUpdate();
        return true;
    }

    private boolean startItemFilling(IFluidHandler sourceHandler, BlockPos targetPos, ItemStack item, Direction sourceDir, BlockPos sourcePos) {
        FluidStack availableFluid = sourceHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (availableFluid.isEmpty()) {
            return false;
        }
        int requiredAmount = FillingBySpout.getRequiredAmountForItem((Level)this.f_58857_, (ItemStack)item, (FluidStack)availableFluid);
        if (requiredAmount <= 0 || requiredAmount > availableFluid.getAmount()) {
            return false;
        }
        FluidStack simulatedDrain = sourceHandler.drain(requiredAmount, IFluidHandler.FluidAction.SIMULATE);
        if (simulatedDrain.isEmpty() || simulatedDrain.getAmount() < requiredAmount) {
            return false;
        }
        this.isFillingItem = true;
        this.processingTicks = 20;
        this.processingItem = item.m_41777_();
        this.processingItem.m_41764_(1);
        this.pendingFluid = simulatedDrain.copy();
        this.renderingFluid = simulatedDrain.copy();
        this.sourceDirection = sourceDir;
        this.sourceBlockPos = sourcePos.m_7949_();
        AllSoundEvents.SPOUTING.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.75f, 0.9f + 0.2f * this.f_58857_.f_46441_.m_188501_());
        this.sendFillingParticles(targetPos, simulatedDrain);
        this.notifyUpdate();
        return true;
    }

    private void sendFillingParticles(BlockPos targetPos, FluidStack fluid) {
        if (this.f_58857_.f_46443_ || fluid.isEmpty()) {
            return;
        }
        Vec3 startPos = Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, -0.25, 0.0);
        Vec3 endPos = Vec3.m_82512_((Vec3i)targetPos).m_82520_(0.0, 0.5, 0.0);
        AllPackets.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(targetPos)), (Object)new CopperTapParticlePacket(startPos, endPos, fluid));
    }

    private void finishItemFilling() {
        if (!this.isFillingItem || this.processingItem.m_41619_() || this.pendingFluid.isEmpty()) {
            return;
        }
        BlockPos targetPos = this.f_58858_.m_7495_();
        BlockEntity targetEntity = this.f_58857_.m_7702_(targetPos);
        if (targetEntity != null && this.isDepot(targetEntity)) {
            ItemStack itemOnDepot;
            ItemStack currentItem = this.getItemOnDepot(targetEntity);
            if (!ItemStack.m_150942_((ItemStack)currentItem, (ItemStack)this.processingItem) || currentItem.m_41613_() < 1) {
                this.cancelItemFilling();
                return;
            }
            boolean fluidConsumed = false;
            if (this.sourceBlockPos != null && this.sourceDirection != null) {
                BlockState sourceState = this.f_58857_.m_8055_(this.sourceBlockPos);
                if (sourceState.m_204336_(BlockTags.f_13035_) && sourceState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)sourceState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && this.pendingFluid.getFluid() == Fluids.f_76193_) {
                    fluidConsumed = true;
                } else {
                    FluidStack drained;
                    IFluidHandler sourceHandler;
                    BlockEntity sourceEntity = this.f_58857_.m_7702_(this.sourceBlockPos);
                    if (sourceEntity != null && (sourceHandler = (IFluidHandler)sourceEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, this.sourceDirection).orElse((Object)((IFluidHandler)sourceEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)))) != null && !(drained = sourceHandler.drain(this.pendingFluid, IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drained.getAmount() >= this.pendingFluid.getAmount()) {
                        fluidConsumed = true;
                    }
                }
            }
            if (!fluidConsumed) {
                this.cancelItemFilling();
                return;
            }
            DepotBehaviour behaviour = (DepotBehaviour)DepotBehaviour.get((BlockEntity)targetEntity, (BehaviourType)DepotBehaviour.TYPE);
            if (behaviour != null && !(itemOnDepot = behaviour.getHeldItemStack()).m_41619_()) {
                ItemStack singleItem = itemOnDepot.m_41777_();
                singleItem.m_41764_(1);
                ItemStack result = FillingBySpout.fillItem((Level)this.f_58857_, (int)this.pendingFluid.getAmount(), (ItemStack)singleItem, (FluidStack)this.pendingFluid);
                if (!result.m_41619_()) {
                    itemOnDepot.m_41774_(1);
                    if (itemOnDepot.m_41619_()) {
                        TransportedItemStack resultTIS = new TransportedItemStack(result);
                        behaviour.setHeldItem(resultTIS);
                    } else {
                        TransportedItemStack updatedTIS = new TransportedItemStack(itemOnDepot);
                        behaviour.setHeldItem(updatedTIS);
                        try {
                            Field bufferField = DepotBehaviour.class.getDeclaredField("processingOutputBuffer");
                            bufferField.setAccessible(true);
                            ItemStackHandler outputBuffer = (ItemStackHandler)bufferField.get(behaviour);
                            ItemStack remainder = result.m_41777_();
                            for (int slot = 0; slot < outputBuffer.getSlots() && !remainder.m_41619_(); ++slot) {
                                remainder = outputBuffer.insertItem(slot, remainder, false);
                            }
                            if (!remainder.m_41619_()) {
                                Vec3 dropPos = Vec3.m_82512_((Vec3i)targetPos);
                                Containers.m_18992_((Level)this.f_58857_, (double)dropPos.f_82479_, (double)(dropPos.f_82480_ + 0.5), (double)dropPos.f_82481_, (ItemStack)remainder);
                            }
                        }
                        catch (Exception e) {
                            Vec3 dropPos = Vec3.m_82512_((Vec3i)targetPos);
                            Containers.m_18992_((Level)this.f_58857_, (double)dropPos.f_82479_, (double)(dropPos.f_82480_ + 0.5), (double)dropPos.f_82481_, (ItemStack)result);
                        }
                    }
                    targetEntity.m_6596_();
                    if (!this.f_58857_.f_46443_) {
                        this.f_58857_.m_7260_(targetPos, targetEntity.m_58900_(), targetEntity.m_58900_(), 3);
                        if (targetEntity instanceof SmartBlockEntity) {
                            SmartBlockEntity smartBE = (SmartBlockEntity)targetEntity;
                            smartBE.notifyUpdate();
                        }
                    }
                    this.f_58857_.m_5594_(null, targetPos, SoundEvents.f_11770_, SoundSource.BLOCKS, 0.5f, 1.0f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
                    this.sendFillingParticles(targetPos, this.renderingFluid);
                    if (itemOnDepot.m_41619_() && FillingBySpout.canItemBeFilled((Level)this.f_58857_, (ItemStack)result)) {
                        this.continuousProcessingDelay = 0;
                        this.isFillingItem = false;
                        this.processingTicks = 0;
                        this.processingItem = ItemStack.f_41583_;
                        this.renderingFluid = FluidStack.EMPTY;
                        this.pendingFluid = FluidStack.EMPTY;
                        this.notifyUpdate();
                        return;
                    }
                }
            }
        }
        this.isFillingItem = false;
        this.processingTicks = 0;
        this.processingItem = ItemStack.f_41583_;
        this.renderingFluid = FluidStack.EMPTY;
        this.pendingFluid = FluidStack.EMPTY;
        this.sourceDirection = null;
        this.sourceBlockPos = null;
        this.continuousProcessingDelay = 0;
        this.notifyUpdate();
    }

    private boolean tryFillContainer(IFluidHandler sourceHandler, BlockEntity targetEntity) {
        IFluidHandler targetHandler = (IFluidHandler)targetEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).orElse((Object)((IFluidHandler)targetEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)));
        if (targetHandler == null) {
            return false;
        }
        FluidStack drain = sourceHandler.drain(250, IFluidHandler.FluidAction.SIMULATE);
        if (drain.isEmpty()) {
            return false;
        }
        int filled = targetHandler.fill(drain, IFluidHandler.FluidAction.SIMULATE);
        if (filled <= 0) {
            return false;
        }
        FluidStack actualDrain = sourceHandler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
        if (actualDrain.isEmpty()) {
            return false;
        }
        targetHandler.fill(actualDrain, IFluidHandler.FluidAction.EXECUTE);
        this.renderingFluid = actualDrain.copy();
        if (this.f_58857_.f_46441_.m_188501_() < 0.1f) {
            AllSoundEvents.SPOUTING.playOnServer(this.f_58857_, (Vec3i)this.f_58858_, 0.3f, 0.9f + 0.2f * this.f_58857_.f_46441_.m_188501_());
        }
        this.sendFillingParticles(targetEntity.m_58899_(), actualDrain);
        this.notifyUpdate();
        return true;
    }

    private boolean isDepot(BlockEntity entity) {
        return entity.getClass().getSimpleName().toLowerCase().contains("depot");
    }

    private ItemStack getItemOnDepot(BlockEntity depot) {
        IItemHandler handler;
        if (depot instanceof DepotBlockEntity) {
            DepotBlockEntity depotEntity = (DepotBlockEntity)depot;
            return depotEntity.getHeldItem();
        }
        DepotBehaviour behaviour = (DepotBehaviour)DepotBehaviour.get((BlockEntity)depot, (BehaviourType)DepotBehaviour.TYPE);
        if (behaviour != null) {
            return behaviour.getHeldItemStack();
        }
        if (depot.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).isPresent() && (handler = (IItemHandler)depot.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).resolve().get()).getSlots() > 0) {
            return handler.getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (!this.renderingFluid.isEmpty()) {
            tag.m_128365_("RenderingFluid", (Tag)this.renderingFluid.writeToNBT(new CompoundTag()));
        }
        if (!this.pendingFluid.isEmpty()) {
            tag.m_128365_("PendingFluid", (Tag)this.pendingFluid.writeToNBT(new CompoundTag()));
        }
        if (!this.dripFluid.isEmpty()) {
            tag.m_128365_("DripFluid", (Tag)this.dripFluid.writeToNBT(new CompoundTag()));
        }
        tag.m_128379_("IsFillingItem", this.isFillingItem);
        tag.m_128405_("ProcessingTicks", this.processingTicks);
        tag.m_128405_("TransferCooldown", this.transferCooldown);
        tag.m_128405_("ContinuousProcessingDelay", this.continuousProcessingDelay);
        tag.m_128379_("ShouldDrip", this.shouldDrip);
        tag.m_128405_("DripTickCounter", this.dripTickCounter);
        if (!this.processingItem.m_41619_()) {
            tag.m_128365_("ProcessingItem", (Tag)this.processingItem.m_41739_(new CompoundTag()));
        }
        if (this.sourceDirection != null) {
            tag.m_128405_("SourceDirection", this.sourceDirection.m_122411_());
        }
        if (this.sourceBlockPos != null) {
            tag.m_128356_("SourcePos", this.sourceBlockPos.m_121878_());
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.renderingFluid = tag.m_128441_("RenderingFluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("RenderingFluid")) : FluidStack.EMPTY;
        this.pendingFluid = tag.m_128441_("PendingFluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("PendingFluid")) : FluidStack.EMPTY;
        this.dripFluid = tag.m_128441_("DripFluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("DripFluid")) : FluidStack.EMPTY;
        this.isFillingItem = tag.m_128471_("IsFillingItem");
        this.processingTicks = tag.m_128451_("ProcessingTicks");
        this.transferCooldown = tag.m_128451_("TransferCooldown");
        this.continuousProcessingDelay = tag.m_128451_("ContinuousProcessingDelay");
        this.shouldDrip = tag.m_128471_("ShouldDrip");
        this.dripTickCounter = tag.m_128451_("DripTickCounter");
        this.processingItem = tag.m_128441_("ProcessingItem") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("ProcessingItem")) : ItemStack.f_41583_;
        this.sourceDirection = tag.m_128441_("SourceDirection") ? Direction.m_122376_((int)tag.m_128451_("SourceDirection")) : null;
        this.sourceBlockPos = tag.m_128441_("SourcePos") ? BlockPos.m_122022_((long)tag.m_128454_("SourcePos")) : null;
    }

    public FluidStack getRenderingFluid() {
        return this.renderingFluid;
    }

    public int getProcessingTicks() {
        return this.processingTicks;
    }

    public boolean isProcessing() {
        return this.isFillingItem && this.processingTicks > 0;
    }

    public boolean hasFluidToRender() {
        return !this.renderingFluid.isEmpty();
    }

    public boolean shouldDrip() {
        return this.shouldDrip;
    }

    private static class WaterloggedLeavesFluidHandler
    implements IFluidHandler {
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.f_76193_, 1000);

        private WaterloggedLeavesFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return WATER.copy();
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Fluids.f_76193_) {
                return new FluidStack((Fluid)Fluids.f_76193_, Math.min(resource.getAmount(), 1000));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.f_76193_, Math.min(maxDrain, 1000));
        }
    }
}

